/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public class Path {
    private final Node[] nodes;
    public final int length;
    private int pos;

    public Path(Node[] nodeArray) {
        this.nodes = nodeArray;
        this.length = nodeArray.length;
    }

    public Node current() {
        return this.nodes[this.pos];
    }

    public void next() {
        ++this.pos;
    }

    public boolean isDone() {
        return this.pos >= this.nodes.length;
    }

    public Node get(int n) {
        return this.nodes[n];
    }

    public Vec3 current(Entity entity) {
        double d = (double)this.nodes[this.pos].x + (double)((int)(entity.bbWidth + 1.0f)) * 0.5;
        double d2 = this.nodes[this.pos].y;
        double d3 = (double)this.nodes[this.pos].z + (double)((int)(entity.bbWidth + 1.0f)) * 0.5;
        return Vec3.newTemp(d, d2, d3);
    }
}

