/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import util.Mth;

public class Node {
    public final int x;
    public final int y;
    public final int z;
    public final int hash;
    int heapIdx = -1;
    float g;
    float h;
    float f;
    Node cameFrom;
    public boolean closed = false;

    public Node(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.hash = n | n2 << 10 | n3 << 20;
    }

    public float distanceTo(Node node) {
        float f = node.x - this.x;
        float f2 = node.y - this.y;
        float f3 = node.z - this.z;
        return Mth.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public boolean equals(Object object) {
        return ((Node)object).hash == this.hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean inOpenSet() {
        return this.heapIdx >= 0;
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }
}

