/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import java.util.Random;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.level.levelgen.synth.Synth;

public class PerlinSimplexNoise
extends Synth {
    private SimplexNoise[] noiseLevels;
    private int levels;

    public PerlinSimplexNoise(int n) {
        this(new Random(), n);
    }

    public PerlinSimplexNoise(Random random, int n) {
        this.levels = n;
        this.noiseLevels = new SimplexNoise[n];
        for (int i = 0; i < n; ++i) {
            this.noiseLevels[i] = new SimplexNoise(random);
        }
    }

    public double getValue(double d, double d2) {
        double d3 = 0.0;
        double d4 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            d3 += this.noiseLevels[i].getValue(d * d4, d2 * d4) / d4;
            d4 /= 2.0;
        }
        return d3;
    }

    public double getValue(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            d4 += this.noiseLevels[i].getValue(d * d5, d2 * d5, d3 * d5) / d5;
            d5 /= 2.0;
        }
        return d4;
    }

    public double[] getRegion(double[] dArray, double d, double d2, int n, int n2, double d3, double d4, double d5) {
        return this.getRegion(dArray, d, d2, n, n2, d3, d4, d5, 0.5);
    }

    public double[] getRegion(double[] dArray, double d, double d2, int n, int n2, double d3, double d4, double d5, double d6) {
        d3 /= 1.5;
        d4 /= 1.5;
        if (dArray == null || dArray.length < n * n2) {
            dArray = new double[n * n2];
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 0.0;
            }
        }
        double d7 = 1.0;
        double d8 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            this.noiseLevels[i].add(dArray, d, d2, n, n2, d3 * d8, d4 * d8, 0.55 / d7);
            d8 *= d5;
            d7 *= d6;
        }
        return dArray;
    }

    public double[] getRegion(double[] dArray, double d, double d2, double d3, int n, int n2, int n3, double d4, double d5, double d6) {
        d4 /= 1.5;
        d5 /= 1.5;
        if (dArray == null) {
            dArray = new double[n * n2 * n3];
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 0.0;
            }
        }
        double d7 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            this.noiseLevels[i].add(dArray, d, d2, d3, n, n2, n3, d4 * d7, d5 * d7, d6 * d7, 0.55 / d7);
            d7 *= 0.5;
        }
        return dArray;
    }
}

