/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import java.util.Random;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.levelgen.synth.Synth;

public class PerlinNoise
extends Synth {
    private ImprovedNoise[] noiseLevels;
    private int levels;

    public PerlinNoise(int n) {
        this(new Random(), n);
    }

    public PerlinNoise(Random random, int n) {
        this.levels = n;
        this.noiseLevels = new ImprovedNoise[n];
        for (int i = 0; i < n; ++i) {
            this.noiseLevels[i] = new ImprovedNoise(random);
        }
    }

    public double getValue(double d, double d2) {
        double d3 = 0.0;
        double d4 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            d3 += this.noiseLevels[i].getValue(d * d4, d2 * d4) / d4;
            d4 /= 2.0;
        }
        return d3;
    }

    public double getValue(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            d4 += this.noiseLevels[i].getValue(d * d5, d2 * d5, d3 * d5) / d5;
            d5 /= 2.0;
        }
        return d4;
    }

    public double[] getRegion(double[] dArray, double d, double d2, double d3, int n, int n2, int n3, double d4, double d5, double d6) {
        if (dArray == null) {
            dArray = new double[n * n2 * n3];
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 0.0;
            }
        }
        double d7 = 1.0;
        for (int i = 0; i < this.levels; ++i) {
            this.noiseLevels[i].add(dArray, d, d2, d3, n, n2, n3, d4 * d7, d5 * d7, d6 * d7, d7);
            d7 /= 2.0;
        }
        return dArray;
    }

    public double[] getRegion(double[] dArray, int n, int n2, int n3, int n4, double d, double d2, double d3) {
        return this.getRegion(dArray, n, 10.0, n2, n3, 1, n4, d, 1.0, d2);
    }
}

