/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import java.util.Random;
import net.minecraft.world.level.levelgen.synth.Synth;

public class ImprovedNoise
extends Synth {
    private int[] p = new int[512];
    public double scale;
    public double xo;
    public double yo;
    public double zo;

    public ImprovedNoise() {
        this(new Random());
    }

    public ImprovedNoise(Random random) {
        int n;
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        for (n = 0; n < 256; ++n) {
            this.p[n] = n;
        }
        for (n = 0; n < 256; ++n) {
            int n2 = random.nextInt(256 - n) + n;
            int n3 = this.p[n];
            this.p[n] = this.p[n2];
            this.p[n2] = n3;
            this.p[n + 256] = this.p[n];
        }
    }

    public double noise(double d, double d2, double d3) {
        double d4 = d + this.xo;
        double d5 = d2 + this.yo;
        double d6 = d3 + this.zo;
        int n = (int)d4;
        int n2 = (int)d5;
        int n3 = (int)d6;
        if (d4 < (double)n) {
            --n;
        }
        if (d5 < (double)n2) {
            --n2;
        }
        if (d6 < (double)n3) {
            --n3;
        }
        int n4 = n & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = n3 & 0xFF;
        double d7 = (d4 -= (double)n) * d4 * d4 * (d4 * (d4 * 6.0 - 15.0) + 10.0);
        double d8 = (d5 -= (double)n2) * d5 * d5 * (d5 * (d5 * 6.0 - 15.0) + 10.0);
        double d9 = (d6 -= (double)n3) * d6 * d6 * (d6 * (d6 * 6.0 - 15.0) + 10.0);
        int n7 = this.p[n4] + n5;
        int n8 = this.p[n7] + n6;
        int n9 = this.p[n7 + 1] + n6;
        int n10 = this.p[n4 + 1] + n5;
        int n11 = this.p[n10] + n6;
        int n12 = this.p[n10 + 1] + n6;
        return this.lerp(d9, this.lerp(d8, this.lerp(d7, this.grad(this.p[n8], d4, d5, d6), this.grad(this.p[n11], d4 - 1.0, d5, d6)), this.lerp(d7, this.grad(this.p[n9], d4, d5 - 1.0, d6), this.grad(this.p[n12], d4 - 1.0, d5 - 1.0, d6))), this.lerp(d8, this.lerp(d7, this.grad(this.p[n8 + 1], d4, d5, d6 - 1.0), this.grad(this.p[n11 + 1], d4 - 1.0, d5, d6 - 1.0)), this.lerp(d7, this.grad(this.p[n9 + 1], d4, d5 - 1.0, d6 - 1.0), this.grad(this.p[n12 + 1], d4 - 1.0, d5 - 1.0, d6 - 1.0))));
    }

    public final double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    public final double grad2(int n, double d, double d2) {
        int n2 = n & 0xF;
        double d3 = (double)(1 - ((n2 & 8) >> 3)) * d;
        double d4 = n2 < 4 ? 0.0 : (n2 == 12 || n2 == 14 ? d : d2);
        return ((n2 & 1) == 0 ? d3 : -d3) + ((n2 & 2) == 0 ? d4 : -d4);
    }

    public final double grad(int n, double d, double d2, double d3) {
        double d4;
        int n2 = n & 0xF;
        double d5 = d4 = n2 < 8 ? d : d2;
        double d6 = n2 < 4 ? d2 : (n2 == 12 || n2 == 14 ? d : d3);
        return ((n2 & 1) == 0 ? d4 : -d4) + ((n2 & 2) == 0 ? d6 : -d6);
    }

    public double getValue(double d, double d2) {
        return this.noise(d, d2, 0.0);
    }

    public double getValue(double d, double d2, double d3) {
        return this.noise(d, d2, d3);
    }

    public void add(double[] dArray, double d, double d2, double d3, int n, int n2, int n3, double d4, double d5, double d6, double d7) {
        if (n2 == 1) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            double d8 = 0.0;
            double d9 = 0.0;
            int n8 = 0;
            double d10 = 1.0 / d7;
            for (int i = 0; i < n; ++i) {
                double d11 = (d + (double)i) * d4 + this.xo;
                int n9 = (int)d11;
                if (d11 < (double)n9) {
                    --n9;
                }
                int n10 = n9 & 0xFF;
                double d12 = (d11 -= (double)n9) * d11 * d11 * (d11 * (d11 * 6.0 - 15.0) + 10.0);
                for (int j = 0; j < n3; ++j) {
                    double d13 = (d3 + (double)j) * d6 + this.zo;
                    int n11 = (int)d13;
                    if (d13 < (double)n11) {
                        --n11;
                    }
                    int n12 = n11 & 0xFF;
                    double d14 = (d13 -= (double)n11) * d13 * d13 * (d13 * (d13 * 6.0 - 15.0) + 10.0);
                    n4 = this.p[n10] + 0;
                    n5 = this.p[n4] + n12;
                    n6 = this.p[n10 + 1] + 0;
                    n7 = this.p[n6] + n12;
                    d8 = this.lerp(d12, this.grad2(this.p[n5], d11, d13), this.grad(this.p[n7], d11 - 1.0, 0.0, d13));
                    d9 = this.lerp(d12, this.grad(this.p[n5 + 1], d11, 0.0, d13 - 1.0), this.grad(this.p[n7 + 1], d11 - 1.0, 0.0, d13 - 1.0));
                    double d15 = this.lerp(d14, d8, d9);
                    int n13 = n8++;
                    dArray[n13] = dArray[n13] + d15 * d10;
                }
            }
            return;
        }
        int n14 = 0;
        double d16 = 1.0 / d7;
        int n15 = -1;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d21 = (d + (double)i) * d4 + this.xo;
            int n22 = (int)d21;
            if (d21 < (double)n22) {
                --n22;
            }
            int n23 = n22 & 0xFF;
            double d22 = (d21 -= (double)n22) * d21 * d21 * (d21 * (d21 * 6.0 - 15.0) + 10.0);
            for (int j = 0; j < n3; ++j) {
                double d23 = (d3 + (double)j) * d6 + this.zo;
                int n24 = (int)d23;
                if (d23 < (double)n24) {
                    --n24;
                }
                int n25 = n24 & 0xFF;
                double d24 = (d23 -= (double)n24) * d23 * d23 * (d23 * (d23 * 6.0 - 15.0) + 10.0);
                for (int k = 0; k < n2; ++k) {
                    double d25 = (d2 + (double)k) * d5 + this.yo;
                    int n26 = (int)d25;
                    if (d25 < (double)n26) {
                        --n26;
                    }
                    int n27 = n26 & 0xFF;
                    double d26 = (d25 -= (double)n26) * d25 * d25 * (d25 * (d25 * 6.0 - 15.0) + 10.0);
                    if (k == 0 || n27 != n15) {
                        n15 = n27;
                        n16 = this.p[n23] + n27;
                        n17 = this.p[n16] + n25;
                        n18 = this.p[n16 + 1] + n25;
                        n19 = this.p[n23 + 1] + n27;
                        n20 = this.p[n19] + n25;
                        n21 = this.p[n19 + 1] + n25;
                        d17 = this.lerp(d22, this.grad(this.p[n17], d21, d25, d23), this.grad(this.p[n20], d21 - 1.0, d25, d23));
                        d18 = this.lerp(d22, this.grad(this.p[n18], d21, d25 - 1.0, d23), this.grad(this.p[n21], d21 - 1.0, d25 - 1.0, d23));
                        d19 = this.lerp(d22, this.grad(this.p[n17 + 1], d21, d25, d23 - 1.0), this.grad(this.p[n20 + 1], d21 - 1.0, d25, d23 - 1.0));
                        d20 = this.lerp(d22, this.grad(this.p[n18 + 1], d21, d25 - 1.0, d23 - 1.0), this.grad(this.p[n21 + 1], d21 - 1.0, d25 - 1.0, d23 - 1.0));
                    }
                    double d27 = this.lerp(d26, d17, d18);
                    double d28 = this.lerp(d26, d19, d20);
                    double d29 = this.lerp(d24, d27, d28);
                    int n28 = n14++;
                    dArray[n28] = dArray[n28] + d29 * d16;
                }
            }
        }
    }
}

