/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class LakeFeature
extends Feature {
    private int tile;

    public LakeFeature(int n) {
        this.tile = n;
    }

    public boolean place(Level level, Random random, int n, int n2, int n3) {
        int n4;
        int n5;
        n -= 8;
        n3 -= 8;
        while (n2 > 0 && level.isEmptyTile(n, n2, n3)) {
            --n2;
        }
        n2 -= 4;
        boolean[] blArray = new boolean[2048];
        int n6 = random.nextInt(4) + 4;
        for (n5 = 0; n5 < n6; ++n5) {
            double d = random.nextDouble() * 6.0 + 3.0;
            double d2 = random.nextDouble() * 4.0 + 2.0;
            double d3 = random.nextDouble() * 6.0 + 3.0;
            double d4 = random.nextDouble() * (16.0 - d - 2.0) + 1.0 + d / 2.0;
            double d5 = random.nextDouble() * (8.0 - d2 - 4.0) + 2.0 + d2 / 2.0;
            double d6 = random.nextDouble() * (16.0 - d3 - 2.0) + 1.0 + d3 / 2.0;
            for (int i = 1; i < 15; ++i) {
                for (int j = 1; j < 15; ++j) {
                    for (int k = 1; k < 7; ++k) {
                        double d7 = ((double)i - d4) / (d / 2.0);
                        double d8 = ((double)k - d5) / (d2 / 2.0);
                        double d9 = ((double)j - d6) / (d3 / 2.0);
                        double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (!(d10 < 1.0)) continue;
                        blArray[(i * 16 + j) * 8 + k] = true;
                    }
                }
            }
        }
        for (n5 = 0; n5 < 16; ++n5) {
            for (int i = 0; i < 16; ++i) {
                for (n4 = 0; n4 < 8; ++n4) {
                    boolean bl;
                    boolean bl2 = bl = !blArray[(n5 * 16 + i) * 8 + n4] && (n5 < 15 && blArray[((n5 + 1) * 16 + i) * 8 + n4] || n5 > 0 && blArray[((n5 - 1) * 16 + i) * 8 + n4] || i < 15 && blArray[(n5 * 16 + (i + 1)) * 8 + n4] || i > 0 && blArray[(n5 * 16 + (i - 1)) * 8 + n4] || n4 < 7 && blArray[(n5 * 16 + i) * 8 + (n4 + 1)] || n4 > 0 && blArray[(n5 * 16 + i) * 8 + (n4 - 1)]);
                    if (!bl) continue;
                    Material material = level.getMaterial(n + n5, n2 + n4, n3 + i);
                    if (n4 >= 4 && material.isLiquid()) {
                        return false;
                    }
                    if (n4 >= 4 || material.isSolid() || level.getTile(n + n5, n2 + n4, n3 + i) == this.tile) continue;
                    return false;
                }
            }
        }
        for (n5 = 0; n5 < 16; ++n5) {
            for (int i = 0; i < 16; ++i) {
                for (n4 = 0; n4 < 8; ++n4) {
                    if (!blArray[(n5 * 16 + i) * 8 + n4]) continue;
                    level.setTileNoUpdate(n + n5, n2 + n4, n3 + i, n4 >= 4 ? 0 : this.tile);
                }
            }
        }
        for (n5 = 0; n5 < 16; ++n5) {
            for (int i = 0; i < 16; ++i) {
                for (n4 = 4; n4 < 8; ++n4) {
                    if (!blArray[(n5 * 16 + i) * 8 + n4] || level.getTile(n + n5, n2 + n4 - 1, n3 + i) != Tile.dirt.id || level.getBrightness(LightLayer.Sky, n + n5, n2 + n4, n3 + i) <= 0) continue;
                    level.setTileNoUpdate(n + n5, n2 + n4 - 1, n3 + i, Tile.grass.id);
                }
            }
        }
        if (Tile.tiles[this.tile].material == Material.lava) {
            for (n5 = 0; n5 < 16; ++n5) {
                for (int i = 0; i < 16; ++i) {
                    for (n4 = 0; n4 < 8; ++n4) {
                        boolean bl;
                        boolean bl3 = bl = !blArray[(n5 * 16 + i) * 8 + n4] && (n5 < 15 && blArray[((n5 + 1) * 16 + i) * 8 + n4] || n5 > 0 && blArray[((n5 - 1) * 16 + i) * 8 + n4] || i < 15 && blArray[(n5 * 16 + (i + 1)) * 8 + n4] || i > 0 && blArray[(n5 * 16 + (i - 1)) * 8 + n4] || n4 < 7 && blArray[(n5 * 16 + i) * 8 + (n4 + 1)] || n4 > 0 && blArray[(n5 * 16 + i) * 8 + (n4 - 1)]);
                        if (!bl || n4 >= 4 && random.nextInt(2) == 0 || !level.getMaterial(n + n5, n2 + n4, n3 + i).isSolid()) continue;
                        level.setTileNoUpdate(n + n5, n2 + n4, n3 + i, Tile.rock.id);
                    }
                }
            }
        }
        return true;
    }
}

