/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class ClayFeature
extends Feature {
    private int tile;
    private int count;

    public ClayFeature(int n) {
        this.tile = Tile.clay.id;
        this.count = n;
    }

    public boolean place(Level level, Random random, int n, int n2, int n3) {
        if (level.getMaterial(n, n2, n3) != Material.water) {
            return false;
        }
        float f = random.nextFloat() * (float)Math.PI;
        double d = (float)(n + 8) + Mth.sin(f) * (float)this.count / 8.0f;
        double d2 = (float)(n + 8) - Mth.sin(f) * (float)this.count / 8.0f;
        double d3 = (float)(n3 + 8) + Mth.cos(f) * (float)this.count / 8.0f;
        double d4 = (float)(n3 + 8) - Mth.cos(f) * (float)this.count / 8.0f;
        double d5 = n2 + random.nextInt(3) + 2;
        double d6 = n2 + random.nextInt(3) + 2;
        for (int i = 0; i <= this.count; ++i) {
            double d7 = d + (d2 - d) * (double)i / (double)this.count;
            double d8 = d5 + (d6 - d5) * (double)i / (double)this.count;
            double d9 = d3 + (d4 - d3) * (double)i / (double)this.count;
            double d10 = random.nextDouble() * (double)this.count / 16.0;
            double d11 = (double)(Mth.sin((float)i * (float)Math.PI / (float)this.count) + 1.0f) * d10 + 1.0;
            double d12 = (double)(Mth.sin((float)i * (float)Math.PI / (float)this.count) + 1.0f) * d10 + 1.0;
            for (int j = (int)(d7 - d11 / 2.0); j <= (int)(d7 + d11 / 2.0); ++j) {
                for (int k = (int)(d8 - d12 / 2.0); k <= (int)(d8 + d12 / 2.0); ++k) {
                    for (int i2 = (int)(d9 - d11 / 2.0); i2 <= (int)(d9 + d11 / 2.0); ++i2) {
                        int n4;
                        double d13 = ((double)j + 0.5 - d7) / (d11 / 2.0);
                        double d14 = ((double)k + 0.5 - d8) / (d12 / 2.0);
                        double d15 = ((double)i2 + 0.5 - d9) / (d11 / 2.0);
                        if (!(d13 * d13 + d14 * d14 + d15 * d15 < 1.0) || (n4 = level.getTile(j, k, i2)) != Tile.sand.id) continue;
                        level.setTileNoUpdate(j, k, i2, this.tile);
                    }
                }
            }
        }
        return true;
    }
}

