/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TilePos;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class CaveFeature
extends Feature {
    public boolean place(Level level, Random random, int n, int n2, int n3) {
        int n4;
        float f = random.nextFloat() * (float)Math.PI;
        double d = 8.0;
        double d2 = (double)(n + 8) + (double)Mth.sin(f) * d;
        double d3 = (double)(n + 8) - (double)Mth.sin(f) * d;
        double d4 = (double)(n3 + 8) + (double)Mth.cos(f) * d;
        double d5 = (double)(n3 + 8) - (double)Mth.cos(f) * d;
        double d6 = n2 + random.nextInt(8) + 2;
        double d7 = n2 + random.nextInt(8) + 2;
        double d8 = random.nextDouble() * 4.0 + 2.0;
        double d9 = random.nextDouble() * 0.6;
        long l = random.nextLong();
        random.setSeed(l);
        ArrayList<TilePos> arrayList = new ArrayList<TilePos>();
        for (n4 = 0; n4 <= 16; ++n4) {
            double d10 = d2 + (d3 - d2) * (double)n4 / 16.0;
            double d11 = d6 + (d7 - d6) * (double)n4 / 16.0;
            double d12 = d4 + (d5 - d4) * (double)n4 / 16.0;
            double d13 = random.nextDouble();
            double d14 = ((double)Mth.sin((float)n4 / 16.0f * (float)Math.PI) * d8 + 1.0) * d13 + 1.0;
            double d15 = ((double)Mth.sin((float)n4 / 16.0f * (float)Math.PI) * d8 + 1.0) * d13 + 1.0;
            for (int i = (int)(d10 - d14 / 2.0); i <= (int)(d10 + d14 / 2.0); ++i) {
                for (int j = (int)(d11 - d15 / 2.0); j <= (int)(d11 + d15 / 2.0); ++j) {
                    for (int k = (int)(d12 - d14 / 2.0); k <= (int)(d12 + d14 / 2.0); ++k) {
                        double d16 = ((double)i + 0.5 - d10) / (d14 / 2.0);
                        double d17 = ((double)j + 0.5 - d11) / (d15 / 2.0);
                        double d18 = ((double)k + 0.5 - d12) / (d14 / 2.0);
                        if (!(d16 * d16 + d17 * d17 + d18 * d18 < random.nextDouble() * d9 + (1.0 - d9)) || level.isEmptyTile(i, j, k)) continue;
                        for (int i2 = i - 2; i2 <= i + 1; ++i2) {
                            for (int i3 = j - 1; i3 <= j + 1; ++i3) {
                                for (int i4 = k - 1; i4 <= k + 1; ++i4) {
                                    if (i2 <= n || i4 <= n3 || i2 >= n + 16 - 1 || i4 >= n3 + 16 - 1) {
                                        return false;
                                    }
                                    if (!level.getMaterial(i2, i3, i4).isLiquid()) continue;
                                    return false;
                                }
                            }
                        }
                        arrayList.add(new TilePos(i, j, k));
                    }
                }
            }
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            TilePos tilePos = (TilePos)arrayList.get(n4);
            level.setTileNoUpdate(tilePos.x, tilePos.y, tilePos.z, 0);
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            TilePos tilePos = (TilePos)arrayList.get(n4);
            if (level.getTile(tilePos.x, tilePos.y - 1, tilePos.z) != Tile.dirt.id || level.getRawBrightness(tilePos.x, tilePos.y, tilePos.z) <= 8) continue;
            level.setTileNoUpdate(tilePos.x, tilePos.y - 1, tilePos.z, Tile.grass.id);
        }
        return true;
    }
}

