/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.Feature;
import util.Mth;

public class BasicTree
extends Feature {
    static final byte[] axisConversionArray = new byte[]{2, 0, 0, 1, 2, 1};
    Random rnd = new Random();
    Level thisLevel;
    int[] origin = new int[]{0, 0, 0};
    int height = 0;
    int trunkHeight;
    double trunkHeightScale = 0.618;
    double branchDensity = 1.0;
    double branchSlope = 0.381;
    double widthScale = 1.0;
    double foliageDensity = 1.0;
    int trunkWidth = 1;
    int heightVariance = 12;
    int foliageHeight = 4;
    int[][] foliageCoords;

    void prepare() {
        int n;
        this.trunkHeight = (int)((double)this.height * this.trunkHeightScale);
        if (this.trunkHeight >= this.height) {
            this.trunkHeight = this.height - 1;
        }
        if ((n = (int)(1.382 + Math.pow(this.foliageDensity * (double)this.height / 13.0, 2.0))) < 1) {
            n = 1;
        }
        int[][] nArray = new int[n * this.height][4];
        int n2 = this.origin[1] + this.height - this.foliageHeight;
        int n3 = 1;
        int n4 = this.origin[1] + this.trunkHeight;
        int n5 = n2 - this.origin[1];
        nArray[0][0] = this.origin[0];
        nArray[0][1] = n2--;
        nArray[0][2] = this.origin[2];
        nArray[0][3] = n4;
        while (n5 >= 0) {
            float f = this.treeShape(n5);
            if (f < 0.0f) {
                --n2;
                --n5;
                continue;
            }
            double d = 0.5;
            for (int i = 0; i < n; ++i) {
                int[] nArray2;
                int n6;
                double d2;
                double d3 = this.widthScale * ((double)f * ((double)this.rnd.nextFloat() + 0.328));
                int n7 = (int)(d3 * Math.sin(d2 = (double)this.rnd.nextFloat() * 2.0 * 3.14159) + (double)this.origin[0] + d);
                int[] nArray3 = new int[]{n7, n2, n6 = (int)(d3 * Math.cos(d2) + (double)this.origin[2] + d)};
                if (this.checkLine(nArray3, nArray2 = new int[]{n7, n2 + this.foliageHeight, n6}) != -1) continue;
                int[] nArray4 = new int[]{this.origin[0], this.origin[1], this.origin[2]};
                double d4 = Math.sqrt(Math.pow(Math.abs(this.origin[0] - nArray3[0]), 2.0) + Math.pow(Math.abs(this.origin[2] - nArray3[2]), 2.0));
                double d5 = d4 * this.branchSlope;
                nArray4[1] = (double)nArray3[1] - d5 > (double)n4 ? n4 : (int)((double)nArray3[1] - d5);
                if (this.checkLine(nArray4, nArray3) != -1) continue;
                nArray[n3][0] = n7;
                nArray[n3][1] = n2;
                nArray[n3][2] = n6;
                nArray[n3][3] = nArray4[1];
                ++n3;
            }
            --n2;
            --n5;
        }
        this.foliageCoords = new int[n3][4];
        System.arraycopy(nArray, 0, this.foliageCoords, 0, n3);
    }

    void crossection(int n, int n2, int n3, float f, byte by, int n4) {
        int n5 = (int)((double)f + 0.618);
        byte by2 = axisConversionArray[by];
        byte by3 = axisConversionArray[by + 3];
        int[] nArray = new int[]{n, n2, n3};
        int[] nArray2 = new int[]{0, 0, 0};
        int n6 = -n5;
        nArray2[by] = nArray[by];
        for (int i = -n5; i <= n5; ++i) {
            nArray2[by2] = nArray[by2] + i;
            n6 = -n5;
            while (n6 <= n5) {
                double d = Math.sqrt(Math.pow((double)Math.abs(i) + 0.5, 2.0) + Math.pow((double)Math.abs(n6) + 0.5, 2.0));
                if (d > (double)f) {
                    ++n6;
                    continue;
                }
                nArray2[by3] = nArray[by3] + n6;
                int n7 = this.thisLevel.getTile(nArray2[0], nArray2[1], nArray2[2]);
                if (n7 != 0 && n7 != 18) {
                    ++n6;
                    continue;
                }
                this.thisLevel.setTileNoUpdate(nArray2[0], nArray2[1], nArray2[2], n4);
                ++n6;
            }
        }
    }

    float treeShape(int n) {
        if ((double)n < (double)this.height * 0.3) {
            return -1.618f;
        }
        float f = (float)this.height / 2.0f;
        float f2 = (float)this.height / 2.0f - (float)n;
        float f3 = f2 == 0.0f ? f : (Math.abs(f2) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f2), 2.0)));
        return f3 *= 0.5f;
    }

    float foliageShape(int n) {
        if (n < 0 || n >= this.foliageHeight) {
            return -1.0f;
        }
        if (n == 0 || n == this.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    void foliageCluster(int n, int n2, int n3) {
        int n4 = n2 + this.foliageHeight;
        for (int i = n2; i < n4; ++i) {
            float f = this.foliageShape(i - n2);
            this.crossection(n, i, n3, f, (byte)1, 18);
        }
    }

    void limb(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[]{0, 0, 0};
        int n2 = 0;
        for (int n3 = 0; n3 < 3; n3 = (int)((byte)(n3 + 1))) {
            nArray3[n3] = nArray2[n3] - nArray[n3];
            if (Math.abs(nArray3[n3]) <= Math.abs(nArray3[n2])) continue;
            n2 = n3;
        }
        if (nArray3[n2] == 0) {
            return;
        }
        byte by = axisConversionArray[n2];
        byte by2 = axisConversionArray[n2 + 3];
        int n4 = nArray3[n2] > 0 ? 1 : -1;
        double d = (double)nArray3[by] / (double)nArray3[n2];
        double d2 = (double)nArray3[by2] / (double)nArray3[n2];
        int[] nArray4 = new int[]{0, 0, 0};
        int n5 = nArray3[n2] + n4;
        for (int i = 0; i != n5; i += n4) {
            nArray4[n2] = Mth.floor((double)(nArray[n2] + i) + 0.5);
            nArray4[by] = Mth.floor((double)nArray[by] + (double)i * d + 0.5);
            nArray4[by2] = Mth.floor((double)nArray[by2] + (double)i * d2 + 0.5);
            this.thisLevel.setTileNoUpdate(nArray4[0], nArray4[1], nArray4[2], n);
        }
    }

    void makeFoliage() {
        int n = this.foliageCoords.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.foliageCoords[i][0];
            int n3 = this.foliageCoords[i][1];
            int n4 = this.foliageCoords[i][2];
            this.foliageCluster(n2, n3, n4);
        }
    }

    boolean trimBranches(int n) {
        return !((double)n < (double)this.height * 0.2);
    }

    void makeTrunk() {
        int n = this.origin[0];
        int n2 = this.origin[1];
        int n3 = this.origin[1] + this.trunkHeight;
        int n4 = this.origin[2];
        int[] nArray = new int[]{n, n2, n4};
        int[] nArray2 = new int[]{n, n3, n4};
        this.limb(nArray, nArray2, 17);
        if (this.trunkWidth == 2) {
            nArray[0] = nArray[0] + 1;
            nArray2[0] = nArray2[0] + 1;
            this.limb(nArray, nArray2, 17);
            nArray[2] = nArray[2] + 1;
            nArray2[2] = nArray2[2] + 1;
            this.limb(nArray, nArray2, 17);
            nArray[0] = nArray[0] + -1;
            nArray2[0] = nArray2[0] + -1;
            this.limb(nArray, nArray2, 17);
        }
    }

    void makeBranches() {
        int n = this.foliageCoords.length;
        int[] nArray = new int[]{this.origin[0], this.origin[1], this.origin[2]};
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = this.foliageCoords[i];
            int[] nArray3 = new int[]{nArray2[0], nArray2[1], nArray2[2]};
            nArray[1] = nArray2[3];
            int n2 = nArray[1] - this.origin[1];
            if (!this.trimBranches(n2)) continue;
            this.limb(nArray, nArray3, 17);
        }
    }

    int checkLine(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[]{0, 0, 0};
        int n2 = 0;
        for (int n3 = 0; n3 < 3; n3 = (int)((byte)(n3 + 1))) {
            nArray3[n3] = nArray2[n3] - nArray[n3];
            if (Math.abs(nArray3[n3]) <= Math.abs(nArray3[n2])) continue;
            n2 = n3;
        }
        if (nArray3[n2] == 0) {
            return -1;
        }
        byte by = axisConversionArray[n2];
        byte by2 = axisConversionArray[n2 + 3];
        int n4 = nArray3[n2] > 0 ? 1 : -1;
        double d = (double)nArray3[by] / (double)nArray3[n2];
        double d2 = (double)nArray3[by2] / (double)nArray3[n2];
        int[] nArray4 = new int[]{0, 0, 0};
        int n5 = nArray3[n2] + n4;
        for (n = 0; n != n5; n += n4) {
            nArray4[n2] = nArray[n2] + n;
            nArray4[by] = (int)((double)nArray[by] + (double)n * d);
            nArray4[by2] = (int)((double)nArray[by2] + (double)n * d2);
            int n6 = this.thisLevel.getTile(nArray4[0], nArray4[1], nArray4[2]);
            if (n6 != 0 && n6 != 18) break;
        }
        if (n == n5) {
            return -1;
        }
        return Math.abs(n);
    }

    boolean checkLocation() {
        int[] nArray = new int[]{this.origin[0], this.origin[1], this.origin[2]};
        int[] nArray2 = new int[]{this.origin[0], this.origin[1] + this.height - 1, this.origin[2]};
        int n = this.thisLevel.getTile(this.origin[0], this.origin[1] - 1, this.origin[2]);
        if (n != 2 && n != 3) {
            return false;
        }
        int n2 = this.checkLine(nArray, nArray2);
        if (n2 == -1) {
            return true;
        }
        if (n2 < 6) {
            return false;
        }
        this.height = n2;
        return true;
    }

    public void init(double d, double d2, double d3) {
        this.heightVariance = (int)(d * 12.0);
        if (d > 0.5) {
            this.foliageHeight = 5;
        }
        this.widthScale = d2;
        this.foliageDensity = d3;
    }

    public boolean place(Level level, Random random, int n, int n2, int n3) {
        this.thisLevel = level;
        long l = random.nextLong();
        this.rnd.setSeed(l);
        this.origin[0] = n;
        this.origin[1] = n2;
        this.origin[2] = n3;
        if (this.height == 0) {
            this.height = 5 + this.rnd.nextInt(this.heightVariance);
        }
        if (!this.checkLocation()) {
            return false;
        }
        this.prepare();
        this.makeFoliage();
        this.makeTrunk();
        this.makeBranches();
        return true;
    }
}

