/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.LargeCaveFeature;
import net.minecraft.world.level.levelgen.LargeFeature;
import net.minecraft.world.level.levelgen.feature.CactusFeature;
import net.minecraft.world.level.levelgen.feature.ClayFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FlowerFeature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.MonsterRoomFeature;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.PumpkinFeature;
import net.minecraft.world.level.levelgen.feature.ReedsFeature;
import net.minecraft.world.level.levelgen.feature.SpringFeature;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.SandTile;
import net.minecraft.world.level.tile.Tile;
import util.ProgressListener;

public class RandomLevelSource
implements ChunkSource {
    private static final double SNOW_CUTOFF = 0.5;
    private static final double SNOW_SCALE = 0.3;
    private static final boolean FLOATING_ISLANDS = false;
    public static final int CHUNK_HEIGHT = 8;
    public static final int CHUNK_WIDTH = 4;
    private Random random;
    private PerlinNoise lperlinNoise1;
    private PerlinNoise lperlinNoise2;
    private PerlinNoise perlinNoise1;
    private PerlinNoise perlinNoise2;
    private PerlinNoise perlinNoise3;
    public PerlinNoise scaleNoise;
    public PerlinNoise depthNoise;
    private PerlinNoise floatingIslandScale;
    private PerlinNoise floatingIslandNoise;
    public PerlinNoise forestNoise;
    private Level level;
    private double[] buffer;
    private double[] sandBuffer = new double[256];
    private double[] gravelBuffer = new double[256];
    private double[] depthBuffer = new double[256];
    private LargeFeature caveFeature = new LargeCaveFeature();
    private Biome[] biomes;
    double[] pnr;
    double[] ar;
    double[] br;
    double[] sr;
    double[] dr;
    double[] fi;
    double[] fis;
    int[][] waterDepths = new int[32][32];
    private double[] temperatures;

    public RandomLevelSource(Level level, long l) {
        this.level = level;
        this.random = new Random(l);
        this.lperlinNoise1 = new PerlinNoise(this.random, 16);
        this.lperlinNoise2 = new PerlinNoise(this.random, 16);
        this.perlinNoise1 = new PerlinNoise(this.random, 8);
        this.perlinNoise2 = new PerlinNoise(this.random, 4);
        this.perlinNoise3 = new PerlinNoise(this.random, 4);
        this.scaleNoise = new PerlinNoise(this.random, 10);
        this.depthNoise = new PerlinNoise(this.random, 16);
        this.forestNoise = new PerlinNoise(this.random, 8);
    }

    public void prepareHeights(int n, int n2, byte[] byArray, Biome[] biomeArray, double[] dArray) {
        int n3 = 4;
        int n4 = 64;
        int n5 = n3 + 1;
        int n6 = 17;
        int n7 = n3 + 1;
        this.buffer = this.getHeights(this.buffer, n * n3, 0, n2 * n3, n5, n6, n7);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < 16; ++k) {
                    double d = 0.125;
                    double d2 = this.buffer[((i + 0) * n7 + (j + 0)) * n6 + (k + 0)];
                    double d3 = this.buffer[((i + 0) * n7 + (j + 1)) * n6 + (k + 0)];
                    double d4 = this.buffer[((i + 1) * n7 + (j + 0)) * n6 + (k + 0)];
                    double d5 = this.buffer[((i + 1) * n7 + (j + 1)) * n6 + (k + 0)];
                    double d6 = (this.buffer[((i + 0) * n7 + (j + 0)) * n6 + (k + 1)] - d2) * d;
                    double d7 = (this.buffer[((i + 0) * n7 + (j + 1)) * n6 + (k + 1)] - d3) * d;
                    double d8 = (this.buffer[((i + 1) * n7 + (j + 0)) * n6 + (k + 1)] - d4) * d;
                    double d9 = (this.buffer[((i + 1) * n7 + (j + 1)) * n6 + (k + 1)] - d5) * d;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = 0.25;
                        double d11 = d2;
                        double d12 = d3;
                        double d13 = (d4 - d2) * d10;
                        double d14 = (d5 - d3) * d10;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int n8 = i3 + i * 4 << 11 | 0 + j * 4 << 7 | k * 8 + i2;
                            int n9 = 128;
                            double d15 = 0.25;
                            double d16 = d11;
                            double d17 = (d12 - d11) * d15;
                            for (int i4 = 0; i4 < 4; ++i4) {
                                double d18 = dArray[(i * 4 + i3) * 16 + (j * 4 + i4)];
                                int n10 = 0;
                                if (k * 8 + i2 < n4) {
                                    n10 = d18 < 0.5 && k * 8 + i2 >= n4 - 1 ? Tile.ice.id : Tile.calmWater.id;
                                }
                                if (d16 > 0.0) {
                                    n10 = Tile.rock.id;
                                }
                                byArray[n8] = (byte)n10;
                                n8 += n9;
                                d16 += d17;
                            }
                            d11 += d13;
                            d12 += d14;
                        }
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        d5 += d9;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int n, int n2, byte[] byArray, Biome[] biomeArray) {
        int n3 = 64;
        double d = 0.03125;
        this.sandBuffer = this.perlinNoise2.getRegion(this.sandBuffer, n * 16, n2 * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.gravelBuffer = this.perlinNoise2.getRegion(this.gravelBuffer, n2 * 16, 109.0134, n * 16, 16, 1, 16, d, 1.0, d);
        this.depthBuffer = this.perlinNoise3.getRegion(this.depthBuffer, n * 16, n2 * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomeArray[i + j * 16];
                boolean bl = this.sandBuffer[i + j * 16] + this.random.nextDouble() * 0.2 > 0.0;
                boolean bl2 = this.gravelBuffer[i + j * 16] + this.random.nextDouble() * 0.2 > 3.0;
                int n4 = (int)(this.depthBuffer[i + j * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int n5 = -1;
                byte by = biome.topMaterial;
                byte by2 = biome.material;
                for (int k = 127; k >= 0; --k) {
                    int n6 = (i * 16 + j) * 128 + k;
                    if (k <= 0 + this.random.nextInt(5)) {
                        byArray[n6] = (byte)Tile.unbreakable.id;
                        continue;
                    }
                    byte by3 = byArray[n6];
                    if (by3 == 0) {
                        n5 = -1;
                        continue;
                    }
                    if (by3 != Tile.rock.id) continue;
                    if (n5 == -1) {
                        if (n4 <= 0) {
                            by = 0;
                            by2 = (byte)Tile.rock.id;
                        } else if (k >= n3 - 4 && k <= n3 + 1) {
                            by = biome.topMaterial;
                            by2 = biome.material;
                            if (bl2) {
                                by = 0;
                            }
                            if (bl2) {
                                by2 = (byte)Tile.gravel.id;
                            }
                            if (bl) {
                                by = (byte)Tile.sand.id;
                            }
                            if (bl) {
                                by2 = (byte)Tile.sand.id;
                            }
                        }
                        if (k < n3 && by == 0) {
                            by = (byte)Tile.calmWater.id;
                        }
                        n5 = n4;
                        if (k >= n3 - 1) {
                            byArray[n6] = by;
                            continue;
                        }
                        byArray[n6] = by2;
                        continue;
                    }
                    if (n5 <= 0) continue;
                    --n5;
                    byArray[n6] = by2;
                }
            }
        }
    }

    public LevelChunk getChunk(int n, int n2) {
        this.random.setSeed((long)n * 341873128712L + (long)n2 * 132897987541L);
        byte[] byArray = new byte[32768];
        LevelChunk levelChunk = new LevelChunk(this.level, byArray, n, n2);
        this.biomes = this.level.getBiomeSource().getBiomeBlock(this.biomes, n * 16, n2 * 16, 16, 16);
        double[] dArray = this.level.getBiomeSource().temperatures;
        this.prepareHeights(n, n2, byArray, this.biomes, dArray);
        this.buildSurfaces(n, n2, byArray, this.biomes);
        this.caveFeature.apply(this, this.level, n, n2, byArray);
        levelChunk.recalcHeightmap();
        return levelChunk;
    }

    private double[] getHeights(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (dArray == null) {
            dArray = new double[n4 * n5 * n6];
        }
        double d = 684.412;
        double d2 = 684.412;
        double[] dArray2 = this.level.getBiomeSource().temperatures;
        double[] dArray3 = this.level.getBiomeSource().downfalls;
        this.sr = this.scaleNoise.getRegion(this.sr, n, n3, n4, n6, 1.121, 1.121, 0.5);
        this.dr = this.depthNoise.getRegion(this.dr, n, n3, n4, n6, 200.0, 200.0, 0.5);
        this.pnr = this.perlinNoise1.getRegion(this.pnr, n, n2, n3, n4, n5, n6, d / 80.0, d2 / 160.0, d / 80.0);
        this.ar = this.lperlinNoise1.getRegion(this.ar, n, n2, n3, n4, n5, n6, d, d2, d);
        this.br = this.lperlinNoise2.getRegion(this.br, n, n2, n3, n4, n5, n6, d, d2, d);
        int n7 = 0;
        int n8 = 0;
        int n9 = 16 / n4;
        for (int i = 0; i < n4; ++i) {
            int n10 = i * n9 + n9 / 2;
            for (int j = 0; j < n6; ++j) {
                double d3;
                int n11 = j * n9 + n9 / 2;
                double d4 = dArray2[n10 * 16 + n11];
                double d5 = dArray3[n10 * 16 + n11] * d4;
                double d6 = 1.0 - d5;
                d6 *= d6;
                d6 *= d6;
                d6 = 1.0 - d6;
                double d7 = (this.sr[n8] + 256.0) / 512.0;
                if ((d7 *= d6) > 1.0) {
                    d7 = 1.0;
                }
                if ((d3 = this.dr[n8] / 8000.0) < 0.0) {
                    d3 = -d3 * 0.3;
                }
                if ((d3 = d3 * 3.0 - 2.0) < 0.0) {
                    if ((d3 /= 2.0) < -1.0) {
                        d3 = -1.0;
                    }
                    d3 /= 1.4;
                    d3 /= 2.0;
                    d7 = 0.0;
                } else {
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d3 /= 8.0;
                }
                if (d7 < 0.0) {
                    d7 = 0.0;
                }
                d7 += 0.5;
                d3 = d3 * (double)n5 / 16.0;
                double d8 = (double)n5 / 2.0 + d3 * 4.0;
                ++n8;
                for (int k = 0; k < n5; ++k) {
                    double d9 = 0.0;
                    double d10 = ((double)k - d8) * 12.0 / d7;
                    if (d10 < 0.0) {
                        d10 *= 4.0;
                    }
                    double d11 = this.ar[n7] / 512.0;
                    double d12 = this.br[n7] / 512.0;
                    double d13 = (this.pnr[n7] / 10.0 + 1.0) / 2.0;
                    d9 = d13 < 0.0 ? d11 : (d13 > 1.0 ? d12 : d11 + (d12 - d11) * d13);
                    d9 -= d10;
                    if (k > n5 - 4) {
                        double d14 = (float)(k - (n5 - 4)) / 3.0f;
                        d9 = d9 * (1.0 - d14) + -10.0 * d14;
                    }
                    dArray[n7] = d9;
                    ++n7;
                }
            }
        }
        return dArray;
    }

    public boolean hasChunk(int n, int n2) {
        return true;
    }

    private void calcWaterDepths(ChunkSource chunkSource, int n, int n2) {
        int n3 = n * 16;
        int n4 = n2 * 16;
        for (int i = 0; i < 16; ++i) {
            int n5 = this.level.getSeaLevel();
            for (int j = 0; j < 16; ++j) {
                int n6;
                int n7 = n3 + i + 7;
                int n8 = n4 + j + 7;
                int n9 = this.level.getHeightmap(n7, n8);
                if (n9 > 0 || this.level.getHeightmap(n7 - 1, n8) <= 0 && this.level.getHeightmap(n7 + 1, n8) <= 0 && this.level.getHeightmap(n7, n8 - 1) <= 0 && this.level.getHeightmap(n7, n8 + 1) <= 0) continue;
                boolean bl = false;
                if (bl || this.level.getTile(n7 - 1, n5, n8) == Tile.calmWater.id && this.level.getData(n7 - 1, n5, n8) < 7) {
                    bl = true;
                }
                if (bl || this.level.getTile(n7 + 1, n5, n8) == Tile.calmWater.id && this.level.getData(n7 + 1, n5, n8) < 7) {
                    bl = true;
                }
                if (bl || this.level.getTile(n7, n5, n8 - 1) == Tile.calmWater.id && this.level.getData(n7, n5, n8 - 1) < 7) {
                    bl = true;
                }
                if (bl || this.level.getTile(n7, n5, n8 + 1) == Tile.calmWater.id && this.level.getData(n7, n5, n8 + 1) < 7) {
                    bl = true;
                }
                if (!bl) continue;
                for (n6 = -5; n6 <= 5; ++n6) {
                    for (int k = -5; k <= 5; ++k) {
                        int n10;
                        int n11 = (n6 > 0 ? n6 : -n6) + (k > 0 ? k : -k);
                        if (n11 > 5) continue;
                        n11 = 6 - n11;
                        if (this.level.getTile(n7 + n6, n5, n8 + k) != Tile.calmWater.id || (n10 = this.level.getData(n7 + n6, n5, n8 + k)) >= 7 || n10 >= n11) continue;
                        this.level.setData(n7 + n6, n5, n8 + k, n11);
                    }
                }
                if (!bl) continue;
                this.level.setTileAndDataNoUpdate(n7, n5, n8, Tile.calmWater.id, 7);
                for (n6 = 0; n6 < n5; ++n6) {
                    this.level.setTileAndDataNoUpdate(n7, n6, n8, Tile.calmWater.id, 8);
                }
            }
        }
    }

    public void postProcess(ChunkSource chunkSource, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        SandTile.instaFall = true;
        int n9 = n * 16;
        int n10 = n2 * 16;
        Biome biome = this.level.getBiomeSource().getBiome(n9 + 16, n10 + 16);
        this.random.setSeed(this.level.seed);
        long l = this.random.nextLong() / 2L * 2L + 1L;
        long l2 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)n * l + (long)n2 * l2 ^ this.level.seed);
        double d = 0.25;
        if (this.random.nextInt(4) == 0) {
            n8 = n9 + this.random.nextInt(16) + 8;
            n7 = this.random.nextInt(128);
            n6 = n10 + this.random.nextInt(16) + 8;
            new LakeFeature(Tile.calmWater.id).place(this.level, this.random, n8, n7, n6);
        }
        if (this.random.nextInt(8) == 0) {
            n8 = n9 + this.random.nextInt(16) + 8;
            n7 = this.random.nextInt(this.random.nextInt(120) + 8);
            n6 = n10 + this.random.nextInt(16) + 8;
            if (n7 < 64 || this.random.nextInt(10) == 0) {
                new LakeFeature(Tile.calmLava.id).place(this.level, this.random, n8, n7, n6);
            }
        }
        for (n8 = 0; n8 < 8; ++n8) {
            n7 = n9 + this.random.nextInt(16) + 8;
            n6 = this.random.nextInt(128);
            n5 = n10 + this.random.nextInt(16) + 8;
            new MonsterRoomFeature().place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 10; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(128);
            n5 = n10 + this.random.nextInt(16);
            new ClayFeature(32).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 20; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(128);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.dirt.id, 32).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 10; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(128);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.gravel.id, 32).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 20; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(128);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.coalOre.id, 16).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 20; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(64);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.ironOre.id, 8).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 2; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(32);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.goldOre.id, 8).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 8; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(16);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.redStoneOre.id, 7).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 1; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(16);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.emeraldOre.id, 7).place(this.level, this.random, n7, n6, n5);
        }
        for (n8 = 0; n8 < 1; ++n8) {
            n7 = n9 + this.random.nextInt(16);
            n6 = this.random.nextInt(16) + this.random.nextInt(16);
            n5 = n10 + this.random.nextInt(16);
            new OreFeature(Tile.lapisOre.id, 6).place(this.level, this.random, n7, n6, n5);
        }
        d = 0.5;
        n8 = (int)((this.forestNoise.getValue((double)n9 * d, (double)n10 * d) / 8.0 + this.random.nextDouble() * 4.0 + 4.0) / 3.0);
        n7 = 0;
        if (this.random.nextInt(10) == 0) {
            ++n7;
        }
        if (biome == Biome.forest) {
            n7 += n8 + 5;
        }
        if (biome == Biome.rainForest) {
            n7 += n8 + 5;
        }
        if (biome == Biome.seasonalForest) {
            n7 += n8 + 2;
        }
        if (biome == Biome.taiga) {
            n7 += n8 + 5;
        }
        if (biome == Biome.desert) {
            n7 -= 20;
        }
        if (biome == Biome.tundra) {
            n7 -= 20;
        }
        if (biome == Biome.plains) {
            n7 -= 20;
        }
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = n9 + this.random.nextInt(16) + 8;
            n4 = n10 + this.random.nextInt(16) + 8;
            Feature feature = biome.getTreeFeature(this.random);
            feature.init(1.0, 1.0, 1.0);
            feature.place(this.level, this.random, n5, this.level.getHeightmap(n5, n4), n4);
        }
        for (n6 = 0; n6 < 2; ++n6) {
            n5 = n9 + this.random.nextInt(16) + 8;
            n4 = this.random.nextInt(128);
            int n11 = n10 + this.random.nextInt(16) + 8;
            new FlowerFeature(Tile.flower.id).place(this.level, this.random, n5, n4, n11);
        }
        if (this.random.nextInt(2) == 0) {
            n6 = n9 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(128);
            n4 = n10 + this.random.nextInt(16) + 8;
            new FlowerFeature(Tile.rose.id).place(this.level, this.random, n6, n5, n4);
        }
        if (this.random.nextInt(4) == 0) {
            n6 = n9 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(128);
            n4 = n10 + this.random.nextInt(16) + 8;
            new FlowerFeature(Tile.mushroom1.id).place(this.level, this.random, n6, n5, n4);
        }
        if (this.random.nextInt(8) == 0) {
            n6 = n9 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(128);
            n4 = n10 + this.random.nextInt(16) + 8;
            new FlowerFeature(Tile.mushroom2.id).place(this.level, this.random, n6, n5, n4);
        }
        for (n6 = 0; n6 < 10; ++n6) {
            n5 = n9 + this.random.nextInt(16) + 8;
            n4 = this.random.nextInt(128);
            int n12 = n10 + this.random.nextInt(16) + 8;
            new ReedsFeature().place(this.level, this.random, n5, n4, n12);
        }
        if (this.random.nextInt(32) == 0) {
            n6 = n9 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(128);
            n4 = n10 + this.random.nextInt(16) + 8;
            new PumpkinFeature().place(this.level, this.random, n6, n5, n4);
        }
        n6 = 0;
        if (biome == Biome.desert) {
            n6 += 10;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n9 + this.random.nextInt(16) + 8;
            int n13 = this.random.nextInt(128);
            n3 = n10 + this.random.nextInt(16) + 8;
            new CactusFeature().place(this.level, this.random, n4, n13, n3);
        }
        for (n5 = 0; n5 < 50; ++n5) {
            n4 = n9 + this.random.nextInt(16) + 8;
            int n14 = this.random.nextInt(this.random.nextInt(120) + 8);
            n3 = n10 + this.random.nextInt(16) + 8;
            new SpringFeature(Tile.water.id).place(this.level, this.random, n4, n14, n3);
        }
        for (n5 = 0; n5 < 20; ++n5) {
            n4 = n9 + this.random.nextInt(16) + 8;
            int n15 = this.random.nextInt(this.random.nextInt(this.random.nextInt(112) + 8) + 8);
            n3 = n10 + this.random.nextInt(16) + 8;
            new SpringFeature(Tile.lava.id).place(this.level, this.random, n4, n15, n3);
        }
        this.temperatures = this.level.getBiomeSource().getTemperatureBlock(this.temperatures, n9 + 8, n10 + 8, 16, 16);
        for (n5 = n9 + 8; n5 < n9 + 8 + 16; ++n5) {
            for (n4 = n10 + 8; n4 < n10 + 8 + 16; ++n4) {
                int n16 = n5 - (n9 + 8);
                n3 = n4 - (n10 + 8);
                int n17 = this.level.getTopSolidBlock(n5, n4);
                double d2 = this.temperatures[n16 * 16 + n3] - (double)(n17 - 64) / 64.0 * 0.3;
                if (!(d2 < 0.5) || n17 <= 0 || n17 >= 128 || !this.level.isEmptyTile(n5, n17, n4) || !this.level.getMaterial(n5, n17 - 1, n4).blocksMotion() || this.level.getMaterial(n5, n17 - 1, n4) == Material.ice) continue;
                this.level.setTile(n5, n17, n4, Tile.topSnow.id);
            }
        }
        SandTile.instaFall = false;
    }

    public boolean save(boolean bl, ProgressListener progressListener) {
        return true;
    }

    public boolean tick() {
        return false;
    }

    public boolean shouldSave() {
        return true;
    }

    public String gatherStats() {
        return "RandomLevelSource";
    }
}

