/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.LargeFeature;
import net.minecraft.world.level.levelgen.LargeHellCaveFeature;
import net.minecraft.world.level.levelgen.feature.FlowerFeature;
import net.minecraft.world.level.levelgen.feature.HellFireFeature;
import net.minecraft.world.level.levelgen.feature.HellPortalFeature;
import net.minecraft.world.level.levelgen.feature.HellSpringFeature;
import net.minecraft.world.level.levelgen.feature.LightGemFeature;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.tile.SandTile;
import net.minecraft.world.level.tile.Tile;
import util.ProgressListener;

public class HellRandomLevelSource
implements ChunkSource {
    public static final int CHUNK_HEIGHT = 8;
    public static final int CHUNK_WIDTH = 4;
    private Random random;
    private PerlinNoise lperlinNoise1;
    private PerlinNoise lperlinNoise2;
    private PerlinNoise perlinNoise1;
    private PerlinNoise perlinNoise2;
    private PerlinNoise perlinNoise3;
    public PerlinNoise scaleNoise;
    public PerlinNoise depthNoise;
    private Level level;
    private double[] buffer;
    double[] caveBuffer1;
    double[] caveBuffer2;
    double[] caveBuffer3;
    private double[] sandBuffer = new double[256];
    private double[] gravelBuffer = new double[256];
    private double[] depthBuffer = new double[256];
    private LargeFeature caveFeature = new LargeHellCaveFeature();
    double[] pnr;
    double[] ar;
    double[] br;
    double[] sr;
    double[] dr;
    double[] fi;
    double[] fis;

    public HellRandomLevelSource(Level level, long l) {
        this.level = level;
        this.random = new Random(l);
        this.lperlinNoise1 = new PerlinNoise(this.random, 16);
        this.lperlinNoise2 = new PerlinNoise(this.random, 16);
        this.perlinNoise1 = new PerlinNoise(this.random, 8);
        this.perlinNoise2 = new PerlinNoise(this.random, 4);
        this.perlinNoise3 = new PerlinNoise(this.random, 4);
        this.scaleNoise = new PerlinNoise(this.random, 10);
        this.depthNoise = new PerlinNoise(this.random, 16);
    }

    public void prepareHeights(int n, int n2, byte[] byArray) {
        int n3 = 4;
        int n4 = 32;
        int n5 = n3 + 1;
        int n6 = 17;
        int n7 = n3 + 1;
        this.buffer = this.getHeights(this.buffer, n * n3, 0, n2 * n3, n5, n6, n7);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < 16; ++k) {
                    double d = 0.125;
                    double d2 = this.buffer[((i + 0) * n7 + (j + 0)) * n6 + (k + 0)];
                    double d3 = this.buffer[((i + 0) * n7 + (j + 1)) * n6 + (k + 0)];
                    double d4 = this.buffer[((i + 1) * n7 + (j + 0)) * n6 + (k + 0)];
                    double d5 = this.buffer[((i + 1) * n7 + (j + 1)) * n6 + (k + 0)];
                    double d6 = (this.buffer[((i + 0) * n7 + (j + 0)) * n6 + (k + 1)] - d2) * d;
                    double d7 = (this.buffer[((i + 0) * n7 + (j + 1)) * n6 + (k + 1)] - d3) * d;
                    double d8 = (this.buffer[((i + 1) * n7 + (j + 0)) * n6 + (k + 1)] - d4) * d;
                    double d9 = (this.buffer[((i + 1) * n7 + (j + 1)) * n6 + (k + 1)] - d5) * d;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = 0.25;
                        double d11 = d2;
                        double d12 = d3;
                        double d13 = (d4 - d2) * d10;
                        double d14 = (d5 - d3) * d10;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int n8 = i3 + i * 4 << 11 | 0 + j * 4 << 7 | k * 8 + i2;
                            int n9 = 128;
                            double d15 = 0.25;
                            double d16 = d11;
                            double d17 = (d12 - d11) * d15;
                            for (int i4 = 0; i4 < 4; ++i4) {
                                int n10 = 0;
                                if (k * 8 + i2 < n4) {
                                    n10 = Tile.calmLava.id;
                                }
                                if (d16 > 0.0) {
                                    n10 = Tile.hellRock.id;
                                }
                                byArray[n8] = (byte)n10;
                                n8 += n9;
                                d16 += d17;
                            }
                            d11 += d13;
                            d12 += d14;
                        }
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        d5 += d9;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int n, int n2, byte[] byArray) {
        int n3 = 64;
        double d = 0.03125;
        this.sandBuffer = this.perlinNoise2.getRegion(this.sandBuffer, n * 16, n2 * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.gravelBuffer = this.perlinNoise2.getRegion(this.gravelBuffer, n2 * 16, 109.0134, n * 16, 16, 1, 16, d, 1.0, d);
        this.depthBuffer = this.perlinNoise3.getRegion(this.depthBuffer, n * 16, n2 * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                boolean bl = this.sandBuffer[i + j * 16] + this.random.nextDouble() * 0.2 > 0.0;
                boolean bl2 = this.gravelBuffer[i + j * 16] + this.random.nextDouble() * 0.2 > 0.0;
                int n4 = (int)(this.depthBuffer[i + j * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int n5 = -1;
                byte by = (byte)Tile.hellRock.id;
                byte by2 = (byte)Tile.hellRock.id;
                for (int k = 127; k >= 0; --k) {
                    int n6 = (i * 16 + j) * 128 + k;
                    if (k >= 127 - this.random.nextInt(5)) {
                        byArray[n6] = (byte)Tile.unbreakable.id;
                        continue;
                    }
                    if (k <= 0 + this.random.nextInt(5)) {
                        byArray[n6] = (byte)Tile.unbreakable.id;
                        continue;
                    }
                    byte by3 = byArray[n6];
                    if (by3 == 0) {
                        n5 = -1;
                        continue;
                    }
                    if (by3 != Tile.hellRock.id) continue;
                    if (n5 == -1) {
                        if (n4 <= 0) {
                            by = 0;
                            by2 = (byte)Tile.hellRock.id;
                        } else if (k >= n3 - 4 && k <= n3 + 1) {
                            by = (byte)Tile.hellRock.id;
                            by2 = (byte)Tile.hellRock.id;
                            if (bl2) {
                                by = (byte)Tile.gravel.id;
                            }
                            if (bl2) {
                                by2 = (byte)Tile.hellRock.id;
                            }
                            if (bl) {
                                by = (byte)Tile.hellSand.id;
                            }
                            if (bl) {
                                by2 = (byte)Tile.hellSand.id;
                            }
                        }
                        if (k < n3 && by == 0) {
                            by = (byte)Tile.calmLava.id;
                        }
                        n5 = n4;
                        if (k >= n3 - 1) {
                            byArray[n6] = by;
                            continue;
                        }
                        byArray[n6] = by2;
                        continue;
                    }
                    if (n5 <= 0) continue;
                    --n5;
                    byArray[n6] = by2;
                }
            }
        }
    }

    public LevelChunk getChunk(int n, int n2) {
        this.random.setSeed((long)n * 341873128712L + (long)n2 * 132897987541L);
        byte[] byArray = new byte[32768];
        this.prepareHeights(n, n2, byArray);
        this.buildSurfaces(n, n2, byArray);
        this.caveFeature.apply(this, this.level, n, n2, byArray);
        LevelChunk levelChunk = new LevelChunk(this.level, byArray, n, n2);
        return levelChunk;
    }

    private double[] getHeights(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (dArray == null) {
            dArray = new double[n4 * n5 * n6];
        }
        double d = 684.412;
        double d2 = 2053.236;
        this.sr = this.scaleNoise.getRegion(this.sr, n, n2, n3, n4, 1, n6, 1.0, 0.0, 1.0);
        this.dr = this.depthNoise.getRegion(this.dr, n, n2, n3, n4, 1, n6, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.getRegion(this.pnr, n, n2, n3, n4, n5, n6, d / 80.0, d2 / 60.0, d / 80.0);
        this.ar = this.lperlinNoise1.getRegion(this.ar, n, n2, n3, n4, n5, n6, d, d2, d);
        this.br = this.lperlinNoise2.getRegion(this.br, n, n2, n3, n4, n5, n6, d, d2, d);
        int n8 = 0;
        int n9 = 0;
        double[] dArray2 = new double[n5];
        for (n7 = 0; n7 < n5; ++n7) {
            dArray2[n7] = Math.cos((double)n7 * Math.PI * 6.0 / (double)n5) * 2.0;
            double d3 = n7;
            if (n7 > n5 / 2) {
                d3 = n5 - 1 - n7;
            }
            if (!(d3 < 4.0)) continue;
            d3 = 4.0 - d3;
            int n10 = n7;
            dArray2[n10] = dArray2[n10] - d3 * d3 * d3 * 10.0;
        }
        for (n7 = 0; n7 < n4; ++n7) {
            for (int i = 0; i < n6; ++i) {
                double d4 = (this.sr[n9] + 256.0) / 512.0;
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                double d5 = 0.0;
                double d6 = this.dr[n9] / 8000.0;
                if (d6 < 0.0) {
                    d6 = -d6;
                }
                if ((d6 = d6 * 3.0 - 3.0) < 0.0) {
                    if ((d6 /= 2.0) < -1.0) {
                        d6 = -1.0;
                    }
                    d6 /= 1.4;
                    d6 /= 2.0;
                    d4 = 0.0;
                } else {
                    if (d6 > 1.0) {
                        d6 = 1.0;
                    }
                    d6 /= 6.0;
                }
                d4 += 0.5;
                d6 = d6 * (double)n5 / 16.0;
                ++n9;
                for (int j = 0; j < n5; ++j) {
                    double d7;
                    double d8 = 0.0;
                    double d9 = dArray2[j];
                    double d10 = this.ar[n8] / 512.0;
                    double d11 = this.br[n8] / 512.0;
                    double d12 = (this.pnr[n8] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= d9;
                    if (j > n5 - 4) {
                        d7 = (float)(j - (n5 - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d7) + -10.0 * d7;
                    }
                    if ((double)j < d5) {
                        d7 = (d5 - (double)j) / 4.0;
                        if (d7 < 0.0) {
                            d7 = 0.0;
                        }
                        if (d7 > 1.0) {
                            d7 = 1.0;
                        }
                        d8 = d8 * (1.0 - d7) + -10.0 * d7;
                    }
                    dArray[n8] = d8;
                    ++n8;
                }
            }
        }
        return dArray;
    }

    public boolean hasChunk(int n, int n2) {
        return true;
    }

    public void postProcess(ChunkSource chunkSource, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        SandTile.instaFall = true;
        int n8 = n * 16;
        int n9 = n2 * 16;
        for (n7 = 0; n7 < 8; ++n7) {
            n6 = n8 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(120) + 4;
            n4 = n9 + this.random.nextInt(16) + 8;
            new HellSpringFeature(Tile.lava.id).place(this.level, this.random, n6, n5, n4);
        }
        n7 = this.random.nextInt(this.random.nextInt(10) + 1) + 1;
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = n8 + this.random.nextInt(16) + 8;
            n4 = this.random.nextInt(120) + 4;
            n3 = n9 + this.random.nextInt(16) + 8;
            new HellFireFeature().place(this.level, this.random, n5, n4, n3);
        }
        n7 = this.random.nextInt(this.random.nextInt(10) + 1);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = n8 + this.random.nextInt(16) + 8;
            n4 = this.random.nextInt(120) + 4;
            n3 = n9 + this.random.nextInt(16) + 8;
            new LightGemFeature().place(this.level, this.random, n5, n4, n3);
        }
        for (n6 = 0; n6 < 10; ++n6) {
            n5 = n8 + this.random.nextInt(16) + 8;
            n4 = this.random.nextInt(128);
            n3 = n9 + this.random.nextInt(16) + 8;
            new HellPortalFeature().place(this.level, this.random, n5, n4, n3);
        }
        if (this.random.nextInt(1) == 0) {
            n6 = n8 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(128);
            n4 = n9 + this.random.nextInt(16) + 8;
            new FlowerFeature(Tile.mushroom1.id).place(this.level, this.random, n6, n5, n4);
        }
        if (this.random.nextInt(1) == 0) {
            n6 = n8 + this.random.nextInt(16) + 8;
            n5 = this.random.nextInt(128);
            n4 = n9 + this.random.nextInt(16) + 8;
            new FlowerFeature(Tile.mushroom2.id).place(this.level, this.random, n6, n5, n4);
        }
        SandTile.instaFall = false;
    }

    public boolean save(boolean bl, ProgressListener progressListener) {
        return true;
    }

    public boolean tick() {
        return false;
    }

    public boolean shouldSave() {
        return true;
    }

    public String gatherStats() {
        return "HellRandomLevelSource";
    }
}

