/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import java.io.File;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.OldChunkStorage;
import net.minecraft.world.level.dimension.Dimension;
import net.minecraft.world.level.levelgen.HellRandomLevelSource;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.Vec3;

public class HellDimension
extends Dimension {
    public void init() {
        this.biomeSource = new FixedBiomeSource(Biome.hell, 1.0, 0.0);
        this.foggy = true;
        this.ultraWarm = true;
        this.hasCeiling = true;
        this.id = -1;
    }

    public Vec3 getFogColor(float f, float f2) {
        return Vec3.newTemp(0.2f, 0.03f, 0.03f);
    }

    protected void updateLightRamp() {
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f2 = 1.0f - (float)i / 15.0f;
            this.brightnessRamp[i] = (1.0f - f2) / (f2 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    public ChunkSource createRandomLevelSource() {
        return new HellRandomLevelSource(this.level, this.level.seed);
    }

    public ChunkStorage createStorage(File file) {
        File file2 = new File(file, "DIM-1");
        file2.mkdirs();
        return new OldChunkStorage(file2, true);
    }

    public boolean isValidSpawn(int n, int n2) {
        int n3 = this.level.getTopTile(n, n2);
        if (n3 == Tile.unbreakable.id) {
            return false;
        }
        if (n3 == 0) {
            return false;
        }
        return Tile.solid[n3];
    }

    public float getTimeOfDay(long l, float f) {
        return 0.5f;
    }

    public boolean mayRespawn() {
        return false;
    }
}

