/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import java.io.File;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.OldChunkStorage;
import net.minecraft.world.level.dimension.HellDimension;
import net.minecraft.world.level.levelgen.RandomLevelSource;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class Dimension {
    public Level level;
    public BiomeSource biomeSource;
    public boolean foggy = false;
    public boolean ultraWarm = false;
    public boolean hasCeiling = false;
    public float[] brightnessRamp = new float[16];
    public int id = 0;
    private static final long fogColor = 12638463L;
    private float[] sunriseCol = new float[4];

    public final void init(Level level) {
        this.level = level;
        this.init();
        this.updateLightRamp();
    }

    protected void updateLightRamp() {
        float f = 0.05f;
        for (int i = 0; i <= 15; ++i) {
            float f2 = 1.0f - (float)i / 15.0f;
            this.brightnessRamp[i] = (1.0f - f2) / (f2 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    protected void init() {
        this.biomeSource = new BiomeSource(this.level);
    }

    public ChunkSource createRandomLevelSource() {
        return new RandomLevelSource(this.level, this.level.seed);
    }

    public ChunkStorage createStorage(File file) {
        return new OldChunkStorage(file, true);
    }

    public boolean isValidSpawn(int n, int n2) {
        int n3 = this.level.getTopTile(n, n2);
        return n3 == Tile.sand.id;
    }

    public float getTimeOfDay(long l, float f) {
        int n = (int)(l % 24000L);
        float f2 = ((float)n + f) / 24000.0f - 0.25f;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        }
        float f3 = f2;
        f2 = 1.0f - (float)((Math.cos((double)f2 * Math.PI) + 1.0) / 2.0);
        f2 = f3 + (f2 - f3) / 3.0f;
        return f2;
    }

    public float[] getSunriseColor(float f, float f2) {
        float f3;
        float f4 = 0.4f;
        float f5 = Mth.cos(f * (float)Math.PI * 2.0f) - 0.0f;
        if (f5 >= (f3 = -0.0f) - f4 && f5 <= f3 + f4) {
            float f6 = (f5 - f3) / f4 * 0.5f + 0.5f;
            float f7 = 1.0f - (1.0f - Mth.sin(f6 * (float)Math.PI)) * 0.99f;
            f7 *= f7;
            this.sunriseCol[0] = f6 * 0.3f + 0.7f;
            this.sunriseCol[1] = f6 * f6 * 0.7f + 0.2f;
            this.sunriseCol[2] = f6 * f6 * 0.0f + 0.2f;
            this.sunriseCol[3] = f7;
            return this.sunriseCol;
        }
        return null;
    }

    public Vec3 getFogColor(float f, float f2) {
        float f3 = Mth.cos(f * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        float f4 = 0.7529412f;
        float f5 = 0.84705883f;
        float f6 = 1.0f;
        return Vec3.newTemp(f4 *= f3 * 0.94f + 0.06f, f5 *= f3 * 0.94f + 0.06f, f6 *= f3 * 0.91f + 0.09f);
    }

    public boolean mayRespawn() {
        return true;
    }

    public static Dimension getNew(int n) {
        if (n == 0) {
            return new Dimension();
        }
        if (n == -1) {
            return new HellDimension();
        }
        return null;
    }
}

