/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.nbt.CompoundTag;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityIO;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.ZoneFile;
import net.minecraft.world.level.chunk.storage.ZoneIo;
import net.minecraft.world.level.tile.entity.TileEntity;

public class ZonedChunkStorage
implements ChunkStorage {
    public static final int BIT_TERRAIN_POPULATED = 1;
    public static final int CHUNKS_PER_ZONE_BITS = 5;
    public static final int CHUNKS_PER_ZONE = 32;
    public static final int CHUNK_WIDTH = 16;
    public static final int CHUNK_HEADER_SIZE = 256;
    public static final int CHUNK_SIZE = 32768;
    public static final int CHUNK_LAYERS = 3;
    public static final int CHUNK_SIZE_BYTES = 98560;
    public static final ByteOrder BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private File dir;
    private Map<Long, ZoneFile> zoneFiles = new HashMap<Long, ZoneFile>();
    private long tickCount = 0L;

    public ZonedChunkStorage(File file) {
        file = new File(file, "data");
        if (!file.exists()) {
            file.mkdir();
        }
        this.dir = file;
    }

    private int getSlot(int n, int n2) {
        int n3 = n >> 5;
        int n4 = n2 >> 5;
        int n5 = n - (n3 << 5);
        int n6 = n2 - (n4 << 5);
        int n7 = n5 + n6 * 32;
        return n7;
    }

    private ZoneFile getZoneFile(int n, int n2, boolean bl) throws IOException {
        Object object;
        int n3 = this.getSlot(n, n2);
        int n4 = n >> 5;
        int n5 = n2 >> 5;
        long l = n4 + (n5 << 20);
        if (!this.zoneFiles.containsKey(l)) {
            object = new File(this.dir, "zone_" + Integer.toString(n, 36) + "_" + Integer.toString(n2, 36) + ".dat");
            if (!((File)object).exists()) {
                if (!bl) {
                    return null;
                }
                ((File)object).createNewFile();
            }
            File file = new File(this.dir, "entities_" + Integer.toString(n, 36) + "_" + Integer.toString(n2, 36) + ".dat");
            this.zoneFiles.put(l, new ZoneFile(l, (File)object, file));
        }
        object = this.zoneFiles.get(l);
        ((ZoneFile)object).lastUse = this.tickCount;
        if (!((ZoneFile)object).containsSlot(n3) && !bl) {
            return null;
        }
        return object;
    }

    private ZoneIo getBuffer(int n, int n2, boolean bl) throws IOException {
        ZoneFile zoneFile = this.getZoneFile(n, n2, bl);
        if (zoneFile == null) {
            return null;
        }
        return zoneFile.getZoneIo(this.getSlot(n, n2));
    }

    public LevelChunk load(Level level, int n, int n2) throws IOException {
        ZoneIo zoneIo = this.getBuffer(n, n2, false);
        if (zoneIo == null) {
            return null;
        }
        LevelChunk levelChunk = new LevelChunk(level, n, n2);
        levelChunk.unsaved = false;
        ByteBuffer byteBuffer = zoneIo.read(256);
        levelChunk.blocks = zoneIo.read(32768).array();
        levelChunk.data = new DataLayer(zoneIo.read(16384).array());
        levelChunk.skyLight = new DataLayer(zoneIo.read(16384).array());
        levelChunk.blockLight = new DataLayer(zoneIo.read(16384).array());
        levelChunk.heightmap = zoneIo.read(256).array();
        byteBuffer.flip();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        levelChunk.terrainPopulated = (l2 & 1L) != 0L;
        this.loadEntities(level, levelChunk);
        return levelChunk;
    }

    public void save(Level level, LevelChunk levelChunk) throws IOException {
        long l = 0L;
        if (levelChunk.terrainPopulated) {
            l |= 1L;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.order(BYTE_ORDER);
        byteBuffer.putInt(levelChunk.x);
        byteBuffer.putInt(levelChunk.z);
        byteBuffer.putLong(level.time);
        byteBuffer.putLong(l);
        byteBuffer.flip();
        ZoneIo zoneIo = this.getBuffer(levelChunk.x, levelChunk.z, true);
        zoneIo.write(byteBuffer, 256);
        zoneIo.write(levelChunk.blocks, 32768);
        zoneIo.write(levelChunk.data.data, 16384);
        zoneIo.write(levelChunk.skyLight.data, 16384);
        zoneIo.write(levelChunk.blockLight.data, 16384);
        zoneIo.write(levelChunk.heightmap, 256);
        zoneIo.flush();
    }

    public void tick() {
        ++this.tickCount;
        if (this.tickCount % 200L == 4L) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (ZoneFile object : this.zoneFiles.values()) {
                if (this.tickCount - object.lastUse <= 1200L) continue;
                arrayList.add(object.key);
            }
            for (Long l : arrayList) {
                try {
                    System.out.println("Closing zone " + l);
                    this.zoneFiles.get(l).close();
                    this.zoneFiles.remove(l);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void flush() {
        for (ZoneFile zoneFile : this.zoneFiles.values()) {
            try {
                zoneFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.zoneFiles.clear();
    }

    public void loadEntities(Level level, LevelChunk levelChunk) throws IOException {
        int n = this.getSlot(levelChunk.x, levelChunk.z);
        ZoneFile zoneFile = this.getZoneFile(levelChunk.x, levelChunk.z, true);
        List<CompoundTag> list = zoneFile.entityFile.readAll(n);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            CompoundTag compoundTag = list.get(i);
            int n2 = compoundTag.getInt("_TYPE");
            if (n2 == 0) {
                object = EntityIO.loadStatic(compoundTag, level);
                if (object == null) continue;
                levelChunk.addEntity((Entity)object);
                continue;
            }
            if (n2 != 1 || (object = TileEntity.loadStatic(compoundTag)) == null) continue;
            levelChunk.addTileEntity((TileEntity)object);
        }
    }

    public void saveEntities(Level level, LevelChunk levelChunk) throws IOException {
        int n = this.getSlot(levelChunk.x, levelChunk.z);
        ZoneFile zoneFile = this.getZoneFile(levelChunk.x, levelChunk.z, true);
        ArrayList<CompoundTag> arrayList = new ArrayList<CompoundTag>();
        for (int i = 0; i < levelChunk.entityBlocks.length; ++i) {
            List<Entity> object = levelChunk.entityBlocks[i];
            for (int compoundTag = 0; compoundTag < object.size(); ++compoundTag) {
                Entity entity = object.get(compoundTag);
                CompoundTag compoundTag2 = new CompoundTag();
                compoundTag2.putInt("_TYPE", 0);
                entity.save(compoundTag2);
                arrayList.add(compoundTag2);
            }
        }
        for (TileEntity tileEntity : levelChunk.tileEntities.values()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("_TYPE", 1);
            tileEntity.save(compoundTag);
            arrayList.add(compoundTag);
        }
        zoneFile.entityFile.replaceSlot(n, arrayList);
    }
}

