/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.world.level.chunk.storage.ZonedChunkStorage;

public class ZoneIo {
    private FileChannel channel;
    private long pos;

    public ZoneIo(FileChannel fileChannel, long l) {
        this.channel = fileChannel;
        this.pos = l;
    }

    public void write(byte[] byArray, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byArray.length != n) {
            throw new IllegalArgumentException("Expected " + n + " bytes, got " + byArray.length);
        }
        byteBuffer.order(ZonedChunkStorage.BYTE_ORDER);
        byteBuffer.position(byArray.length);
        byteBuffer.flip();
        this.write(byteBuffer, n);
    }

    public void write(ByteBuffer byteBuffer, int n) throws IOException {
        this.channel.position(this.pos);
        this.channel.write(byteBuffer);
        this.pos += (long)n;
    }

    public ByteBuffer read(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.channel.position(this.pos);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ZonedChunkStorage.BYTE_ORDER);
        byteBuffer.position(n);
        byteBuffer.flip();
        this.channel.read(byteBuffer);
        this.pos += (long)n;
        return byteBuffer;
    }

    public void flush() throws IOException {
        this.channel.force(false);
    }
}

