/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.world.level.chunk.storage.NbtSlotFile;
import net.minecraft.world.level.chunk.storage.ZoneIo;
import net.minecraft.world.level.chunk.storage.ZonedChunkStorage;

public class ZoneFile {
    public static final int FILE_HEADER_SIZE = 4096;
    private static final int MAGIC_NUMBER = 326332416;
    private short[] slots = new short[1024];
    private short slotCount;
    public long lastUse = 0L;
    private final FileChannel channel;
    public final Long key;
    public final File file;
    public NbtSlotFile entityFile;

    public ZoneFile(Long l, File file, File file2) throws IOException {
        this.key = l;
        this.file = file;
        try {
            this.entityFile = new NbtSlotFile(file2);
        }
        catch (Exception exception) {
            System.out.println("Broken entity file: " + file2 + " (" + exception.toString() + "), replacing..");
            file2.delete();
            file2.createNewFile();
            this.entityFile = new NbtSlotFile(file2);
        }
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        try {
            this.readHeader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Broken zone file: " + file + ": " + exception);
        }
    }

    private void readHeader() throws IOException {
        ZoneIo zoneIo = new ZoneIo(this.channel, 0L);
        ByteBuffer byteBuffer = zoneIo.read(4096);
        byteBuffer.flip();
        if (byteBuffer.remaining() < 5) {
            return;
        }
        int n = byteBuffer.getInt();
        if (n != 326332416) {
            throw new IOException("Bad magic number: " + n);
        }
        short s = byteBuffer.getShort();
        if (s != 0) {
            throw new IOException("Bad version number: " + s);
        }
        this.slotCount = byteBuffer.getShort();
        byteBuffer.asShortBuffer().get(this.slots);
        byteBuffer.position(byteBuffer.position() + this.slots.length * 2);
    }

    private void writeHeader() throws IOException {
        ZoneIo zoneIo = new ZoneIo(this.channel, 0L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        byteBuffer.order(ZonedChunkStorage.BYTE_ORDER);
        byteBuffer.putInt(326332416);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort(this.slotCount);
        byteBuffer.asShortBuffer().put(this.slots);
        byteBuffer.position(byteBuffer.position() + this.slots.length * 2);
        byteBuffer.flip();
        zoneIo.write(byteBuffer, 4096);
    }

    public void close() throws IOException {
        this.channel.force(true);
        this.channel.close();
        this.entityFile.close();
    }

    public ZoneIo getZoneIo(int n) throws IOException {
        if (this.slots[n] == 0) {
            this.slots[n] = this.slotCount = (short)(this.slotCount + 1);
            this.writeHeader();
        }
        int n2 = (this.slots[n] - 1) * 98560 + 4096;
        return new ZoneIo(this.channel, n2);
    }

    public boolean containsSlot(int n) {
        return this.slots[n] > 0;
    }
}

