/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityIO;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.tile.entity.TileEntity;

public class OldChunkStorage
implements ChunkStorage {
    private File dir;
    private boolean create;

    public OldChunkStorage(File file, boolean bl) {
        this.dir = file;
        this.create = bl;
    }

    private File getFile(int n, int n2) {
        String string = "c." + Integer.toString(n, 36) + "." + Integer.toString(n2, 36) + ".dat";
        String string2 = Integer.toString(n & 0x3F, 36);
        String string3 = Integer.toString(n2 & 0x3F, 36);
        File file = new File(this.dir, string2);
        if (!file.exists()) {
            if (this.create) {
                file.mkdir();
            } else {
                return null;
            }
        }
        if (!(file = new File(file, string3)).exists()) {
            if (this.create) {
                file.mkdir();
            } else {
                return null;
            }
        }
        if (!(file = new File(file, string)).exists() && !this.create) {
            return null;
        }
        return file;
    }

    public LevelChunk load(Level level, int n, int n2) {
        File file = this.getFile(n, n2);
        if (file != null && file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                CompoundTag compoundTag = NbtIo.readCompressed(fileInputStream);
                if (!compoundTag.contains("Level")) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is missing level data, skipping");
                    return null;
                }
                if (!compoundTag.getCompound("Level").contains("Blocks")) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is missing block data, skipping");
                    return null;
                }
                LevelChunk levelChunk = OldChunkStorage.load(level, compoundTag.getCompound("Level"));
                if (!levelChunk.isAt(n, n2)) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is in the wrong location; relocating. (Expected " + n + ", " + n2 + ", got " + levelChunk.x + ", " + levelChunk.z + ")");
                    compoundTag.putInt("xPos", n);
                    compoundTag.putInt("zPos", n2);
                    levelChunk = OldChunkStorage.load(level, compoundTag.getCompound("Level"));
                }
                return levelChunk;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void save(Level level, LevelChunk levelChunk) {
        level.checkSession();
        File file = this.getFile(levelChunk.x, levelChunk.z);
        if (file.exists()) {
            level.sizeOnDisk -= file.length();
        }
        try {
            File file2 = new File(this.dir, "tmp_chunk.dat");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            CompoundTag compoundTag = new CompoundTag();
            CompoundTag compoundTag2 = new CompoundTag();
            compoundTag.put("Level", compoundTag2);
            this.save(levelChunk, level, compoundTag2);
            NbtIo.writeCompressed(compoundTag, fileOutputStream);
            fileOutputStream.close();
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
            level.sizeOnDisk += file.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(LevelChunk levelChunk, Level level, CompoundTag compoundTag) {
        CompoundTag compoundTag2;
        level.checkSession();
        compoundTag.putInt("xPos", levelChunk.x);
        compoundTag.putInt("zPos", levelChunk.z);
        compoundTag.putLong("LastUpdate", level.time);
        compoundTag.putByteArray("Blocks", levelChunk.blocks);
        compoundTag.putByteArray("Data", levelChunk.data.data);
        compoundTag.putByteArray("SkyLight", levelChunk.skyLight.data);
        compoundTag.putByteArray("BlockLight", levelChunk.blockLight.data);
        compoundTag.putByteArray("HeightMap", levelChunk.heightmap);
        compoundTag.putBoolean("TerrainPopulated", levelChunk.terrainPopulated);
        levelChunk.lastSaveHadEntities = false;
        ListTag<CompoundTag> listTag = new ListTag<CompoundTag>();
        for (int i = 0; i < levelChunk.entityBlocks.length; ++i) {
            for (Entity object : levelChunk.entityBlocks[i]) {
                levelChunk.lastSaveHadEntities = true;
                compoundTag2 = new CompoundTag();
                if (!object.save(compoundTag2)) continue;
                listTag.add(compoundTag2);
            }
        }
        compoundTag.put("Entities", listTag);
        ListTag<CompoundTag> listTag2 = new ListTag<CompoundTag>();
        for (TileEntity tileEntity : levelChunk.tileEntities.values()) {
            compoundTag2 = new CompoundTag();
            tileEntity.save(compoundTag2);
            listTag2.add(compoundTag2);
        }
        compoundTag.put("TileEntities", listTag2);
    }

    public static LevelChunk load(Level level, CompoundTag compoundTag) {
        ListTag<? extends Tag> listTag;
        Object object;
        ListTag<? extends Tag> listTag2;
        int n = compoundTag.getInt("xPos");
        int n2 = compoundTag.getInt("zPos");
        LevelChunk levelChunk = new LevelChunk(level, n, n2);
        levelChunk.blocks = compoundTag.getByteArray("Blocks");
        levelChunk.data = new DataLayer(compoundTag.getByteArray("Data"));
        levelChunk.skyLight = new DataLayer(compoundTag.getByteArray("SkyLight"));
        levelChunk.blockLight = new DataLayer(compoundTag.getByteArray("BlockLight"));
        levelChunk.heightmap = compoundTag.getByteArray("HeightMap");
        levelChunk.terrainPopulated = compoundTag.getBoolean("TerrainPopulated");
        if (!levelChunk.data.isValid()) {
            levelChunk.data = new DataLayer(levelChunk.blocks.length);
        }
        if (levelChunk.heightmap == null || !levelChunk.skyLight.isValid()) {
            levelChunk.heightmap = new byte[256];
            levelChunk.skyLight = new DataLayer(levelChunk.blocks.length);
            levelChunk.recalcHeightmap();
        }
        if (!levelChunk.blockLight.isValid()) {
            levelChunk.blockLight = new DataLayer(levelChunk.blocks.length);
            levelChunk.recalcBlockLights();
        }
        if ((listTag2 = compoundTag.getList("Entities")) != null) {
            for (int i = 0; i < listTag2.size(); ++i) {
                CompoundTag compoundTag2 = (CompoundTag)listTag2.get(i);
                object = EntityIO.loadStatic(compoundTag2, level);
                levelChunk.lastSaveHadEntities = true;
                if (object == null) continue;
                levelChunk.addEntity((Entity)object);
            }
        }
        if ((listTag = compoundTag.getList("TileEntities")) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                object = (CompoundTag)listTag.get(i);
                TileEntity tileEntity = TileEntity.loadStatic((CompoundTag)object);
                if (tileEntity == null) continue;
                levelChunk.addTileEntity(tileEntity);
            }
        }
        return levelChunk;
    }

    public void tick() {
    }

    public void flush() {
    }

    public void saveEntities(Level level, LevelChunk levelChunk) {
    }
}

