/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbtSlotFile {
    private static final byte[] READ_BUFFER = new byte[0x100000];
    private static final int FILE_HEADER_SIZE = 1024;
    private static final int MAGIC_NUMBER = 326332417;
    private static final int FILE_SLOT_HEADER_SIZE = 12;
    private static final int FILE_SLOT_SIZE = 500;
    private RandomAccessFile raf;
    private List<Integer>[] fileSlotMap = new List[1024];
    private List<Integer> freeFileSlots = new ArrayList<Integer>();
    private int totalFileSlots = 0;
    private static long largest = 0L;
    private List<Integer> toReplace;

    public NbtSlotFile(File file) throws IOException {
        int n;
        if (!file.exists() || file.length() == 0L) {
            file.createNewFile();
            this.raf = new RandomAccessFile(file, "rw");
            this.writeHeader();
        } else {
            this.raf = new RandomAccessFile(file, "rw");
        }
        this.readHeader();
        for (n = 0; n < this.fileSlotMap.length; ++n) {
            this.fileSlotMap[n] = new ArrayList<Integer>();
        }
        for (n = 0; n < this.totalFileSlots; ++n) {
            this.seekSlotHeader(n);
            short s = this.raf.readShort();
            if (s == 0) {
                this.freeFileSlots.add(n);
                continue;
            }
            if (s < 0) {
                this.fileSlotMap[-s - 1].add(n);
                continue;
            }
            this.fileSlotMap[s - 1].add(n);
        }
    }

    private void readHeader() throws IOException {
        this.raf.seek(0L);
        int n = this.raf.readInt();
        if (n != 326332417) {
            throw new IOException("Bad magic number: " + n);
        }
        short s = this.raf.readShort();
        if (s != 0) {
            throw new IOException("Bad version number: " + s);
        }
        this.totalFileSlots = this.raf.readInt();
    }

    private void writeHeader() throws IOException {
        this.raf.seek(0L);
        this.raf.writeInt(326332417);
        this.raf.writeShort(0);
        this.raf.writeInt(this.totalFileSlots);
    }

    private void seekSlotHeader(int n) throws IOException {
        int n2 = 1024 + n * 512;
        this.raf.seek(n2);
    }

    private void seekSlot(int n) throws IOException {
        int n2 = 1024 + n * 512;
        this.raf.seek(n2 + 12);
    }

    public List<CompoundTag> readAll(int n) throws IOException {
        ArrayList<CompoundTag> arrayList = new ArrayList<CompoundTag>();
        List<Integer> list = this.fileSlotMap[n];
        int n2 = 0;
        block0: for (int i = 0; i < list.size(); ++i) {
            int n3 = list.get(i);
            int n4 = 0;
            int n5 = -1;
            int n6 = n + 1;
            do {
                this.seekSlotHeader(n3);
                short s = this.raf.readShort();
                short s2 = this.raf.readShort();
                n5 = this.raf.readInt();
                int n7 = this.raf.readInt();
                this.seekSlot(n3);
                if (n6 > 0 && s == -n6) {
                    ++n2;
                    continue block0;
                }
                if (s != n6) {
                    throw new IOException("Wrong slot! Got " + s + ", expected " + n6);
                }
                this.raf.readFully(READ_BUFFER, n4, s2);
                if (n5 < 0) continue;
                n4 += s2;
                n3 = n5;
                n6 = -n - 1;
            } while (n5 >= 0);
            arrayList.add(NbtIo.decompress(READ_BUFFER));
        }
        return arrayList;
    }

    private int getFreeSlot() throws IOException {
        int n;
        if (this.toReplace.size() > 0) {
            n = this.toReplace.remove(this.toReplace.size() - 1);
        } else if (this.freeFileSlots.size() > 0) {
            n = this.freeFileSlots.remove(this.freeFileSlots.size() - 1);
        } else {
            n = this.totalFileSlots++;
            this.writeHeader();
        }
        return n;
    }

    public void replaceSlot(int n, List<CompoundTag> list) throws IOException {
        Object object;
        int n2;
        this.toReplace = this.fileSlotMap[n];
        this.fileSlotMap[n] = new ArrayList<Integer>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            byte[] byArray = NbtIo.compress((CompoundTag)object);
            if ((long)byArray.length > largest) {
                largest = byArray.length;
                System.out.println("New largest: " + largest + " (" + ((CompoundTag)object).getString("id") + ")");
            }
            int n3 = 0;
            int n4 = byArray.length;
            if (n4 == 0) continue;
            int n5 = this.getFreeSlot();
            int n6 = n + 1;
            int n7 = -1;
            while (n4 > 0) {
                int n8 = n5;
                this.fileSlotMap[n].add(n8);
                int n9 = n4;
                if (n9 > 500) {
                    n9 = 500;
                }
                n5 = (n4 -= n9) > 0 ? this.getFreeSlot() : -1;
                this.seekSlotHeader(n8);
                this.raf.writeShort(n6);
                this.raf.writeShort(n9);
                this.raf.writeInt(n5);
                this.raf.writeInt(n7);
                this.seekSlot(n8);
                this.raf.write(byArray, n3, n9);
                if (n4 <= 0) continue;
                n7 = n8;
                n3 += n9;
                n6 = -n - 1;
            }
        }
        for (n2 = 0; n2 < this.toReplace.size(); ++n2) {
            object = this.toReplace.get(n2);
            this.freeFileSlots.add((Integer)object);
            this.seekSlotHeader((Integer)object);
            this.raf.writeShort(0);
        }
        this.toReplace.clear();
    }

    public void close() throws IOException {
        this.raf.getFD().sync();
        this.raf.close();
    }
}

