/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.io.IOException;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import util.ProgressListener;

public class ReadOnlyChunkCache
implements ChunkSource {
    private static final int LEN = 16;
    private static final int LEN_MASK = 15;
    private LevelChunk[] chunks = new LevelChunk[256];
    private Level level;
    private ChunkStorage storage;
    byte[] emptyPixels = new byte[32768];

    public ReadOnlyChunkCache(Level level, ChunkStorage chunkStorage) {
        this.level = level;
        this.storage = chunkStorage;
    }

    public boolean hasChunk(int n, int n2) {
        int n3 = n & 0xF | (n2 & 0xF) * 16;
        return this.chunks[n3] != null && this.chunks[n3].isAt(n, n2);
    }

    public LevelChunk getChunk(int n, int n2) {
        int n3 = n & 0xF | (n2 & 0xF) * 16;
        try {
            if (!this.hasChunk(n, n2)) {
                LevelChunk levelChunk = this.load(n, n2);
                if (levelChunk == null) {
                    levelChunk = new EmptyLevelChunk(this.level, this.emptyPixels, n, n2);
                }
                this.chunks[n3] = levelChunk;
            }
            return this.chunks[n3];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private synchronized LevelChunk load(int n, int n2) {
        try {
            return this.storage.load(this.level, n, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void postProcess(ChunkSource chunkSource, int n, int n2) {
    }

    public boolean save(boolean bl, ProgressListener progressListener) {
        return true;
    }

    public boolean tick() {
        return false;
    }

    public boolean shouldSave() {
        return false;
    }

    public String gatherStats() {
        return "ReadOnlyChunkCache";
    }
}

