/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.TilePos;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.tile.EntityTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;
import util.Mth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelChunk {
    public static boolean touchedSky;
    public byte[] blocks;
    public boolean loaded;
    public Level level;
    public DataLayer data;
    public DataLayer skyLight;
    public DataLayer blockLight;
    public byte[] heightmap;
    public int minHeight;
    public final int x;
    public final int z;
    public Map<TilePos, TileEntity> tileEntities = new HashMap<TilePos, TileEntity>();
    public List<Entity>[] entityBlocks = new List[8];
    public boolean terrainPopulated = false;
    public boolean unsaved = false;
    public boolean dontSave;
    public boolean lastSaveHadEntities = false;
    public long lastSaveTime = 0L;

    public LevelChunk(Level level, int n, int n2) {
        this.level = level;
        this.x = n;
        this.z = n2;
        this.heightmap = new byte[256];
        for (int i = 0; i < this.entityBlocks.length; ++i) {
            this.entityBlocks[i] = new ArrayList<Entity>();
        }
    }

    public LevelChunk(Level level, byte[] byArray, int n, int n2) {
        this(level, n, n2);
        this.blocks = byArray;
        this.data = new DataLayer(byArray.length);
        this.skyLight = new DataLayer(byArray.length);
        this.blockLight = new DataLayer(byArray.length);
    }

    public boolean isAt(int n, int n2) {
        return n == this.x && n2 == this.z;
    }

    public int getHeightmap(int n, int n2) {
        return this.heightmap[n2 << 4 | n] & 0xFF;
    }

    public void recalcBlockLights() {
    }

    public void recalcHeightmapOnly() {
        int n = 127;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n2;
                int n3 = i << 11 | j << 7;
                for (n2 = 127; n2 > 0 && Tile.lightBlock[this.blocks[n3 + n2 - 1]] == 0; --n2) {
                }
                this.heightmap[j << 4 | i] = (byte)n2;
                if (n2 >= n) continue;
                n = n2;
            }
        }
        this.minHeight = n;
        this.unsaved = true;
    }

    public void recalcHeightmap() {
        int n;
        int n2;
        int n3 = 127;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                int n4;
                int n5 = n2 << 11 | n << 7;
                for (n4 = 127; n4 > 0 && Tile.lightBlock[this.blocks[n5 + n4 - 1]] == 0; --n4) {
                }
                this.heightmap[n << 4 | n2] = (byte)n4;
                if (n4 < n3) {
                    n3 = n4;
                }
                if (this.level.dimension.hasCeiling) continue;
                int n6 = 15;
                int n7 = 127;
                do {
                    if ((n6 -= Tile.lightBlock[this.blocks[n5 + n7]]) <= 0) continue;
                    this.skyLight.set(n2, n7, n, n6);
                } while (--n7 > 0 && n6 > 0);
            }
        }
        this.minHeight = n3;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                this.lightGaps(n2, n);
            }
        }
        this.unsaved = true;
    }

    public void lightLava() {
        int n = 32;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n2;
                int n3;
                int n4 = i << 11 | j << 7;
                for (n3 = 0; n3 < 128; ++n3) {
                    n2 = Tile.lightEmission[this.blocks[n4 + n3]];
                    if (n2 <= 0) continue;
                    this.blockLight.set(i, n3, j, n2);
                }
                n3 = 15;
                n2 = n - 2;
                while (n2 < 128 && n3 > 0) {
                    byte by = this.blocks[n4 + ++n2];
                    int n5 = Tile.lightBlock[by];
                    int n6 = Tile.lightEmission[by];
                    if (n5 == 0) {
                        n5 = 1;
                    }
                    if (n6 > (n3 -= n5)) {
                        n3 = n6;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    this.blockLight.set(i, n2, j, n3);
                }
            }
        }
        this.level.updateLight(LightLayer.Block, this.x * 16, n - 1, this.z * 16, this.x * 16 + 16, n + 1, this.z * 16 + 16);
        this.unsaved = true;
    }

    private void lightGaps(int n, int n2) {
        int n3 = this.getHeightmap(n, n2);
        int n4 = this.x * 16 + n;
        int n5 = this.z * 16 + n2;
        this.lightGap(n4 - 1, n5, n3);
        this.lightGap(n4 + 1, n5, n3);
        this.lightGap(n4, n5 - 1, n3);
        this.lightGap(n4, n5 + 1, n3);
    }

    private void lightGap(int n, int n2, int n3) {
        int n4 = this.level.getHeightmap(n, n2);
        if (n4 > n3) {
            this.level.updateLight(LightLayer.Sky, n, n3, n2, n, n4, n2);
            this.unsaved = true;
        } else if (n4 < n3) {
            this.level.updateLight(LightLayer.Sky, n, n4, n2, n, n3, n2);
            this.unsaved = true;
        }
    }

    private void recalcHeight(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n7 = this.heightmap[n3 << 4 | n] & 0xFF;
        if (n2 > n7) {
            n8 = n2;
        }
        int n9 = n << 11 | n3 << 7;
        while (n8 > 0 && Tile.lightBlock[this.blocks[n9 + n8 - 1]] == 0) {
            --n8;
        }
        if (n8 == n7) {
            return;
        }
        this.level.lightColumnChanged(n, n3, n8, n7);
        this.heightmap[n3 << 4 | n] = (byte)n8;
        if (n8 < this.minHeight) {
            this.minHeight = n8;
        } else {
            n6 = 127;
            for (n5 = 0; n5 < 16; ++n5) {
                for (n4 = 0; n4 < 16; ++n4) {
                    if ((this.heightmap[n4 << 4 | n5] & 0xFF) >= n6) continue;
                    n6 = this.heightmap[n4 << 4 | n5] & 0xFF;
                }
            }
            this.minHeight = n6;
        }
        n6 = this.x * 16 + n;
        n5 = this.z * 16 + n3;
        if (n8 < n7) {
            for (n4 = n8; n4 < n7; ++n4) {
                this.skyLight.set(n, n4, n3, 15);
            }
        } else {
            this.level.updateLight(LightLayer.Sky, n6, n7, n5, n6, n8, n5);
            for (n4 = n7; n4 < n8; ++n4) {
                this.skyLight.set(n, n4, n3, 0);
            }
        }
        n4 = 15;
        int n10 = n8;
        while (n8 > 0 && n4 > 0) {
            int n11;
            if ((n11 = Tile.lightBlock[this.getTile(n, --n8, n3)]) == 0) {
                n11 = 1;
            }
            if ((n4 -= n11) < 0) {
                n4 = 0;
            }
            this.skyLight.set(n, n8, n3, n4);
        }
        while (n8 > 0 && Tile.lightBlock[this.getTile(n, n8 - 1, n3)] == 0) {
            --n8;
        }
        if (n8 != n10) {
            this.level.updateLight(LightLayer.Sky, n6 - 1, n8, n5 - 1, n6 + 1, n10, n5 + 1);
        }
        this.unsaved = true;
    }

    public int getTile(int n, int n2, int n3) {
        return this.blocks[n << 11 | n3 << 7 | n2];
    }

    public boolean setTileAndData(int n, int n2, int n3, int n4, int n5) {
        byte by = (byte)n4;
        int n6 = this.heightmap[n3 << 4 | n] & 0xFF;
        int n7 = this.blocks[n << 11 | n3 << 7 | n2] & 0xFF;
        if (n7 == n4 && this.data.get(n, n2, n3) == n5) {
            return false;
        }
        int n8 = this.x * 16 + n;
        int n9 = this.z * 16 + n3;
        this.blocks[n << 11 | n3 << 7 | n2] = by;
        if (n7 != 0 && !this.level.isOnline) {
            Tile.tiles[n7].onRemove(this.level, n8, n2, n9);
        }
        this.data.set(n, n2, n3, n5);
        if (!this.level.dimension.hasCeiling) {
            if (Tile.lightBlock[by] != 0) {
                if (n2 >= n6) {
                    this.recalcHeight(n, n2 + 1, n3);
                }
            } else if (n2 == n6 - 1) {
                this.recalcHeight(n, n2, n3);
            }
            this.level.updateLight(LightLayer.Sky, n8, n2, n9, n8, n2, n9);
        }
        this.level.updateLight(LightLayer.Block, n8, n2, n9, n8, n2, n9);
        this.lightGaps(n, n3);
        this.data.set(n, n2, n3, n5);
        if (n4 != 0) {
            Tile.tiles[n4].onPlace(this.level, n8, n2, n9);
        }
        this.unsaved = true;
        return true;
    }

    public boolean setTile(int n, int n2, int n3, int n4) {
        byte by = (byte)n4;
        int n5 = this.heightmap[n3 << 4 | n] & 0xFF;
        int n6 = this.blocks[n << 11 | n3 << 7 | n2] & 0xFF;
        if (n6 == n4) {
            return false;
        }
        int n7 = this.x * 16 + n;
        int n8 = this.z * 16 + n3;
        this.blocks[n << 11 | n3 << 7 | n2] = by;
        if (n6 != 0) {
            Tile.tiles[n6].onRemove(this.level, n7, n2, n8);
        }
        this.data.set(n, n2, n3, 0);
        if (Tile.lightBlock[by] != 0) {
            if (n2 >= n5) {
                this.recalcHeight(n, n2 + 1, n3);
            }
        } else if (n2 == n5 - 1) {
            this.recalcHeight(n, n2, n3);
        }
        this.level.updateLight(LightLayer.Sky, n7, n2, n8, n7, n2, n8);
        this.level.updateLight(LightLayer.Block, n7, n2, n8, n7, n2, n8);
        this.lightGaps(n, n3);
        if (n4 != 0 && !this.level.isOnline) {
            Tile.tiles[n4].onPlace(this.level, n7, n2, n8);
        }
        this.unsaved = true;
        return true;
    }

    public int getData(int n, int n2, int n3) {
        return this.data.get(n, n2, n3);
    }

    public void setData(int n, int n2, int n3, int n4) {
        this.unsaved = true;
        this.data.set(n, n2, n3, n4);
    }

    public int getBrightness(LightLayer lightLayer, int n, int n2, int n3) {
        if (lightLayer == LightLayer.Sky) {
            return this.skyLight.get(n, n2, n3);
        }
        if (lightLayer == LightLayer.Block) {
            return this.blockLight.get(n, n2, n3);
        }
        return 0;
    }

    public void setBrightness(LightLayer lightLayer, int n, int n2, int n3, int n4) {
        this.unsaved = true;
        if (lightLayer == LightLayer.Sky) {
            this.skyLight.set(n, n2, n3, n4);
        } else if (lightLayer == LightLayer.Block) {
            this.blockLight.set(n, n2, n3, n4);
        } else {
            return;
        }
    }

    public int getRawBrightness(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.skyLight.get(n, n2, n3);
        if (n6 > 0) {
            touchedSky = true;
        }
        if ((n5 = this.blockLight.get(n, n2, n3)) > (n6 -= n4)) {
            n6 = n5;
        }
        return n6;
    }

    public void addEntity(Entity entity) {
        int n;
        this.lastSaveHadEntities = true;
        int n2 = Mth.floor(entity.x / 16.0);
        int n3 = Mth.floor(entity.z / 16.0);
        if (n2 != this.x || n3 != this.z) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((n = Mth.floor(entity.y / 16.0)) < 0) {
            n = 0;
        }
        if (n >= this.entityBlocks.length) {
            n = this.entityBlocks.length - 1;
        }
        entity.inChunk = true;
        entity.xChunk = this.x;
        entity.yChunk = n;
        entity.zChunk = this.z;
        this.entityBlocks[n].add(entity);
    }

    public void removeEntity(Entity entity) {
        this.removeEntity(entity, entity.yChunk);
    }

    public void removeEntity(Entity entity, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.entityBlocks.length) {
            n = this.entityBlocks.length - 1;
        }
        this.entityBlocks[n].remove(entity);
    }

    public boolean isSkyLit(int n, int n2, int n3) {
        return n2 >= (this.heightmap[n3 << 4 | n] & 0xFF);
    }

    public void skyBrightnessChanged() {
        int n = this.x * 16;
        int n2 = this.minHeight - 16;
        int n3 = this.z * 16;
        int n4 = this.x * 16 + 16;
        int n5 = 127;
        int n6 = this.z * 16 + 16;
        this.level.setTilesDirty(n, n2, n3, n4, n5, n6);
    }

    public TileEntity getTileEntity(int n, int n2, int n3) {
        TilePos tilePos = new TilePos(n, n2, n3);
        TileEntity tileEntity = this.tileEntities.get(tilePos);
        if (tileEntity == null) {
            int n4 = this.getTile(n, n2, n3);
            if (!Tile.isEntityTile[n4]) {
                return null;
            }
            EntityTile entityTile = (EntityTile)Tile.tiles[n4];
            entityTile.onPlace(this.level, this.x * 16 + n, n2, this.z * 16 + n3);
            tileEntity = this.tileEntities.get(tilePos);
        }
        return tileEntity;
    }

    public void addTileEntity(TileEntity tileEntity) {
        int n = tileEntity.x - this.x * 16;
        int n2 = tileEntity.y;
        int n3 = tileEntity.z - this.z * 16;
        this.setTileEntity(n, n2, n3, tileEntity);
    }

    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
        TilePos tilePos = new TilePos(n, n2, n3);
        tileEntity.level = this.level;
        tileEntity.x = this.x * 16 + n;
        tileEntity.y = n2;
        tileEntity.z = this.z * 16 + n3;
        if (this.getTile(n, n2, n3) == 0 || !(Tile.tiles[this.getTile(n, n2, n3)] instanceof EntityTile)) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        if (this.loaded) {
            if (this.tileEntities.get(tilePos) != null) {
                this.level.tileEntityList.remove(this.tileEntities.get(tilePos));
            }
            this.level.tileEntityList.add(tileEntity);
        }
        this.tileEntities.put(tilePos, tileEntity);
    }

    public void removeTileEntity(int n, int n2, int n3) {
        TilePos tilePos = new TilePos(n, n2, n3);
        if (this.loaded) {
            this.level.tileEntityList.remove(this.tileEntities.remove(tilePos));
        }
    }

    public void load() {
        this.loaded = true;
        this.level.tileEntityList.addAll(this.tileEntities.values());
        for (int i = 0; i < this.entityBlocks.length; ++i) {
            this.level.addEntities(this.entityBlocks[i]);
        }
    }

    public void unload() {
        this.loaded = false;
        this.level.tileEntityList.removeAll(this.tileEntities.values());
        for (int i = 0; i < this.entityBlocks.length; ++i) {
            this.level.removeEntities(this.entityBlocks[i]);
        }
    }

    public void markUnsaved() {
        this.unsaved = true;
    }

    public void getEntities(Entity entity, AABB aABB, List<Entity> list) {
        int n = Mth.floor((aABB.y0 - 2.0) / 16.0);
        int n2 = Mth.floor((aABB.y1 + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.entityBlocks.length) {
            n2 = this.entityBlocks.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List<Entity> list2 = this.entityBlocks[i];
            for (int j = 0; j < list2.size(); ++j) {
                Entity entity2 = list2.get(j);
                if (entity2 == entity || !entity2.bb.intersects(aABB)) continue;
                list.add(entity2);
            }
        }
    }

    public void getEntitiesOfClass(Class<? extends Entity> clazz, AABB aABB, List<Entity> list) {
        int n = Mth.floor((aABB.y0 - 2.0) / 16.0);
        int n2 = Mth.floor((aABB.y1 + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.entityBlocks.length) {
            n2 = this.entityBlocks.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List<Entity> list2 = this.entityBlocks[i];
            for (int j = 0; j < list2.size(); ++j) {
                Entity entity = list2.get(j);
                if (!clazz.isAssignableFrom(entity.getClass()) || !entity.bb.intersects(aABB)) continue;
                list.add(entity);
            }
        }
    }

    public int countEntities() {
        int n = 0;
        for (int i = 0; i < this.entityBlocks.length; ++i) {
            n += this.entityBlocks[i].size();
        }
        return n;
    }

    public boolean shouldSave(boolean bl) {
        if (this.dontSave) {
            return false;
        }
        if (bl ? this.lastSaveHadEntities && this.level.time != this.lastSaveTime : this.lastSaveHadEntities && this.level.time >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.unsaved;
    }

    public void setBlocks(byte[] byArray, int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < 8192; ++n3) {
            this.blocks[n * 128 * 16 * 4 + n3] = byArray[n3];
        }
        for (n3 = n * 4; n3 < n * 4 + 4; ++n3) {
            for (n2 = 0; n2 < 16; ++n2) {
                this.recalcHeight(n3, 0, n2);
            }
        }
        n3 = this.x * 16;
        n2 = this.z * 16;
        this.level.updateLight(LightLayer.Sky, n3 + n * 4, 0, n2, n3 + n * 4 + 4, 128, n2 + 16);
        this.level.updateLight(LightLayer.Block, n3 + n * 4, 0, n2, n3 + n * 4 + 4, 128, n2 + 16);
        for (int i = n * 4; i < n * 4 + 4; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.lightGaps(i, j);
            }
        }
        this.level.setTilesDirty(n3 + n * 4, 0, n2, n3 + n * 4 + 4, 128, n2);
    }

    public int getBlocksAndData(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = n11 << 11 | n10 << 7 | n2;
                n8 = n5 - n2;
                System.arraycopy(this.blocks, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.data.data, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.blockLight.data, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.skyLight.data, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        return n7;
    }

    public int setBlocksAndData(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = n11 << 11 | n10 << 7 | n2;
                n8 = n5 - n2;
                System.arraycopy(byArray, n7, this.blocks, n9, n8);
                n7 += n8;
            }
        }
        this.recalcHeightmapOnly();
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(byArray, n7, this.data.data, n9, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(byArray, n7, this.blockLight.data, n9, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(byArray, n7, this.skyLight.data, n9, n8);
                n7 += n8;
            }
        }
        return n7;
    }

    public Random getRandom(long l) {
        return new Random(this.level.seed + (long)(this.x * this.x * 4987142) + (long)(this.x * 5947611) + (long)(this.z * this.z) * 4392871L + (long)(this.z * 389711) ^ l);
    }

    public boolean isEmpty() {
        return false;
    }
}

