/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyLevelChunk
extends LevelChunk {
    public EmptyLevelChunk(Level level, int n, int n2) {
        super(level, n, n2);
        this.dontSave = true;
    }

    public EmptyLevelChunk(Level level, byte[] byArray, int n, int n2) {
        super(level, byArray, n, n2);
        this.dontSave = true;
    }

    @Override
    public boolean isAt(int n, int n2) {
        return n == this.x && n2 == this.z;
    }

    @Override
    public int getHeightmap(int n, int n2) {
        return 0;
    }

    @Override
    public void recalcBlockLights() {
    }

    @Override
    public void recalcHeightmapOnly() {
    }

    @Override
    public void recalcHeightmap() {
    }

    @Override
    public void lightLava() {
    }

    @Override
    public int getTile(int n, int n2, int n3) {
        return 0;
    }

    @Override
    public boolean setTileAndData(int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    @Override
    public boolean setTile(int n, int n2, int n3, int n4) {
        return true;
    }

    @Override
    public int getData(int n, int n2, int n3) {
        return 0;
    }

    @Override
    public void setData(int n, int n2, int n3, int n4) {
    }

    @Override
    public int getBrightness(LightLayer lightLayer, int n, int n2, int n3) {
        return 0;
    }

    @Override
    public void setBrightness(LightLayer lightLayer, int n, int n2, int n3, int n4) {
    }

    @Override
    public int getRawBrightness(int n, int n2, int n3, int n4) {
        return 0;
    }

    @Override
    public void addEntity(Entity entity) {
    }

    @Override
    public void removeEntity(Entity entity) {
    }

    @Override
    public void removeEntity(Entity entity, int n) {
    }

    @Override
    public boolean isSkyLit(int n, int n2, int n3) {
        return false;
    }

    @Override
    public void skyBrightnessChanged() {
    }

    @Override
    public TileEntity getTileEntity(int n, int n2, int n3) {
        return null;
    }

    @Override
    public void addTileEntity(TileEntity tileEntity) {
    }

    @Override
    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
    }

    @Override
    public void removeTileEntity(int n, int n2, int n3) {
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public void markUnsaved() {
    }

    @Override
    public void getEntities(Entity entity, AABB aABB, List<Entity> list) {
    }

    @Override
    public void getEntitiesOfClass(Class<? extends Entity> clazz, AABB aABB, List<Entity> list) {
    }

    @Override
    public int countEntities() {
        return 0;
    }

    @Override
    public boolean shouldSave(boolean bl) {
        return false;
    }

    @Override
    public void setBlocks(byte[] byArray, int n) {
    }

    @Override
    public int getBlocksAndData(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 - n;
        int n9 = n5 - n2;
        int n10 = n6 - n3;
        int n11 = n8 * n9 * n10;
        int n12 = n11 + n11 / 2 * 3;
        Arrays.fill(byArray, n7, n7 + n12, (byte)0);
        return n12;
    }

    @Override
    public int setBlocksAndData(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 - n;
        int n9 = n5 - n2;
        int n10 = n6 - n3;
        int n11 = n8 * n9 * n10;
        return n11 + n11 / 2 * 3;
    }

    @Override
    public Random getRandom(long l) {
        return new Random(this.level.seed + (long)(this.x * this.x * 4987142) + (long)(this.x * 5947611) + (long)(this.z * this.z) * 4392871L + (long)(this.z * 389711) ^ l);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }
}

