/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.io.IOException;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import util.ProgressListener;

public class ChunkCache
implements ChunkSource {
    private static final int CHUNK_CACHE_WIDTH = 32;
    private LevelChunk emptyChunk;
    private ChunkSource source;
    private ChunkStorage storage;
    private LevelChunk[] chunks = new LevelChunk[1024];
    private Level level;
    int xLast = -999999999;
    int zLast = -999999999;
    private LevelChunk last;
    private int xCenter;
    private int yCenter;
    private static final int MAX_SAVES = 2;

    public ChunkCache(Level level, ChunkStorage chunkStorage, ChunkSource chunkSource) {
        this.emptyChunk = new EmptyLevelChunk(level, new byte[32768], 0, 0);
        this.level = level;
        this.storage = chunkStorage;
        this.source = chunkSource;
    }

    public void centerOn(int n, int n2) {
        this.xCenter = n;
        this.yCenter = n2;
    }

    public boolean fits(int n, int n2) {
        int n3 = 15;
        return n >= this.xCenter - n3 && n2 >= this.yCenter - n3 && n <= this.xCenter + n3 && n2 <= this.yCenter + n3;
    }

    public boolean hasChunk(int n, int n2) {
        if (!this.fits(n, n2)) {
            return false;
        }
        if (n == this.xLast && n2 == this.zLast && this.last != null) {
            return true;
        }
        int n3 = n & 0x1F;
        int n4 = n2 & 0x1F;
        int n5 = n3 + n4 * 32;
        return this.chunks[n5] != null && (this.chunks[n5] == this.emptyChunk || this.chunks[n5].isAt(n, n2));
    }

    public LevelChunk getChunk(int n, int n2) {
        if (n == this.xLast && n2 == this.zLast && this.last != null) {
            return this.last;
        }
        if (!this.level.isFindingSpawn && !this.fits(n, n2)) {
            return this.emptyChunk;
        }
        int n3 = n & 0x1F;
        int n4 = n2 & 0x1F;
        int n5 = n3 + n4 * 32;
        if (!this.hasChunk(n, n2)) {
            LevelChunk levelChunk;
            if (this.chunks[n5] != null) {
                this.chunks[n5].unload();
                this.save(this.chunks[n5]);
                this.saveEntities(this.chunks[n5]);
            }
            if ((levelChunk = this.load(n, n2)) == null) {
                levelChunk = this.source == null ? this.emptyChunk : this.source.getChunk(n, n2);
            }
            this.chunks[n5] = levelChunk;
            levelChunk.lightLava();
            if (this.chunks[n5] != null) {
                this.chunks[n5].load();
            }
            if (!this.chunks[n5].terrainPopulated && this.hasChunk(n + 1, n2 + 1) && this.hasChunk(n, n2 + 1) && this.hasChunk(n + 1, n2)) {
                this.postProcess(this, n, n2);
            }
            if (this.hasChunk(n - 1, n2) && !this.getChunk((int)(n - 1), (int)n2).terrainPopulated && this.hasChunk(n - 1, n2 + 1) && this.hasChunk(n, n2 + 1) && this.hasChunk(n - 1, n2)) {
                this.postProcess(this, n - 1, n2);
            }
            if (this.hasChunk(n, n2 - 1) && !this.getChunk((int)n, (int)(n2 - 1)).terrainPopulated && this.hasChunk(n + 1, n2 - 1) && this.hasChunk(n, n2 - 1) && this.hasChunk(n + 1, n2)) {
                this.postProcess(this, n, n2 - 1);
            }
            if (this.hasChunk(n - 1, n2 - 1) && !this.getChunk((int)(n - 1), (int)(n2 - 1)).terrainPopulated && this.hasChunk(n - 1, n2 - 1) && this.hasChunk(n, n2 - 1) && this.hasChunk(n - 1, n2)) {
                this.postProcess(this, n - 1, n2 - 1);
            }
        }
        this.xLast = n;
        this.zLast = n2;
        this.last = this.chunks[n5];
        return this.chunks[n5];
    }

    private LevelChunk load(int n, int n2) {
        if (this.storage == null) {
            return this.emptyChunk;
        }
        try {
            LevelChunk levelChunk = this.storage.load(this.level, n, n2);
            if (levelChunk != null) {
                levelChunk.lastSaveTime = this.level.time;
            }
            return levelChunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.emptyChunk;
        }
    }

    private void saveEntities(LevelChunk levelChunk) {
        if (this.storage == null) {
            return;
        }
        try {
            this.storage.saveEntities(this.level, levelChunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void save(LevelChunk levelChunk) {
        if (this.storage == null) {
            return;
        }
        try {
            levelChunk.lastSaveTime = this.level.time;
            this.storage.save(this.level, levelChunk);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void postProcess(ChunkSource chunkSource, int n, int n2) {
        LevelChunk levelChunk = this.getChunk(n, n2);
        if (!levelChunk.terrainPopulated) {
            levelChunk.terrainPopulated = true;
            if (this.source != null) {
                this.source.postProcess(chunkSource, n, n2);
                levelChunk.markUnsaved();
            }
        }
    }

    public boolean save(boolean bl, ProgressListener progressListener) {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (progressListener != null) {
            for (n = 0; n < this.chunks.length; ++n) {
                if (this.chunks[n] == null || !this.chunks[n].shouldSave(bl)) continue;
                ++n3;
            }
        }
        n = 0;
        for (int i = 0; i < this.chunks.length; ++i) {
            if (this.chunks[i] == null) continue;
            if (bl && !this.chunks[i].dontSave) {
                this.saveEntities(this.chunks[i]);
            }
            if (!this.chunks[i].shouldSave(bl)) continue;
            this.save(this.chunks[i]);
            this.chunks[i].unsaved = false;
            if (++n2 == 2 && !bl) {
                return false;
            }
            if (progressListener == null || ++n % 10 != 0) continue;
            progressListener.progressStagePercentage(n * 100 / n3);
        }
        if (bl) {
            if (this.storage == null) {
                return true;
            }
            this.storage.flush();
        }
        return true;
    }

    public boolean tick() {
        if (this.storage != null) {
            this.storage.tick();
        }
        return this.source.tick();
    }

    public boolean shouldSave() {
        return true;
    }

    public String gatherStats() {
        return "ChunkCache: " + this.chunks.length;
    }
}

