/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import java.util.Random;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class BiomeSource {
    private PerlinSimplexNoise temperatureMap;
    private PerlinSimplexNoise downfallMap;
    private PerlinSimplexNoise noiseMap;
    public double[] temperatures;
    public double[] downfalls;
    public double[] noises;
    public Biome[] biomes;
    private static final float zoom = 2.0f;
    private static final float tempScale = 0.025f;
    private static final float downfallScale = 0.05f;
    private static final float noiseScale = 0.25f;

    protected BiomeSource() {
    }

    public BiomeSource(Level level) {
        this.temperatureMap = new PerlinSimplexNoise(new Random(level.seed * 9871L), 4);
        this.downfallMap = new PerlinSimplexNoise(new Random(level.seed * 39811L), 4);
        this.noiseMap = new PerlinSimplexNoise(new Random(level.seed * 543321L), 2);
    }

    public Biome getBiome(ChunkPos chunkPos) {
        return this.getBiome(chunkPos.x, chunkPos.z);
    }

    public Biome getBiome(int n, int n2) {
        return this.getBiomeBlock(n, n2, 1, 1)[0];
    }

    public double getTemperature(int n, int n2) {
        this.temperatures = this.temperatureMap.getRegion(this.temperatures, n, n2, 1, 1, 0.025f, 0.025f, 0.5);
        return this.temperatures[0];
    }

    public Biome[] getBiomeBlock(int n, int n2, int n3, int n4) {
        this.biomes = this.getBiomeBlock(this.biomes, n, n2, n3, n4);
        return this.biomes;
    }

    public double[] getTemperatureBlock(double[] dArray, int n, int n2, int n3, int n4) {
        if (dArray == null || dArray.length < n3 * n4) {
            dArray = new double[n3 * n4];
        }
        dArray = this.temperatureMap.getRegion(dArray, n, n2, n3, n3, 0.025f, 0.025f, 0.25);
        this.noises = this.noiseMap.getRegion(this.noises, n, n2, n3, n3, 0.25, 0.25, 0.5882352941176471);
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                double d = this.noises[n5] * 1.1 + 0.5;
                double d2 = 0.01;
                double d3 = 1.0 - d2;
                double d4 = (dArray[n5] * 0.15 + 0.7) * d3 + d * d2;
                if ((d4 = 1.0 - (1.0 - d4) * (1.0 - d4)) < 0.0) {
                    d4 = 0.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                dArray[n5] = d4;
                ++n5;
            }
        }
        return dArray;
    }

    public double[] getDownfallBlock(double[] dArray, int n, int n2, int n3, int n4) {
        if (dArray == null || dArray.length < n3 * n4) {
            dArray = new double[n3 * n4];
        }
        dArray = this.downfallMap.getRegion(dArray, n, n2, n3, n3, 0.05f, 0.05f, 0.5);
        return dArray;
    }

    public Biome[] getBiomeBlock(Biome[] biomeArray, int n, int n2, int n3, int n4) {
        if (biomeArray == null || biomeArray.length < n3 * n4) {
            biomeArray = new Biome[n3 * n4];
        }
        this.temperatures = this.temperatureMap.getRegion(this.temperatures, n, n2, n3, n3, 0.025f, 0.025f, 0.25);
        this.downfalls = this.downfallMap.getRegion(this.downfalls, n, n2, n3, n3, 0.05f, 0.05f, 0.3333333333333333);
        this.noises = this.noiseMap.getRegion(this.noises, n, n2, n3, n3, 0.25, 0.25, 0.5882352941176471);
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                double d = this.noises[n5] * 1.1 + 0.5;
                double d2 = 0.01;
                double d3 = 1.0 - d2;
                double d4 = (this.temperatures[n5] * 0.15 + 0.7) * d3 + d * d2;
                d2 = 0.002;
                d3 = 1.0 - d2;
                double d5 = (this.downfalls[n5] * 0.15 + 0.5) * d3 + d * d2;
                if ((d4 = 1.0 - (1.0 - d4) * (1.0 - d4)) < 0.0) {
                    d4 = 0.0;
                }
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                if (d5 > 1.0) {
                    d5 = 1.0;
                }
                this.temperatures[n5] = d4;
                this.downfalls[n5] = d5;
                biomeArray[n5++] = Biome.getBiome(d4, d5);
            }
        }
        return biomeArray;
    }
}

