/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import java.awt.Color;
import java.util.Random;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.biome.FlatBiome;
import net.minecraft.world.level.biome.ForestBiome;
import net.minecraft.world.level.biome.HellBiome;
import net.minecraft.world.level.biome.RainforestBiome;
import net.minecraft.world.level.biome.SwampBiome;
import net.minecraft.world.level.biome.TaigaBiome;
import net.minecraft.world.level.levelgen.feature.BasicTree;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.tile.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Biome {
    public static final Biome rainForest = new RainforestBiome().setColor(588342).setName("Rainforest").setLeafColor(2094168);
    public static final Biome swampland = new SwampBiome().setColor(522674).setName("Swampland").setLeafColor(9154376);
    public static final Biome seasonalForest = new Biome().setColor(10215459).setName("Seasonal Forest");
    public static final Biome forest = new ForestBiome().setColor(353825).setName("Forest").setLeafColor(5159473);
    public static final Biome savanna = new FlatBiome().setColor(14278691).setName("Savanna");
    public static final Biome shrubland = new Biome().setColor(10595616).setName("Shrubland");
    public static final Biome taiga = new TaigaBiome().setColor(3060051).setName("Taiga").setSnowCovered().setLeafColor(8107825);
    public static final Biome desert = new FlatBiome().setColor(16421912).setName("Desert");
    public static final Biome plains = new FlatBiome().setColor(16767248).setName("Plains");
    public static final Biome iceDesert = new FlatBiome().setColor(16772499).setName("Ice Desert").setSnowCovered().setLeafColor(12899129);
    public static final Biome tundra = new Biome().setColor(5762041).setName("Tundra").setSnowCovered().setLeafColor(12899129);
    public static final Biome hell = new HellBiome().setColor(0xFF0000).setName("Hell");
    public String name;
    public int color;
    public byte topMaterial;
    public byte material;
    public int leafColor;
    protected Class[] enemies;
    protected Class[] friendlies;
    protected Class[] waterFriendlies;
    private static Biome[] map = new Biome[4096];

    public Biome() {
        this.topMaterial = (byte)Tile.grass.id;
        this.material = (byte)Tile.dirt.id;
        this.leafColor = 5169201;
        this.enemies = new Class[]{Spider.class, Zombie.class, Skeleton.class, Creeper.class};
        this.friendlies = new Class[]{Sheep.class, Pig.class, Chicken.class, Cow.class};
        this.waterFriendlies = new Class[]{Squid.class};
    }

    public static void recalc() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                Biome.map[i + j * 64] = Biome._getBiome((float)i / 63.0f, (float)j / 63.0f);
            }
        }
        Biome.desert.topMaterial = Biome.desert.material = (byte)Tile.sand.id;
        Biome.iceDesert.topMaterial = Biome.iceDesert.material = (byte)Tile.sand.id;
    }

    public Feature getTreeFeature(Random random) {
        if (random.nextInt(10) == 0) {
            return new BasicTree();
        }
        return new TreeFeature();
    }

    protected Biome setSnowCovered() {
        return this;
    }

    protected Biome setName(String string) {
        this.name = string;
        return this;
    }

    protected Biome setLeafColor(int n) {
        this.leafColor = n;
        return this;
    }

    protected Biome setColor(int n) {
        this.color = n;
        return this;
    }

    public static Biome getBiome(double d, double d2) {
        int n = (int)(d * 63.0);
        int n2 = (int)(d2 * 63.0);
        return map[n + n2 * 64];
    }

    public static Biome _getBiome(float f, float f2) {
        f2 *= f;
        if (f < 0.1f) {
            return tundra;
        }
        if (f2 < 0.2f) {
            if (f < 0.5f) {
                return tundra;
            }
            if (f < 0.95f) {
                return savanna;
            }
            return desert;
        }
        if (f2 > 0.5f && f < 0.7f) {
            return swampland;
        }
        if (f < 0.5f) {
            return taiga;
        }
        if (f < 0.97f) {
            if (f2 < 0.35f) {
                return shrubland;
            }
            return forest;
        }
        if (f2 < 0.45f) {
            return plains;
        }
        if (f2 < 0.9f) {
            return seasonalForest;
        }
        return rainForest;
    }

    public double adjustScale(double d) {
        return d;
    }

    public double adjustDepth(double d) {
        return d;
    }

    public int getSkyColor(float f) {
        if ((f /= 3.0f) < -1.0f) {
            f = -1.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return Color.getHSBColor(0.62222224f - f * 0.05f, 0.5f + f * 0.1f, 1.0f).getRGB();
    }

    public Class<Mob>[] getMobs(MobCategory mobCategory) {
        if (mobCategory == MobCategory.monster) {
            return this.enemies;
        }
        if (mobCategory == MobCategory.creature) {
            return this.friendlies;
        }
        if (mobCategory == MobCategory.waterCreature) {
            return this.waterFriendlies;
        }
        return null;
    }

    static {
        Biome.recalc();
    }
}

