/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.TileEntity;

public class Region
implements LevelSource {
    private int xc1;
    private int zc1;
    private LevelChunk[][] chunks;
    private Level level;

    public Region(Level level, int n, int n2, int n3, int n4, int n5, int n6) {
        this.level = level;
        this.xc1 = n >> 4;
        this.zc1 = n3 >> 4;
        int n7 = n4 >> 4;
        int n8 = n6 >> 4;
        this.chunks = new LevelChunk[n7 - this.xc1 + 1][n8 - this.zc1 + 1];
        for (int i = this.xc1; i <= n7; ++i) {
            for (int j = this.zc1; j <= n8; ++j) {
                this.chunks[i - this.xc1][j - this.zc1] = level.getChunk(i, j);
            }
        }
    }

    public int getTile(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            return 0;
        }
        int n4 = (n >> 4) - this.xc1;
        int n5 = (n3 >> 4) - this.zc1;
        try {
            LevelChunk levelChunk = this.chunks[n4][n5];
            if (levelChunk == null) {
                return 0;
            }
            return levelChunk.getTile(n & 0xF, n2, n3 & 0xF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public TileEntity getTileEntity(int n, int n2, int n3) {
        int n4 = (n >> 4) - this.xc1;
        int n5 = (n3 >> 4) - this.zc1;
        return this.chunks[n4][n5].getTileEntity(n & 0xF, n2, n3 & 0xF);
    }

    public float getBrightness(int n, int n2, int n3) {
        return this.level.dimension.brightnessRamp[this.getRawBrightness(n, n2, n3)];
    }

    public int getRawBrightness(int n, int n2, int n3) {
        return this.getRawBrightness(n, n2, n3, true);
    }

    public int getRawBrightness(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return 15;
        }
        if (bl && ((n4 = this.getTile(n, n2, n3)) == Tile.stoneSlabHalf.id || n4 == Tile.farmland.id)) {
            int n5 = this.getRawBrightness(n, n2 + 1, n3, false);
            int n6 = this.getRawBrightness(n + 1, n2, n3, false);
            int n7 = this.getRawBrightness(n - 1, n2, n3, false);
            int n8 = this.getRawBrightness(n, n2, n3 + 1, false);
            int n9 = this.getRawBrightness(n, n2, n3 - 1, false);
            if (n6 > n5) {
                n5 = n6;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n9 > n5) {
                n5 = n9;
            }
            return n5;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            n4 = 15 - this.level.skyDarken;
            if (n4 < 0) {
                n4 = 0;
            }
            return n4;
        }
        n4 = (n >> 4) - this.xc1;
        int n10 = (n3 >> 4) - this.zc1;
        return this.chunks[n4][n10].getRawBrightness(n & 0xF, n2, n3 & 0xF, this.level.skyDarken);
    }

    public int getData(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            return 0;
        }
        int n4 = (n >> 4) - this.xc1;
        int n5 = (n3 >> 4) - this.zc1;
        return this.chunks[n4][n5].getData(n & 0xF, n2, n3 & 0xF);
    }

    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTile(n, n2, n3);
        if (n4 == 0) {
            return Material.air;
        }
        return Tile.tiles[n4].material;
    }

    public boolean isSolidTile(int n, int n2, int n3) {
        Tile tile = Tile.tiles[this.getTile(n, n2, n3)];
        if (tile == null) {
            return false;
        }
        return tile.isSolidRender();
    }

    public BiomeSource getBiomeSource() {
        return this.level.getBiomeSource();
    }
}

