/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TilePos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Material;
import util.Mth;

public final class MobSpawner {
    private static final int MIN_SPAWN_DISTANCE = 24;
    private static Set<ChunkPos> chunksToPoll = new HashSet<ChunkPos>();

    protected static TilePos getRandomPosWithin(Level level, int n, int n2) {
        int n3 = n + level.random.nextInt(16);
        int n4 = level.random.nextInt(128);
        int n5 = n2 + level.random.nextInt(16);
        return new TilePos(n3, n4, n5);
    }

    public static final int tick(Level level, boolean bl, boolean bl2) {
        int n;
        if (!bl && !bl2) {
            return 0;
        }
        chunksToPoll.clear();
        for (n = 0; n < level.players.size(); ++n) {
            Player object = level.players.get(n);
            int n2 = Mth.floor(object.x / 16.0);
            int n3 = Mth.floor(object.z / 16.0);
            int mobCategory = 8;
            for (int i = -mobCategory; i <= mobCategory; ++i) {
                for (int j = -mobCategory; j <= mobCategory; ++j) {
                    chunksToPoll.add(new ChunkPos(i + n2, j + n3));
                }
            }
        }
        n = 0;
        for (MobCategory mobCategory : MobCategory.values()) {
            if (mobCategory.isFriendly() && !bl2 || !mobCategory.isFriendly() && !bl || level.countInstanceOf(mobCategory.getBaseClass()) > mobCategory.getMaxInstancesPerChunk() * chunksToPoll.size() / 256) continue;
            block6: for (ChunkPos chunkPos : chunksToPoll) {
                Biome biome = level.getBiomeSource().getBiome(chunkPos);
                Class<Mob>[] classArray = biome.getMobs(mobCategory);
                if (classArray == null || classArray.length == 0) continue;
                int n4 = level.random.nextInt(classArray.length);
                TilePos tilePos = MobSpawner.getRandomPosWithin(level, chunkPos.x * 16, chunkPos.z * 16);
                int n5 = tilePos.x;
                int n6 = tilePos.y;
                int n7 = tilePos.z;
                if (level.isSolidTile(n5, n6, n7) || level.getMaterial(n5, n6, n7) != mobCategory.getSpawnPositionMaterial()) continue;
                int n8 = 0;
                for (int i = 0; i < 3; ++i) {
                    int n9 = n5;
                    int n10 = n6;
                    int n11 = n7;
                    int n12 = 6;
                    for (int j = 0; j < 4; ++j) {
                        Mob mob;
                        float f;
                        float exception;
                        float mob2;
                        float f2;
                        float f3;
                        float f4;
                        float f5;
                        if (!MobSpawner.isSpawnPositionOk(mobCategory, level, n9 += level.random.nextInt(n12) - level.random.nextInt(n12), n10 += level.random.nextInt(1) - level.random.nextInt(1), n11 += level.random.nextInt(n12) - level.random.nextInt(n12)) || level.getNearestPlayer(f5 = (float)n9 + 0.5f, f4 = (float)n10, f3 = (float)n11 + 0.5f, 24.0) != null || (f2 = (mob2 = f5 - (float)level.xSpawn) * mob2 + (exception = f4 - (float)level.ySpawn) * exception + (f = f3 - (float)level.zSpawn) * f) < 576.0f) continue;
                        try {
                            mob = classArray[n4].getConstructor(Level.class).newInstance(level);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                            return n;
                        }
                        mob.moveTo(f5, f4, f3, level.random.nextFloat() * 360.0f, 0.0f);
                        if (mob.canSpawn()) {
                            level.addEntity(mob);
                            MobSpawner.finalizeMobSettings(mob, level, f5, f4, f3);
                            if (++n8 >= mob.getMaxSpawnClusterSize()) continue block6;
                        }
                        n += n8;
                    }
                }
            }
        }
        return n;
    }

    private static boolean isSpawnPositionOk(MobCategory mobCategory, Level level, int n, int n2, int n3) {
        if (mobCategory.getSpawnPositionMaterial() == Material.water) {
            return level.getMaterial(n, n2, n3).isLiquid() && !level.isSolidTile(n, n2 + 1, n3);
        }
        return level.isSolidTile(n, n2 - 1, n3) && !level.isSolidTile(n, n2, n3) && !level.getMaterial(n, n2, n3).isLiquid() && !level.isSolidTile(n, n2 + 1, n3);
    }

    private static void finalizeMobSettings(Mob mob, Level level, float f, float f2, float f3) {
        if (mob instanceof Spider && level.random.nextInt(100) == 0) {
            Skeleton skeleton = new Skeleton(level);
            skeleton.moveTo(f, f2, f3, mob.yRot, 0.0f);
            level.addEntity(skeleton);
            skeleton.ride(mob);
        } else if (mob instanceof Sheep) {
            ((Sheep)mob).setColor(Sheep.getSheepColor(level.random));
        }
    }
}

