/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.tile.Tile;

public class LightUpdate {
    public final LightLayer layer;
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;

    public LightUpdate(LightLayer lightLayer, int n, int n2, int n3, int n4, int n5, int n6) {
        this.layer = lightLayer;
        this.x0 = n;
        this.y0 = n2;
        this.z0 = n3;
        this.x1 = n4;
        this.y1 = n5;
        this.z1 = n6;
    }

    public void update(Level level) {
        int n = this.x1 - this.x0 + 1;
        int n2 = this.y1 - this.y0 + 1;
        int n3 = this.z1 - this.z0 + 1;
        int n4 = n * n2 * n3;
        if (n4 > 32768) {
            System.out.println("Light too large, skipping!");
            return;
        }
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = this.x0; i <= this.x1; ++i) {
            for (int j = this.z0; j <= this.z1; ++j) {
                int n7 = i >> 4;
                int n8 = j >> 4;
                boolean bl3 = false;
                if (bl && n7 == n5 && n8 == n6) {
                    bl3 = bl2;
                } else {
                    LevelChunk levelChunk;
                    bl3 = level.hasChunksAt(i, 0, j, 1);
                    if (bl3 && (levelChunk = level.getChunk(i >> 4, j >> 4)).isEmpty()) {
                        bl3 = false;
                    }
                    bl2 = bl3;
                    n5 = n7;
                    n6 = n8;
                }
                if (!bl3) continue;
                if (this.y0 < 0) {
                    this.y0 = 0;
                }
                if (this.y1 >= 128) {
                    this.y1 = 127;
                }
                for (int k = this.y0; k <= this.y1; ++k) {
                    int n9;
                    int n10 = level.getBrightness(this.layer, i, k, j);
                    int n11 = 0;
                    int n12 = level.getTile(i, k, j);
                    int n13 = Tile.lightBlock[n12];
                    if (n13 == 0) {
                        n13 = 1;
                    }
                    int n14 = 0;
                    if (this.layer == LightLayer.Sky) {
                        if (level.isSkyLit(i, k, j)) {
                            n14 = 15;
                        }
                    } else if (this.layer == LightLayer.Block) {
                        n14 = Tile.lightEmission[n12];
                    }
                    if (n13 >= 15 && n14 == 0) {
                        n11 = 0;
                    } else {
                        n9 = level.getBrightness(this.layer, i - 1, k, j);
                        int n15 = level.getBrightness(this.layer, i + 1, k, j);
                        int n16 = level.getBrightness(this.layer, i, k - 1, j);
                        int n17 = level.getBrightness(this.layer, i, k + 1, j);
                        int n18 = level.getBrightness(this.layer, i, k, j - 1);
                        int n19 = level.getBrightness(this.layer, i, k, j + 1);
                        n11 = n9;
                        if (n15 > n11) {
                            n11 = n15;
                        }
                        if (n16 > n11) {
                            n11 = n16;
                        }
                        if (n17 > n11) {
                            n11 = n17;
                        }
                        if (n18 > n11) {
                            n11 = n18;
                        }
                        if (n19 > n11) {
                            n11 = n19;
                        }
                        if ((n11 -= n13) < 0) {
                            n11 = 0;
                        }
                        if (n14 > n11) {
                            n11 = n14;
                        }
                    }
                    if (n10 == n11) continue;
                    level.setBrightness(this.layer, i, k, j, n11);
                    n9 = n11 - 1;
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    level.updateLightIfOtherThan(this.layer, i - 1, k, j, n9);
                    level.updateLightIfOtherThan(this.layer, i, k - 1, j, n9);
                    level.updateLightIfOtherThan(this.layer, i, k, j - 1, n9);
                    if (i + 1 >= this.x1) {
                        level.updateLightIfOtherThan(this.layer, i + 1, k, j, n9);
                    }
                    if (k + 1 >= this.y1) {
                        level.updateLightIfOtherThan(this.layer, i, k + 1, j, n9);
                    }
                    if (j + 1 < this.z1) continue;
                    level.updateLightIfOtherThan(this.layer, i, k, j + 1, n9);
                }
            }
        }
    }

    public boolean expandToContain(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n >= this.x0 && n2 >= this.y0 && n3 >= this.z0 && n4 <= this.x1 && n5 <= this.y1 && n6 <= this.z1) {
            return true;
        }
        int n7 = 1;
        if (n >= this.x0 - n7 && n2 >= this.y0 - n7 && n3 >= this.z0 - n7 && n4 <= this.x1 + n7 && n5 <= this.y1 + n7 && n6 <= this.z1 + n7) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = this.x1 - this.x0;
            int n14 = this.y1 - this.y0;
            int n15 = this.z1 - this.z0;
            if (n > this.x0) {
                n = this.x0;
            }
            if (n2 > this.y0) {
                n2 = this.y0;
            }
            if (n3 > this.z0) {
                n3 = this.z0;
            }
            if (n4 < this.x1) {
                n4 = this.x1;
            }
            if (n5 < this.y1) {
                n5 = this.y1;
            }
            if (n6 < this.z1) {
                n6 = this.z1;
            }
            if ((n12 = (n11 = n4 - n) * (n10 = n5 - n2) * (n9 = n6 - n3)) - (n8 = n13 * n14 * n15) <= 2) {
                this.x0 = n;
                this.y0 = n2;
                this.z0 = n3;
                this.x1 = n4;
                this.y1 = n5;
                this.z1 = n6;
                return true;
            }
        }
        return false;
    }
}

