/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;

public class LevelObjectInputStream
extends ObjectInputStream {
    private Set<String> autoReplacers = new HashSet<String>();

    public LevelObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.autoReplacers.add("com.mojang.minecraft.player.Player$1");
        this.autoReplacers.add("com.mojang.minecraft.mob.Creeper$1");
        this.autoReplacers.add("com.mojang.minecraft.mob.Skeleton$1");
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = super.readClassDescriptor();
        if (this.autoReplacers.contains(objectStreamClass.getName())) {
            return ObjectStreamClass.lookup(Class.forName(objectStreamClass.getName()));
        }
        return objectStreamClass;
    }
}

