/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelConflictException;
import net.minecraft.world.level.LevelListener;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LightUpdate;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.Region;
import net.minecraft.world.level.TickNextTickData;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkCache;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.Dimension;
import net.minecraft.world.level.dimension.HellDimension;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.tile.LiquidTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import util.Mth;
import util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level
implements LevelSource {
    private static final int MAX_TICK_TILES_PER_TICK = 1000;
    public static final int MAX_LEVEL_SIZE = 32000000;
    public static final short DEPTH = 128;
    public static final short SEA_LEVEL = 63;
    public boolean instaTick = false;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    private List<LightUpdate> lightUpdates = new ArrayList<LightUpdate>();
    public List<Entity> entities = new ArrayList<Entity>();
    private List<Entity> entitiesToRemove = new ArrayList<Entity>();
    private TreeSet<TickNextTickData> tickNextTickList = new TreeSet();
    private Set<TickNextTickData> tickNextTickSet = new HashSet<TickNextTickData>();
    public List<TileEntity> tileEntityList = new ArrayList<TileEntity>();
    public List<Player> players = new ArrayList<Player>();
    public long time = 0L;
    private long cloudColor = 0xFFFFFFL;
    public int skyDarken = 0;
    protected int randValue = new Random().nextInt();
    protected int addend = 1013904223;
    public boolean noNeighborUpdate = false;
    private long sessionId = System.currentTimeMillis();
    protected int saveInterval = 40;
    public int difficulty;
    public Random random = new Random();
    public int xSpawn;
    public int ySpawn;
    public int zSpawn;
    public boolean isNew = false;
    public final Dimension dimension;
    protected List<LevelListener> listeners = new ArrayList<LevelListener>();
    private ChunkSource chunkSource;
    public File workDir;
    public File dir;
    public long seed = 0L;
    private CompoundTag loadedPlayerTag;
    public long sizeOnDisk = 0L;
    public final String name;
    public boolean isFindingSpawn;
    private ArrayList<AABB> boxes = new ArrayList();
    private int maxRecurse = 0;
    private boolean spawnEnemies = true;
    private boolean spawnFriendlies = true;
    static int maxLoop = 0;
    private Set<ChunkPos> chunksToPoll = new HashSet<ChunkPos>();
    private int delayUntilNextMoodSound = this.random.nextInt(12000);
    private List<Entity> es = new ArrayList<Entity>();
    public boolean isOnline = false;

    public static CompoundTag getDataTagFor(File file, String string) {
        File file2 = new File(file, "saves");
        File file3 = new File(file2, string);
        if (!file3.exists()) {
            return null;
        }
        File file4 = new File(file3, "level.dat");
        if (file4.exists()) {
            try {
                CompoundTag compoundTag = NbtIo.readCompressed(new FileInputStream(file4));
                CompoundTag compoundTag2 = compoundTag.getCompound("Data");
                return compoundTag2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void deleteLevel(File file, String string) {
        File file2 = new File(file, "saves");
        File file3 = new File(file2, string);
        if (!file3.exists()) {
            return;
        }
        Level.delete(file3.listFiles());
        file3.delete();
    }

    private static void delete(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                Level.delete(fileArray[i].listFiles());
            }
            fileArray[i].delete();
        }
    }

    @Override
    public BiomeSource getBiomeSource() {
        return this.dimension.biomeSource;
    }

    public static long getLevelSize(File file, String string) {
        File file2 = new File(file, "saves");
        File file3 = new File(file2, string);
        if (!file3.exists()) {
            return 0L;
        }
        return Level.calcSize(file3.listFiles());
    }

    private static long calcSize(File[] fileArray) {
        long l = 0L;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                l += Level.calcSize(fileArray[i].listFiles());
                continue;
            }
            l += fileArray[i].length();
        }
        return l;
    }

    public Level(File file, String string) {
        this(file, string, new Random().nextLong());
    }

    public Level(String string, Dimension dimension, long l) {
        this.name = string;
        this.seed = l;
        this.dimension = dimension;
        dimension.init(this);
        this.chunkSource = this.createChunkSource(this.dir);
        this.updateSkyBrightness();
    }

    public Level(Level level, Dimension dimension) {
        this.sessionId = level.sessionId;
        this.workDir = level.workDir;
        this.dir = level.dir;
        this.name = level.name;
        this.seed = level.seed;
        this.time = level.time;
        this.xSpawn = level.xSpawn;
        this.ySpawn = level.ySpawn;
        this.zSpawn = level.zSpawn;
        this.sizeOnDisk = level.sizeOnDisk;
        this.dimension = dimension;
        dimension.init(this);
        this.chunkSource = this.createChunkSource(this.dir);
        this.updateSkyBrightness();
    }

    public Level(File file, String string, long l) {
        this(file, string, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level(File file, String string, long l, Dimension dimension) {
        Object object;
        Object object2;
        this.workDir = file;
        this.name = string;
        file.mkdirs();
        this.dir = new File(file, string);
        this.dir.mkdirs();
        try {
            object2 = new File(this.dir, "session.lock");
            object = new DataOutputStream(new FileOutputStream((File)object2));
            try {
                ((DataOutputStream)object).writeLong(this.sessionId);
            }
            finally {
                ((FilterOutputStream)object).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
        object2 = new Dimension();
        object = new File(this.dir, "level.dat");
        boolean bl = this.isNew = !((File)object).exists();
        if (((File)object).exists()) {
            try {
                CompoundTag compoundTag = NbtIo.readCompressed(new FileInputStream((File)object));
                CompoundTag compoundTag2 = compoundTag.getCompound("Data");
                this.seed = compoundTag2.getLong("RandomSeed");
                this.xSpawn = compoundTag2.getInt("SpawnX");
                this.ySpawn = compoundTag2.getInt("SpawnY");
                this.zSpawn = compoundTag2.getInt("SpawnZ");
                this.time = compoundTag2.getLong("Time");
                this.sizeOnDisk = compoundTag2.getLong("SizeOnDisk");
                if (compoundTag2.contains("Player")) {
                    this.loadedPlayerTag = compoundTag2.getCompound("Player");
                    int n = this.loadedPlayerTag.getInt("Dimension");
                    if (n == -1) {
                        object2 = new HellDimension();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (dimension != null) {
            object2 = dimension;
        }
        boolean bl2 = false;
        if (this.seed == 0L) {
            this.seed = l;
            bl2 = true;
        }
        this.dimension = object2;
        this.dimension.init(this);
        this.chunkSource = this.createChunkSource(this.dir);
        if (bl2) {
            this.isFindingSpawn = true;
            this.xSpawn = 0;
            this.ySpawn = 64;
            this.zSpawn = 0;
            while (!this.dimension.isValidSpawn(this.xSpawn, this.zSpawn)) {
                this.xSpawn += this.random.nextInt(64) - this.random.nextInt(64);
                this.zSpawn += this.random.nextInt(64) - this.random.nextInt(64);
            }
            this.isFindingSpawn = false;
        }
        this.updateSkyBrightness();
    }

    protected ChunkSource createChunkSource(File file) {
        return new ChunkCache(this, this.dimension.createStorage(file), this.dimension.createRandomLevelSource());
    }

    public void validateSpawn() {
        if (this.ySpawn <= 0) {
            this.ySpawn = 64;
        }
        while (this.getTopTile(this.xSpawn, this.zSpawn) == 0) {
            this.xSpawn += this.random.nextInt(8) - this.random.nextInt(8);
            this.zSpawn += this.random.nextInt(8) - this.random.nextInt(8);
        }
    }

    public int getTopTile(int n, int n2) {
        int n3 = 63;
        while (!this.isEmptyTile(n, n3 + 1, n2)) {
            ++n3;
        }
        return this.getTile(n, n3, n2);
    }

    public void clearLoadedPlayerData() {
    }

    public void loadPlayer(Player player) {
        try {
            if (this.loadedPlayerTag != null) {
                player.load(this.loadedPlayerTag);
                this.loadedPlayerTag = null;
            }
            if (this.chunkSource instanceof ChunkCache) {
                ChunkCache chunkCache = (ChunkCache)this.chunkSource;
                int n = Mth.floor((int)player.x) >> 4;
                int n2 = Mth.floor((int)player.z) >> 4;
                chunkCache.centerOn(n, n2);
            }
            this.addEntity(player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(boolean bl, ProgressListener progressListener) {
        if (!this.chunkSource.shouldSave()) {
            return;
        }
        if (progressListener != null) {
            progressListener.progressStartNoAbort("Saving level");
        }
        this.saveLevelData();
        if (progressListener != null) {
            progressListener.progressStage("Saving chunks");
        }
        this.chunkSource.save(bl, progressListener);
    }

    private void saveLevelData() {
        CompoundTag compoundTag;
        this.checkSession();
        CompoundTag compoundTag2 = new CompoundTag();
        compoundTag2.putLong("RandomSeed", this.seed);
        compoundTag2.putInt("SpawnX", this.xSpawn);
        compoundTag2.putInt("SpawnY", this.ySpawn);
        compoundTag2.putInt("SpawnZ", this.zSpawn);
        compoundTag2.putLong("Time", this.time);
        compoundTag2.putLong("SizeOnDisk", this.sizeOnDisk);
        compoundTag2.putLong("LastPlayed", System.currentTimeMillis());
        Player player = null;
        if (this.players.size() > 0) {
            player = this.players.get(0);
        }
        if (player != null) {
            compoundTag = new CompoundTag();
            player.saveWithoutId(compoundTag);
            compoundTag2.putCompound("Player", compoundTag);
        }
        compoundTag = new CompoundTag();
        compoundTag.put("Data", compoundTag2);
        try {
            File file = new File(this.dir, "level.dat_new");
            File file2 = new File(this.dir, "level.dat_old");
            File file3 = new File(this.dir, "level.dat");
            NbtIo.writeCompressed(compoundTag, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean pauseSave(int n) {
        if (!this.chunkSource.shouldSave()) {
            return true;
        }
        if (n == 0) {
            this.saveLevelData();
        }
        return this.chunkSource.save(false, null);
    }

    @Override
    public int getTile(int n, int n2, int n3) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            return 0;
        }
        return this.getChunk(n >> 4, n3 >> 4).getTile(n & 0xF, n2, n3 & 0xF);
    }

    public boolean isEmptyTile(int n, int n2, int n3) {
        return this.getTile(n, n2, n3) == 0;
    }

    public boolean hasChunkAt(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= 128) {
            return false;
        }
        return this.hasChunk(n >> 4, n3 >> 4);
    }

    public boolean hasChunksAt(int n, int n2, int n3, int n4) {
        return this.hasChunksAt(n - n4, n2 - n4, n3 - n4, n + n4, n2 + n4, n3 + n4);
    }

    public boolean hasChunksAt(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0 || n2 >= 128) {
            return false;
        }
        n >>= 4;
        n2 >>= 4;
        n3 >>= 4;
        n4 >>= 4;
        n5 >>= 4;
        n6 >>= 4;
        for (int i = n; i <= n4; ++i) {
            for (int j = n3; j <= n6; ++j) {
                if (this.hasChunk(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasChunk(int n, int n2) {
        return this.chunkSource.hasChunk(n, n2);
    }

    public LevelChunk getChunkAt(int n, int n2) {
        return this.getChunk(n >> 4, n2 >> 4);
    }

    public LevelChunk getChunk(int n, int n2) {
        return this.chunkSource.getChunk(n, n2);
    }

    public boolean setTileAndDataNoUpdate(int n, int n2, int n3, int n4, int n5) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 128) {
            return false;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        return levelChunk.setTileAndData(n & 0xF, n2, n3 & 0xF, n4, n5);
    }

    public boolean setTileNoUpdate(int n, int n2, int n3, int n4) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 128) {
            return false;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        return levelChunk.setTile(n & 0xF, n2, n3 & 0xF, n4);
    }

    @Override
    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTile(n, n2, n3);
        if (n4 == 0) {
            return Material.air;
        }
        return Tile.tiles[n4].material;
    }

    @Override
    public int getData(int n, int n2, int n3) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            return 0;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        return levelChunk.getData(n &= 0xF, n2, n3 &= 0xF);
    }

    public void setData(int n, int n2, int n3, int n4) {
        if (this.setDataNoUpdate(n, n2, n3, n4)) {
            this.tileUpdated(n, n2, n3, this.getTile(n, n2, n3));
        }
    }

    public boolean setDataNoUpdate(int n, int n2, int n3, int n4) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 128) {
            return false;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        levelChunk.setData(n &= 0xF, n2, n3 &= 0xF, n4);
        return true;
    }

    public boolean setTile(int n, int n2, int n3, int n4) {
        if (this.setTileNoUpdate(n, n2, n3, n4)) {
            this.tileUpdated(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public boolean setTileAndData(int n, int n2, int n3, int n4, int n5) {
        if (this.setTileAndDataNoUpdate(n, n2, n3, n4, n5)) {
            this.tileUpdated(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public void sendTileUpdated(int n, int n2, int n3) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tileChanged(n, n2, n3);
        }
    }

    protected void tileUpdated(int n, int n2, int n3, int n4) {
        this.sendTileUpdated(n, n2, n3);
        this.updateNeighborsAt(n, n2, n3, n4);
    }

    public void lightColumnChanged(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            int n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        this.setTilesDirty(n, n3, n2, n, n4, n2);
    }

    public void setTileDirty(int n, int n2, int n3) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).setTilesDirty(n, n2, n3, n, n2, n3);
        }
    }

    public void setTilesDirty(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).setTilesDirty(n, n2, n3, n4, n5, n6);
        }
    }

    public void swap(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getTile(n, n2, n3);
        int n8 = this.getData(n, n2, n3);
        int n9 = this.getTile(n4, n5, n6);
        int n10 = this.getData(n4, n5, n6);
        this.setTileAndDataNoUpdate(n, n2, n3, n9, n10);
        this.setTileAndDataNoUpdate(n4, n5, n6, n7, n8);
        this.updateNeighborsAt(n, n2, n3, n9);
        this.updateNeighborsAt(n4, n5, n6, n7);
    }

    public void updateNeighborsAt(int n, int n2, int n3, int n4) {
        this.neighborChanged(n - 1, n2, n3, n4);
        this.neighborChanged(n + 1, n2, n3, n4);
        this.neighborChanged(n, n2 - 1, n3, n4);
        this.neighborChanged(n, n2 + 1, n3, n4);
        this.neighborChanged(n, n2, n3 - 1, n4);
        this.neighborChanged(n, n2, n3 + 1, n4);
    }

    private void neighborChanged(int n, int n2, int n3, int n4) {
        if (this.noNeighborUpdate || this.isOnline) {
            return;
        }
        Tile tile = Tile.tiles[this.getTile(n, n2, n3)];
        if (tile != null) {
            tile.neighborChanged(this, n, n2, n3, n4);
        }
    }

    public boolean canSeeSky(int n, int n2, int n3) {
        return this.getChunk(n >> 4, n3 >> 4).isSkyLit(n & 0xF, n2, n3 & 0xF);
    }

    public int getRawBrightness(int n, int n2, int n3) {
        return this.getRawBrightness(n, n2, n3, true);
    }

    public int getRawBrightness(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return 15;
        }
        if (bl && ((n4 = this.getTile(n, n2, n3)) == Tile.stoneSlabHalf.id || n4 == Tile.farmland.id)) {
            int n5 = this.getRawBrightness(n, n2 + 1, n3, false);
            int n6 = this.getRawBrightness(n + 1, n2, n3, false);
            int n7 = this.getRawBrightness(n - 1, n2, n3, false);
            int n8 = this.getRawBrightness(n, n2, n3 + 1, false);
            int n9 = this.getRawBrightness(n, n2, n3 - 1, false);
            if (n6 > n5) {
                n5 = n6;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n9 > n5) {
                n5 = n9;
            }
            return n5;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            n4 = 15 - this.skyDarken;
            if (n4 < 0) {
                n4 = 0;
            }
            return n4;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        return levelChunk.getRawBrightness(n &= 0xF, n2, n3 &= 0xF, this.skyDarken);
    }

    public boolean isSkyLit(int n, int n2, int n3) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 128) {
            return true;
        }
        if (!this.hasChunk(n >> 4, n3 >> 4)) {
            return false;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        return levelChunk.isSkyLit(n &= 0xF, n2, n3 &= 0xF);
    }

    public int getHeightmap(int n, int n2) {
        if (n < -32000000 || n2 < -32000000 || n >= 32000000 || n2 > 32000000) {
            return 0;
        }
        if (!this.hasChunk(n >> 4, n2 >> 4)) {
            return 0;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n2 >> 4);
        return levelChunk.getHeightmap(n & 0xF, n2 & 0xF);
    }

    public void updateLightIfOtherThan(LightLayer lightLayer, int n, int n2, int n3, int n4) {
        int n5;
        if (this.dimension.hasCeiling && lightLayer == LightLayer.Sky) {
            return;
        }
        if (!this.hasChunkAt(n, n2, n3)) {
            return;
        }
        if (lightLayer == LightLayer.Sky) {
            if (this.isSkyLit(n, n2, n3)) {
                n4 = 15;
            }
        } else if (lightLayer == LightLayer.Block && Tile.lightEmission[n5 = this.getTile(n, n2, n3)] > n4) {
            n4 = Tile.lightEmission[n5];
        }
        if (this.getBrightness(lightLayer, n, n2, n3) != n4) {
            this.updateLight(lightLayer, n, n2, n3, n, n2, n3);
        }
    }

    public int getBrightness(LightLayer lightLayer, int n, int n2, int n3) {
        if (n2 < 0 || n2 >= 128 || n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return lightLayer.surrounding;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        if (!this.hasChunk(n4, n5)) {
            return 0;
        }
        LevelChunk levelChunk = this.getChunk(n4, n5);
        return levelChunk.getBrightness(lightLayer, n & 0xF, n2, n3 & 0xF);
    }

    public void setBrightness(LightLayer lightLayer, int n, int n2, int n3, int n4) {
        if (n < -32000000 || n3 < -32000000 || n >= 32000000 || n3 > 32000000) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        if (n2 >= 128) {
            return;
        }
        if (!this.hasChunk(n >> 4, n3 >> 4)) {
            return;
        }
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        levelChunk.setBrightness(lightLayer, n & 0xF, n2, n3 & 0xF, n4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tileChanged(n, n2, n3);
        }
    }

    @Override
    public float getBrightness(int n, int n2, int n3) {
        return this.dimension.brightnessRamp[this.getRawBrightness(n, n2, n3)];
    }

    public boolean isDay() {
        return this.skyDarken < 4;
    }

    public HitResult clip(Vec3 vec3, Vec3 vec32) {
        return this.clip(vec3, vec32, false);
    }

    public HitResult clip(Vec3 vec3, Vec3 vec32, boolean bl) {
        if (Double.isNaN(vec3.x) || Double.isNaN(vec3.y) || Double.isNaN(vec3.z)) {
            return null;
        }
        if (Double.isNaN(vec32.x) || Double.isNaN(vec32.y) || Double.isNaN(vec32.z)) {
            return null;
        }
        int n = Mth.floor(vec32.x);
        int n2 = Mth.floor(vec32.y);
        int n3 = Mth.floor(vec32.z);
        int n4 = Mth.floor(vec3.x);
        int n5 = Mth.floor(vec3.y);
        int n6 = Mth.floor(vec3.z);
        int n7 = 200;
        while (n7-- >= 0) {
            HitResult hitResult;
            if (Double.isNaN(vec3.x) || Double.isNaN(vec3.y) || Double.isNaN(vec3.z)) {
                return null;
            }
            if (n4 == n && n5 == n2 && n6 == n3) {
                return null;
            }
            double d = 999.0;
            double d2 = 999.0;
            double d3 = 999.0;
            if (n > n4) {
                d = (double)n4 + 1.0;
            }
            if (n < n4) {
                d = (double)n4 + 0.0;
            }
            if (n2 > n5) {
                d2 = (double)n5 + 1.0;
            }
            if (n2 < n5) {
                d2 = (double)n5 + 0.0;
            }
            if (n3 > n6) {
                d3 = (double)n6 + 1.0;
            }
            if (n3 < n6) {
                d3 = (double)n6 + 0.0;
            }
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = 999.0;
            double d7 = vec32.x - vec3.x;
            double d8 = vec32.y - vec3.y;
            double d9 = vec32.z - vec3.z;
            if (d != 999.0) {
                d4 = (d - vec3.x) / d7;
            }
            if (d2 != 999.0) {
                d5 = (d2 - vec3.y) / d8;
            }
            if (d3 != 999.0) {
                d6 = (d3 - vec3.z) / d9;
            }
            int n8 = 0;
            if (d4 < d5 && d4 < d6) {
                n8 = n > n4 ? 4 : 5;
                vec3.x = d;
                vec3.y += d8 * d4;
                vec3.z += d9 * d4;
            } else if (d5 < d6) {
                n8 = n2 > n5 ? 0 : 1;
                vec3.x += d7 * d5;
                vec3.y = d2;
                vec3.z += d9 * d5;
            } else {
                n8 = n3 > n6 ? 2 : 3;
                vec3.x += d7 * d6;
                vec3.y += d8 * d6;
                vec3.z = d3;
            }
            Vec3 vec33 = Vec3.newTemp(vec3.x, vec3.y, vec3.z);
            vec33.x = Mth.floor(vec3.x);
            n4 = (int)vec33.x;
            if (n8 == 5) {
                --n4;
                vec33.x += 1.0;
            }
            vec33.y = Mth.floor(vec3.y);
            n5 = (int)vec33.y;
            if (n8 == 1) {
                --n5;
                vec33.y += 1.0;
            }
            vec33.z = Mth.floor(vec3.z);
            n6 = (int)vec33.z;
            if (n8 == 3) {
                --n6;
                vec33.z += 1.0;
            }
            int n9 = this.getTile(n4, n5, n6);
            int n10 = this.getData(n4, n5, n6);
            Tile tile = Tile.tiles[n9];
            if (n9 <= 0 || !tile.mayPick(n10, bl) || (hitResult = tile.clip(this, n4, n5, n6, vec3, vec32)) == null) continue;
            return hitResult;
        }
        return null;
    }

    public void playSound(Entity entity, String string, float f, float f2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).playSound(string, entity.x, entity.y - (double)entity.heightOffset, entity.z, f, f2);
        }
    }

    public void playSound(double d, double d2, double d3, String string, float f, float f2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).playSound(string, d, d2, d3, f, f2);
        }
    }

    public void playStreamingMusic(String string, int n, int n2, int n3) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).playStreamingMusic(string, n, n2, n3);
        }
    }

    public void playMusic(double d, double d2, double d3, String string, float f) {
    }

    public void addParticle(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).addParticle(string, d, d2, d3, d4, d5, d6);
        }
    }

    public boolean addEntity(Entity entity) {
        int n = Mth.floor(entity.x / 16.0);
        int n2 = Mth.floor(entity.z / 16.0);
        boolean bl = false;
        if (entity instanceof Player) {
            bl = true;
        }
        if (bl || this.hasChunk(n, n2)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.players.add(player);
                System.out.println("Player count: " + this.players.size());
            }
            this.getChunk(n, n2).addEntity(entity);
            this.entities.add(entity);
            this.entityAdded(entity);
            return true;
        }
        return false;
    }

    protected void entityAdded(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityAdded(entity);
        }
    }

    protected void entityRemoved(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityRemoved(entity);
        }
    }

    public void removeEntity(Entity entity) {
        if (entity.rider != null) {
            entity.rider.ride(null);
        }
        if (entity.riding != null) {
            entity.ride(null);
        }
        entity.remove();
        if (entity instanceof Player) {
            this.players.remove((Player)entity);
        }
    }

    public void removeEntityImmediately(Entity entity) {
        entity.remove();
        if (entity instanceof Player) {
            this.players.remove((Player)entity);
        }
        int n = entity.xChunk;
        int n2 = entity.zChunk;
        if (entity.inChunk && this.hasChunk(n, n2)) {
            this.getChunk(n, n2).removeEntity(entity);
        }
        this.entities.remove(entity);
        this.entityRemoved(entity);
    }

    public void addListener(LevelListener levelListener) {
        this.listeners.add(levelListener);
    }

    public void removeListener(LevelListener levelListener) {
        this.listeners.remove(levelListener);
    }

    public List<AABB> getCubes(Entity entity, AABB aABB) {
        this.boxes.clear();
        int n = Mth.floor(aABB.x0);
        int n2 = Mth.floor(aABB.x1 + 1.0);
        int n3 = Mth.floor(aABB.y0);
        int n4 = Mth.floor(aABB.y1 + 1.0);
        int n5 = Mth.floor(aABB.z0);
        int n6 = Mth.floor(aABB.z1 + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.hasChunkAt(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Tile tile = Tile.tiles[this.getTile(i, k, j)];
                    if (tile == null) continue;
                    tile.addAABBs(this, i, k, j, aABB, this.boxes);
                }
            }
        }
        double d = 0.25;
        List<Entity> list = this.getEntities(entity, aABB.grow(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            AABB aABB2 = list.get(i).getCollideBox();
            if (aABB2 != null && aABB2.intersects(aABB)) {
                this.boxes.add(aABB2);
            }
            if ((aABB2 = entity.getCollideAgainstBox(list.get(i))) == null || !aABB2.intersects(aABB)) continue;
            this.boxes.add(aABB2);
        }
        return this.boxes;
    }

    public int getSkyDarken(float f) {
        float f2 = this.getTimeOfDay(f);
        float f3 = 1.0f - (Mth.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return (int)(f3 * 11.0f);
    }

    public Vec3 getSkyColor(Entity entity, float f) {
        float f2 = this.getTimeOfDay(f);
        float f3 = Mth.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        int n = Mth.floor(entity.x);
        int n2 = Mth.floor(entity.z);
        float f4 = (float)this.getBiomeSource().getTemperature(n, n2);
        int n3 = this.getBiomeSource().getBiome(n, n2).getSkyColor(f4);
        float f5 = (float)(n3 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(n3 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(n3 & 0xFF) / 255.0f;
        return Vec3.newTemp(f5 *= f3, f6 *= f3, f7 *= f3);
    }

    public float getTimeOfDay(float f) {
        return this.dimension.getTimeOfDay(this.time, f);
    }

    public float getSunAngle(float f) {
        float f2 = this.getTimeOfDay(f);
        return f2 * (float)Math.PI * 2.0f;
    }

    public Vec3 getCloudColor(float f) {
        float f2 = this.getTimeOfDay(f);
        float f3 = Mth.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        float f4 = (float)(this.cloudColor >> 16 & 0xFFL) / 255.0f;
        float f5 = (float)(this.cloudColor >> 8 & 0xFFL) / 255.0f;
        float f6 = (float)(this.cloudColor & 0xFFL) / 255.0f;
        return Vec3.newTemp(f4 *= f3 * 0.9f + 0.1f, f5 *= f3 * 0.9f + 0.1f, f6 *= f3 * 0.85f + 0.15f);
    }

    public Vec3 getFogColor(float f) {
        float f2 = this.getTimeOfDay(f);
        return this.dimension.getFogColor(f2, f);
    }

    public int getTopSolidBlock(int n, int n2) {
        int n3;
        LevelChunk levelChunk = this.getChunkAt(n, n2);
        for (n3 = 127; this.getMaterial(n, n3, n2).blocksMotion() && n3 > 0; --n3) {
        }
        n &= 0xF;
        n2 &= 0xF;
        while (n3 > 0) {
            int n4 = levelChunk.getTile(n, n3, n2);
            if (n4 == 0 || !Tile.tiles[n4].material.blocksMotion() && !Tile.tiles[n4].material.isLiquid()) {
                --n3;
                continue;
            }
            return n3 + 1;
        }
        return -1;
    }

    public int getLightDepth(int n, int n2) {
        return this.getChunkAt(n, n2).getHeightmap(n & 0xF, n2 & 0xF);
    }

    public float getStarBrightness(float f) {
        float f2 = this.getTimeOfDay(f);
        float f3 = 1.0f - (Mth.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.75f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return f3 * f3 * 0.5f;
    }

    public void addToTickNextTick(int n, int n2, int n3, int n4) {
        TickNextTickData tickNextTickData = new TickNextTickData(n, n2, n3, n4);
        int n5 = 8;
        if (this.instaTick) {
            int n6;
            if (this.hasChunksAt(tickNextTickData.x - n5, tickNextTickData.y - n5, tickNextTickData.z - n5, tickNextTickData.x + n5, tickNextTickData.y + n5, tickNextTickData.z + n5) && (n6 = this.getTile(tickNextTickData.x, tickNextTickData.y, tickNextTickData.z)) == tickNextTickData.tileId && n6 > 0) {
                Tile.tiles[n6].tick(this, tickNextTickData.x, tickNextTickData.y, tickNextTickData.z, this.random);
            }
            return;
        }
        if (this.hasChunksAt(n - n5, n2 - n5, n3 - n5, n + n5, n2 + n5, n3 + n5)) {
            if (n4 > 0) {
                tickNextTickData.delay((long)Tile.tiles[n4].getTickDelay() + this.time);
            }
            if (!this.tickNextTickSet.contains(tickNextTickData)) {
                this.tickNextTickSet.add(tickNextTickData);
                this.tickNextTickList.add(tickNextTickData);
            }
        }
    }

    public void tickEntities() {
        int n;
        int n2;
        Object object;
        int n3;
        this.entities.removeAll(this.entitiesToRemove);
        for (n3 = 0; n3 < this.entitiesToRemove.size(); ++n3) {
            object = this.entitiesToRemove.get(n3);
            n2 = ((Entity)object).xChunk;
            n = ((Entity)object).zChunk;
            if (!((Entity)object).inChunk || !this.hasChunk(n2, n)) continue;
            this.getChunk(n2, n).removeEntity((Entity)object);
        }
        for (n3 = 0; n3 < this.entitiesToRemove.size(); ++n3) {
            this.entityRemoved(this.entitiesToRemove.get(n3));
        }
        this.entitiesToRemove.clear();
        for (n3 = 0; n3 < this.entities.size(); ++n3) {
            object = this.entities.get(n3);
            if (((Entity)object).riding != null) {
                if (!((Entity)object).riding.removed && ((Entity)object).riding.rider == object) continue;
                ((Entity)object).riding.rider = null;
                ((Entity)object).riding = null;
            }
            if (!((Entity)object).removed) {
                this.tick((Entity)object);
            }
            if (!((Entity)object).removed) continue;
            n2 = ((Entity)object).xChunk;
            n = ((Entity)object).zChunk;
            if (((Entity)object).inChunk && this.hasChunk(n2, n)) {
                this.getChunk(n2, n).removeEntity((Entity)object);
            }
            this.entities.remove(n3--);
            this.entityRemoved((Entity)object);
        }
        for (n3 = 0; n3 < this.tileEntityList.size(); ++n3) {
            object = this.tileEntityList.get(n3);
            ((TileEntity)object).tick();
        }
    }

    public void tick(Entity entity) {
        this.tick(entity, true);
    }

    public void tick(Entity entity, boolean bl) {
        int n = Mth.floor(entity.x);
        int n2 = Mth.floor(entity.z);
        int n3 = 32;
        if (bl && !this.hasChunksAt(n - n3, 0, n2 - n3, n + n3, 128, n2 + n3)) {
            return;
        }
        entity.xOld = entity.x;
        entity.yOld = entity.y;
        entity.zOld = entity.z;
        entity.yRotO = entity.yRot;
        entity.xRotO = entity.xRot;
        if (bl && entity.inChunk) {
            if (entity.riding != null) {
                entity.rideTick();
            } else {
                entity.tick();
            }
        }
        if (Double.isNaN(entity.x) || Double.isInfinite(entity.x)) {
            entity.x = entity.xOld;
        }
        if (Double.isNaN(entity.y) || Double.isInfinite(entity.y)) {
            entity.y = entity.yOld;
        }
        if (Double.isNaN(entity.z) || Double.isInfinite(entity.z)) {
            entity.z = entity.zOld;
        }
        if (Double.isNaN(entity.xRot) || Double.isInfinite(entity.xRot)) {
            entity.xRot = entity.xRotO;
        }
        if (Double.isNaN(entity.yRot) || Double.isInfinite(entity.yRot)) {
            entity.yRot = entity.yRotO;
        }
        int n4 = Mth.floor(entity.x / 16.0);
        int n5 = Mth.floor(entity.y / 16.0);
        int n6 = Mth.floor(entity.z / 16.0);
        if (!entity.inChunk || entity.xChunk != n4 || entity.yChunk != n5 || entity.zChunk != n6) {
            if (entity.inChunk && this.hasChunk(entity.xChunk, entity.zChunk)) {
                this.getChunk(entity.xChunk, entity.zChunk).removeEntity(entity, entity.yChunk);
            }
            if (this.hasChunk(n4, n6)) {
                entity.inChunk = true;
                this.getChunk(n4, n6).addEntity(entity);
            } else {
                entity.inChunk = false;
            }
        }
        if (bl && entity.inChunk && entity.rider != null) {
            if (entity.rider.removed || entity.rider.riding != entity) {
                entity.rider.riding = null;
                entity.rider = null;
            } else {
                this.tick(entity.rider);
            }
        }
    }

    public boolean isUnobstructed(AABB aABB) {
        List<Entity> list = this.getEntities(null, aABB);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (entity.removed || !entity.blocksBuilding) continue;
            return false;
        }
        return true;
    }

    public boolean containsAnyLiquid(AABB aABB) {
        int n = Mth.floor(aABB.x0);
        int n2 = Mth.floor(aABB.x1 + 1.0);
        int n3 = Mth.floor(aABB.y0);
        int n4 = Mth.floor(aABB.y1 + 1.0);
        int n5 = Mth.floor(aABB.z0);
        int n6 = Mth.floor(aABB.z1 + 1.0);
        if (aABB.x0 < 0.0) {
            --n;
        }
        if (aABB.y0 < 0.0) {
            --n3;
        }
        if (aABB.z0 < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Tile tile = Tile.tiles[this.getTile(i, j, k)];
                    if (tile == null || !tile.material.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsFireTile(AABB aABB) {
        int n;
        int n2 = Mth.floor(aABB.x0);
        int n3 = Mth.floor(aABB.x1 + 1.0);
        int n4 = Mth.floor(aABB.y0);
        int n5 = Mth.floor(aABB.y1 + 1.0);
        int n6 = Mth.floor(aABB.z0);
        if (this.hasChunksAt(n2, n4, n6, n3, n5, n = Mth.floor(aABB.z1 + 1.0))) {
            for (int i = n2; i < n3; ++i) {
                for (int j = n4; j < n5; ++j) {
                    for (int k = n6; k < n; ++k) {
                        int n7 = this.getTile(i, j, k);
                        if (n7 != Tile.fire.id && n7 != Tile.lava.id && n7 != Tile.calmLava.id) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean checkAndHandleWater(AABB aABB, Material material, Entity entity) {
        int n;
        int n2 = Mth.floor(aABB.x0);
        int n3 = Mth.floor(aABB.x1 + 1.0);
        int n4 = Mth.floor(aABB.y0);
        int n5 = Mth.floor(aABB.y1 + 1.0);
        int n6 = Mth.floor(aABB.z0);
        if (!this.hasChunksAt(n2, n4, n6, n3, n5, n = Mth.floor(aABB.z1 + 1.0))) {
            return false;
        }
        boolean bl = false;
        Vec3 vec3 = Vec3.newTemp(0.0, 0.0, 0.0);
        for (int i = n2; i < n3; ++i) {
            for (int j = n4; j < n5; ++j) {
                for (int k = n6; k < n; ++k) {
                    double d;
                    Tile tile = Tile.tiles[this.getTile(i, j, k)];
                    if (tile == null || tile.material != material || !((double)n5 >= (d = (double)((float)(j + 1) - LiquidTile.getHeight(this.getData(i, j, k)))))) continue;
                    bl = true;
                    tile.handleEntityInside(this, i, j, k, entity, vec3);
                }
            }
        }
        if (vec3.length() > 0.0) {
            vec3 = vec3.normalize();
            double d = 0.004;
            entity.xd += vec3.x * d;
            entity.yd += vec3.y * d;
            entity.zd += vec3.z * d;
        }
        return bl;
    }

    public boolean containsMaterial(AABB aABB, Material material) {
        int n = Mth.floor(aABB.x0);
        int n2 = Mth.floor(aABB.x1 + 1.0);
        int n3 = Mth.floor(aABB.y0);
        int n4 = Mth.floor(aABB.y1 + 1.0);
        int n5 = Mth.floor(aABB.z0);
        int n6 = Mth.floor(aABB.z1 + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Tile tile = Tile.tiles[this.getTile(i, j, k)];
                    if (tile == null || tile.material != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsLiquid(AABB aABB, Material material) {
        int n = Mth.floor(aABB.x0);
        int n2 = Mth.floor(aABB.x1 + 1.0);
        int n3 = Mth.floor(aABB.y0);
        int n4 = Mth.floor(aABB.y1 + 1.0);
        int n5 = Mth.floor(aABB.z0);
        int n6 = Mth.floor(aABB.z1 + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Tile tile = Tile.tiles[this.getTile(i, j, k)];
                    if (tile == null || tile.material != material) continue;
                    int n7 = this.getData(i, j, k);
                    double d = j + 1;
                    if (n7 < 8) {
                        d = (double)(j + 1) - (double)n7 / 8.0;
                    }
                    if (!(d >= aABB.y0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion explode(Entity entity, double d, double d2, double d3, float f) {
        return this.explode(entity, d, d2, d3, f, false);
    }

    public Explosion explode(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.fire = bl;
        explosion.explode();
        explosion.addParticles();
        return explosion;
    }

    public float getSeenPercent(Vec3 vec3, AABB aABB) {
        double d = 1.0 / ((aABB.x1 - aABB.x0) * 2.0 + 1.0);
        double d2 = 1.0 / ((aABB.y1 - aABB.y0) * 2.0 + 1.0);
        double d3 = 1.0 / ((aABB.z1 - aABB.z0) * 2.0 + 1.0);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    double d4 = aABB.x0 + (aABB.x1 - aABB.x0) * (double)f;
                    double d5 = aABB.y0 + (aABB.y1 - aABB.y0) * (double)f2;
                    double d6 = aABB.z0 + (aABB.z1 - aABB.z0) * (double)f3;
                    if (this.clip(Vec3.newTemp(d4, d5, d6), vec3) == null) {
                        ++n;
                    }
                    ++n2;
                    f3 = (float)((double)f3 + d3);
                }
                f2 = (float)((double)f2 + d2);
            }
            f = (float)((double)f + d);
        }
        return (float)n / (float)n2;
    }

    public void extinguishFire(int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            --n2;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (this.getTile(n, n2, n3) == Tile.fire.id) {
            this.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "random.fizz", 0.5f, 2.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.8f);
            this.setTile(n, n2, n3, 0);
        }
    }

    public Entity findSubclassOf(Class<? extends Entity> clazz) {
        return null;
    }

    public String gatherStats() {
        return "All: " + this.entities.size();
    }

    public String gatherChunkSourceStats() {
        return this.chunkSource.gatherStats();
    }

    @Override
    public TileEntity getTileEntity(int n, int n2, int n3) {
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        if (levelChunk != null) {
            return levelChunk.getTileEntity(n & 0xF, n2, n3 & 0xF);
        }
        return null;
    }

    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        if (levelChunk != null) {
            levelChunk.setTileEntity(n & 0xF, n2, n3 & 0xF, tileEntity);
        }
    }

    public void removeTileEntity(int n, int n2, int n3) {
        LevelChunk levelChunk = this.getChunk(n >> 4, n3 >> 4);
        if (levelChunk != null) {
            levelChunk.removeTileEntity(n & 0xF, n2, n3 & 0xF);
        }
    }

    @Override
    public boolean isSolidTile(int n, int n2, int n3) {
        Tile tile = Tile.tiles[this.getTile(n, n2, n3)];
        if (tile == null) {
            return false;
        }
        return tile.isSolidRender();
    }

    public void forceSave(ProgressListener progressListener) {
        this.save(true, progressListener);
    }

    public int getLightsToUpdate() {
        return this.lightUpdates.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLights() {
        if (this.maxRecurse >= 50) {
            return false;
        }
        ++this.maxRecurse;
        try {
            int n = 500;
            while (this.lightUpdates.size() > 0) {
                if (--n <= 0) {
                    boolean bl = true;
                    return bl;
                }
                this.lightUpdates.remove(this.lightUpdates.size() - 1).update(this);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            --this.maxRecurse;
        }
    }

    public void updateLight(LightLayer lightLayer, int n, int n2, int n3, int n4, int n5, int n6) {
        this.updateLight(lightLayer, n, n2, n3, n4, n5, n6, true);
    }

    public void updateLight(LightLayer lightLayer, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        if (this.dimension.hasCeiling && lightLayer == LightLayer.Sky) {
            return;
        }
        if (++maxLoop == 50) {
            --maxLoop;
            return;
        }
        int n8 = (n4 + n) / 2;
        int n9 = (n6 + n3) / 2;
        if (!this.hasChunkAt(n8, 64, n9)) {
            --maxLoop;
            return;
        }
        if (this.getChunkAt(n8, n9).isEmpty()) {
            return;
        }
        int n10 = this.lightUpdates.size();
        if (bl) {
            n7 = 5;
            if (n7 > n10) {
                n7 = n10;
            }
            for (int i = 0; i < n7; ++i) {
                LightUpdate lightUpdate = this.lightUpdates.get(this.lightUpdates.size() - i - 1);
                if (lightUpdate.layer != lightLayer || !lightUpdate.expandToContain(n, n2, n3, n4, n5, n6)) continue;
                --maxLoop;
                return;
            }
        }
        this.lightUpdates.add(new LightUpdate(lightLayer, n, n2, n3, n4, n5, n6));
        n7 = 1000000;
        if (this.lightUpdates.size() > 1000000) {
            System.out.println("More than " + n7 + " updates, aborting lighting updates");
            this.lightUpdates.clear();
        }
        --maxLoop;
    }

    public void updateSkyBrightness() {
        int n = this.getSkyDarken(1.0f);
        if (n != this.skyDarken) {
            this.skyDarken = n;
        }
    }

    public void setSpawnSettings(boolean bl, boolean bl2) {
        this.spawnEnemies = bl;
        this.spawnFriendlies = bl2;
    }

    public void tick() {
        MobSpawner.tick(this, this.spawnEnemies, this.spawnFriendlies);
        this.chunkSource.tick();
        int n = this.getSkyDarken(1.0f);
        if (n != this.skyDarken) {
            this.skyDarken = n;
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).skyColorChanged();
            }
        }
        ++this.time;
        if (this.time % (long)this.saveInterval == 0L) {
            this.save(false, null);
        }
        this.tickPendingTicks(false);
        this.tickTiles();
    }

    protected void tickTiles() {
        int n;
        int n2;
        int n3;
        int n4;
        this.chunksToPoll.clear();
        for (int i = 0; i < this.players.size(); ++i) {
            Player object = this.players.get(i);
            n4 = Mth.floor(object.x / 16.0);
            n3 = Mth.floor(object.z / 16.0);
            int n5 = 9;
            for (n2 = -n5; n2 <= n5; ++n2) {
                for (n = -n5; n <= n5; ++n) {
                    this.chunksToPoll.add(new ChunkPos(n2 + n4, n + n3));
                }
            }
        }
        if (this.delayUntilNextMoodSound > 0) {
            --this.delayUntilNextMoodSound;
        }
        for (ChunkPos chunkPos : this.chunksToPoll) {
            int n6;
            int n7;
            int n8;
            n4 = chunkPos.x * 16;
            n3 = chunkPos.z * 16;
            LevelChunk levelChunk = this.getChunk(chunkPos.x, chunkPos.z);
            if (this.delayUntilNextMoodSound == 0) {
                Player player;
                this.randValue = this.randValue * 3 + this.addend;
                n2 = this.randValue >> 2;
                n = n2 & 0xF;
                n8 = n2 >> 8 & 0xF;
                n7 = n2 >> 16 & 0x7F;
                n6 = levelChunk.getTile(n, n7, n8);
                if (n6 == 0 && this.getRawBrightness(n += n4, n7, n8 += n3) <= this.random.nextInt(8) && this.getBrightness(LightLayer.Sky, n, n7, n8) <= 0 && (player = this.getNearestPlayer((double)n + 0.5, (double)n7 + 0.5, (double)n8 + 0.5, 8.0)) != null && player.distanceToSqr((double)n + 0.5, (double)n7 + 0.5, (double)n8 + 0.5) > 4.0) {
                    this.playSound((double)n + 0.5, (double)n7 + 0.5, (double)n8 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.random.nextFloat() * 0.2f);
                    this.delayUntilNextMoodSound = this.random.nextInt(12000) + 6000;
                }
            }
            for (n2 = 0; n2 < 80; ++n2) {
                this.randValue = this.randValue * 3 + this.addend;
                n = this.randValue >> 2;
                n8 = n & 0xF;
                n7 = n >> 8 & 0xF;
                n6 = n >> 16 & 0x7F;
                byte by = levelChunk.blocks[n8 << 11 | n7 << 7 | n6];
                if (!Tile.shouldTick[by]) continue;
                Tile.tiles[by].tick(this, n8 + n4, n6, n7 + n3, this.random);
            }
        }
    }

    public boolean tickPendingTicks(boolean bl) {
        int n = this.tickNextTickList.size();
        if (n != this.tickNextTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 1000) {
            n = 1000;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            TickNextTickData tickNextTickData = this.tickNextTickList.first();
            if (!bl && tickNextTickData.delay > this.time) break;
            this.tickNextTickList.remove(tickNextTickData);
            this.tickNextTickSet.remove(tickNextTickData);
            int n3 = 8;
            if (!this.hasChunksAt(tickNextTickData.x - n3, tickNextTickData.y - n3, tickNextTickData.z - n3, tickNextTickData.x + n3, tickNextTickData.y + n3, tickNextTickData.z + n3) || (n2 = this.getTile(tickNextTickData.x, tickNextTickData.y, tickNextTickData.z)) != tickNextTickData.tileId || n2 <= 0) continue;
            Tile.tiles[n2].tick(this, tickNextTickData.x, tickNextTickData.y, tickNextTickData.z, this.random);
        }
        return this.tickNextTickList.size() != 0;
    }

    public void animateTick(int n, int n2, int n3) {
        int n4 = 16;
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int n5;
            int n6;
            int n7 = n + this.random.nextInt(n4) - this.random.nextInt(n4);
            int n8 = this.getTile(n7, n6 = n2 + this.random.nextInt(n4) - this.random.nextInt(n4), n5 = n3 + this.random.nextInt(n4) - this.random.nextInt(n4));
            if (n8 <= 0) continue;
            Tile.tiles[n8].animateTick(this, n7, n6, n5, random);
        }
    }

    public List<Entity> getEntities(Entity entity, AABB aABB) {
        this.es.clear();
        int n = Mth.floor((aABB.x0 - 2.0) / 16.0);
        int n2 = Mth.floor((aABB.x1 + 2.0) / 16.0);
        int n3 = Mth.floor((aABB.z0 - 2.0) / 16.0);
        int n4 = Mth.floor((aABB.z1 + 2.0) / 16.0);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.hasChunk(i, j)) continue;
                this.getChunk(i, j).getEntities(entity, aABB, this.es);
            }
        }
        return this.es;
    }

    public List<Entity> getEntitiesOfClass(Class<? extends Entity> clazz, AABB aABB) {
        int n = Mth.floor((aABB.x0 - 2.0) / 16.0);
        int n2 = Mth.floor((aABB.x1 + 2.0) / 16.0);
        int n3 = Mth.floor((aABB.z0 - 2.0) / 16.0);
        int n4 = Mth.floor((aABB.z1 + 2.0) / 16.0);
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.hasChunk(i, j)) continue;
                this.getChunk(i, j).getEntitiesOfClass(clazz, aABB, arrayList);
            }
        }
        return arrayList;
    }

    public List<Entity> getAllEntities() {
        return this.entities;
    }

    public void tileEntityChanged(int n, int n2, int n3, TileEntity tileEntity) {
        if (this.hasChunkAt(n, n2, n3)) {
            this.getChunkAt(n, n3).markUnsaved();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tileEntityChanged(n, n2, n3, tileEntity);
        }
    }

    public int countInstanceOf(Class<?> clazz) {
        int n = 0;
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity entity = this.entities.get(i);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++n;
        }
        return n;
    }

    public void addEntities(List<Entity> list) {
        this.entities.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.entityAdded(list.get(i));
        }
    }

    public void removeEntities(List<Entity> list) {
        this.entitiesToRemove.addAll(list);
    }

    public void prepare() {
        while (this.chunkSource.tick()) {
        }
    }

    public boolean mayPlace(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.getTile(n2, n3, n4);
        Tile tile = Tile.tiles[n5];
        Tile tile2 = Tile.tiles[n];
        AABB aABB = tile2.getAABB(this, n2, n3, n4);
        if (bl) {
            aABB = null;
        }
        if (aABB != null && !this.isUnobstructed(aABB)) {
            return false;
        }
        if (tile == Tile.water || tile == Tile.calmWater || tile == Tile.lava || tile == Tile.calmLava || tile == Tile.fire || tile == Tile.topSnow) {
            return true;
        }
        return n > 0 && tile == null && tile2.mayPlace(this, n2, n3, n4);
    }

    public int getSeaLevel() {
        return 63;
    }

    public Path findPath(Entity entity, Entity entity2, float f) {
        int n = Mth.floor(entity.x);
        int n2 = Mth.floor(entity.y);
        int n3 = Mth.floor(entity.z);
        int n4 = (int)(f + 16.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        Region region = new Region(this, n5, n6, n7, n8, n9, n10);
        return new PathFinder(region).findPath(entity, entity2, f);
    }

    public Path findPath(Entity entity, int n, int n2, int n3, float f) {
        int n4 = Mth.floor(entity.x);
        int n5 = Mth.floor(entity.y);
        int n6 = Mth.floor(entity.z);
        int n7 = (int)(f + 8.0f);
        int n8 = n4 - n7;
        int n9 = n5 - n7;
        int n10 = n6 - n7;
        int n11 = n4 + n7;
        int n12 = n5 + n7;
        int n13 = n6 + n7;
        Region region = new Region(this, n8, n9, n10, n11, n12, n13);
        return new PathFinder(region).findPath(entity, n, n2, n3, f);
    }

    public boolean getDirectSignal(int n, int n2, int n3, int n4) {
        int n5 = this.getTile(n, n2, n3);
        if (n5 == 0) {
            return false;
        }
        return Tile.tiles[n5].getDirectSignal(this, n, n2, n3, n4);
    }

    public boolean hasDirectSignal(int n, int n2, int n3) {
        if (this.getDirectSignal(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (this.getDirectSignal(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (this.getDirectSignal(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (this.getDirectSignal(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (this.getDirectSignal(n - 1, n2, n3, 4)) {
            return true;
        }
        return this.getDirectSignal(n + 1, n2, n3, 5);
    }

    public boolean getSignal(int n, int n2, int n3, int n4) {
        if (this.isSolidTile(n, n2, n3)) {
            return this.hasDirectSignal(n, n2, n3);
        }
        int n5 = this.getTile(n, n2, n3);
        if (n5 == 0) {
            return false;
        }
        return Tile.tiles[n5].getSignal(this, n, n2, n3, n4);
    }

    public boolean hasNeighborSignal(int n, int n2, int n3) {
        if (this.getSignal(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (this.getSignal(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (this.getSignal(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (this.getSignal(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (this.getSignal(n - 1, n2, n3, 4)) {
            return true;
        }
        return this.getSignal(n + 1, n2, n3, 5);
    }

    public Player getNearestPlayer(Entity entity, double d) {
        return this.getNearestPlayer(entity.x, entity.y, entity.z, d);
    }

    public Player getNearestPlayer(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        Player player = null;
        for (int i = 0; i < this.players.size(); ++i) {
            Player player2 = this.players.get(i);
            double d6 = player2.distanceToSqr(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            player = player2;
        }
        return player;
    }

    public byte[] getBlocksAndData(int n, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = new byte[n4 * n5 * n6 * 5 / 2];
        int n7 = n >> 4;
        int n8 = n3 >> 4;
        int n9 = n + n4 - 1 >> 4;
        int n10 = n3 + n6 - 1 >> 4;
        int n11 = 0;
        int n12 = n2;
        int n13 = n2 + n5;
        if (n12 < 0) {
            n12 = 0;
        }
        if (n13 > 128) {
            n13 = 128;
        }
        for (int i = n7; i <= n9; ++i) {
            int n14 = n - i * 16;
            int n15 = n + n4 - i * 16;
            if (n14 < 0) {
                n14 = 0;
            }
            if (n15 > 16) {
                n15 = 16;
            }
            for (int j = n8; j <= n10; ++j) {
                int n16 = n3 - j * 16;
                int n17 = n3 + n6 - j * 16;
                if (n16 < 0) {
                    n16 = 0;
                }
                if (n17 > 16) {
                    n17 = 16;
                }
                n11 = this.getChunk(i, j).getBlocksAndData(byArray, n14, n12, n16, n15, n13, n17, n11);
            }
        }
        return byArray;
    }

    public void setBlocksAndData(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        int n7 = n >> 4;
        int n8 = n3 >> 4;
        int n9 = n + n4 - 1 >> 4;
        int n10 = n3 + n6 - 1 >> 4;
        int n11 = 0;
        int n12 = n2;
        int n13 = n2 + n5;
        if (n12 < 0) {
            n12 = 0;
        }
        if (n13 > 128) {
            n13 = 128;
        }
        for (int i = n7; i <= n9; ++i) {
            int n14 = n - i * 16;
            int n15 = n + n4 - i * 16;
            if (n14 < 0) {
                n14 = 0;
            }
            if (n15 > 16) {
                n15 = 16;
            }
            for (int j = n8; j <= n10; ++j) {
                int n16 = n3 - j * 16;
                int n17 = n3 + n6 - j * 16;
                if (n16 < 0) {
                    n16 = 0;
                }
                if (n17 > 16) {
                    n17 = 16;
                }
                n11 = this.getChunk(i, j).setBlocksAndData(byArray, n14, n12, n16, n15, n13, n17, n11);
                this.setTilesDirty(i * 16 + n14, n12, j * 16 + n16, i * 16 + n15, n13, j * 16 + n17);
            }
        }
    }

    public void disconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSession() {
        try {
            File file = new File(this.dir, "session.lock");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            try {
                if (dataInputStream.readLong() != this.sessionId) {
                    throw new LevelConflictException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new LevelConflictException("Failed to check session lock, aborting");
        }
    }

    public void setTime(long l) {
        this.time = l;
    }

    public void ensureAdded(Entity entity) {
        int n = Mth.floor(entity.x / 16.0);
        int n2 = Mth.floor(entity.z / 16.0);
        int n3 = 2;
        for (int i = n - n3; i <= n + n3; ++i) {
            for (int j = n2 - n3; j <= n2 + n3; ++j) {
                this.getChunk(i, j);
            }
        }
        if (!this.entities.contains(entity)) {
            this.entities.add(entity);
        }
    }

    public boolean mayInteract(Player player, int n, int n2, int n3) {
        return true;
    }

    public void broadcastEntityEvent(Entity entity, byte by) {
    }

    public void removeAllPendingEntityRemovals() {
        int n;
        int n2;
        Entity entity;
        int n3;
        this.entities.removeAll(this.entitiesToRemove);
        for (n3 = 0; n3 < this.entitiesToRemove.size(); ++n3) {
            entity = this.entitiesToRemove.get(n3);
            n2 = entity.xChunk;
            n = entity.zChunk;
            if (!entity.inChunk || !this.hasChunk(n2, n)) continue;
            this.getChunk(n2, n).removeEntity(entity);
        }
        for (n3 = 0; n3 < this.entitiesToRemove.size(); ++n3) {
            this.entityRemoved(this.entitiesToRemove.get(n3));
        }
        this.entitiesToRemove.clear();
        for (n3 = 0; n3 < this.entities.size(); ++n3) {
            entity = this.entities.get(n3);
            if (entity.riding != null) {
                if (!entity.riding.removed && entity.riding.rider == entity) continue;
                entity.riding.rider = null;
                entity.riding = null;
            }
            if (!entity.removed) continue;
            n2 = entity.xChunk;
            n = entity.zChunk;
            if (entity.inChunk && this.hasChunk(n2, n)) {
                this.getChunk(n2, n).removeEntity(entity);
            }
            this.entities.remove(n3--);
            this.entityRemoved(entity);
        }
    }

    public ChunkSource getChunkSource() {
        return this.chunkSource;
    }

    public void tileEvent(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getTile(n, n2, n3);
        if (n6 > 0) {
            Tile.tiles[n6].triggerEvent(this, n, n2, n3, n4, n5);
        }
    }
}

