/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TilePos;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class Explosion {
    public boolean fire = false;
    private Random random = new Random();
    private Level level;
    public double x;
    public double y;
    public double z;
    public Entity source;
    public float r;
    public Set<TilePos> toBlow = new HashSet<TilePos>();

    public Explosion(Level level, Entity entity, double d, double d2, double d3, float f) {
        this.level = level;
        this.source = entity;
        this.r = f;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void explode() {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        float f = this.r;
        int n4 = 16;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n4; ++n) {
                    if (n3 != 0 && n3 != n4 - 1 && n2 != 0 && n2 != n4 - 1 && n != 0 && n != n4 - 1) continue;
                    double d4 = (float)n3 / ((float)n4 - 1.0f) * 2.0f - 1.0f;
                    double d5 = (float)n2 / ((float)n4 - 1.0f) * 2.0f - 1.0f;
                    double d6 = (float)n / ((float)n4 - 1.0f) * 2.0f - 1.0f;
                    double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
                    d4 /= d7;
                    d5 /= d7;
                    d6 /= d7;
                    d3 = this.x;
                    d2 = this.y;
                    d = this.z;
                    float f2 = 0.3f;
                    for (float f3 = this.r * (0.7f + this.level.random.nextFloat() * 0.6f); f3 > 0.0f; f3 -= f2 * 0.75f) {
                        int n5;
                        int n6;
                        int n7 = Mth.floor(d3);
                        int n8 = this.level.getTile(n7, n6 = Mth.floor(d2), n5 = Mth.floor(d));
                        if (n8 > 0) {
                            f3 -= (Tile.tiles[n8].getExplosionResistance(this.source) + 0.3f) * f2;
                        }
                        if (f3 > 0.0f) {
                            this.toBlow.add(new TilePos(n7, n6, n5));
                        }
                        d3 += d4 * (double)f2;
                        d2 += d5 * (double)f2;
                        d += d6 * (double)f2;
                    }
                }
            }
        }
        this.r *= 2.0f;
        n3 = Mth.floor(this.x - (double)this.r - 1.0);
        n2 = Mth.floor(this.x + (double)this.r + 1.0);
        n = Mth.floor(this.y - (double)this.r - 1.0);
        int n9 = Mth.floor(this.y + (double)this.r + 1.0);
        int n10 = Mth.floor(this.z - (double)this.r - 1.0);
        int n11 = Mth.floor(this.z + (double)this.r + 1.0);
        List<Entity> list = this.level.getEntities(this.source, AABB.newTemp(n3, n, n10, n2, n9, n11));
        Vec3 vec3 = Vec3.newTemp(this.x, this.y, this.z);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            double d8 = entity.distanceTo(this.x, this.y, this.z) / (double)this.r;
            if (!(d8 <= 1.0)) continue;
            d3 = entity.x - this.x;
            d2 = entity.y - this.y;
            d = entity.z - this.z;
            double d9 = Mth.sqrt(d3 * d3 + d2 * d2 + d * d);
            d3 /= d9;
            d2 /= d9;
            d /= d9;
            double d10 = this.level.getSeenPercent(vec3, entity.bb);
            double d11 = (1.0 - d8) * d10;
            entity.hurt(this.source, (int)((d11 * d11 + d11) / 2.0 * 8.0 * (double)this.r + 1.0));
            double d12 = d11;
            entity.xd += d3 * d12;
            entity.yd += d2 * d12;
            entity.zd += d * d12;
        }
        this.r = f;
        ArrayList<TilePos> arrayList = new ArrayList<TilePos>();
        arrayList.addAll(this.toBlow);
        if (this.fire) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                TilePos tilePos = (TilePos)arrayList.get(i);
                int n12 = tilePos.x;
                int n13 = tilePos.y;
                int n14 = tilePos.z;
                int n15 = this.level.getTile(n12, n13, n14);
                int n16 = this.level.getTile(n12, n13 - 1, n14);
                if (n15 != 0 || !Tile.solid[n16] || this.random.nextInt(3) != 0) continue;
                this.level.setTile(n12, n13, n14, Tile.fire.id);
            }
        }
    }

    public void addParticles() {
        this.level.playSound(this.x, this.y, this.z, "random.explode", 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f);
        ArrayList<TilePos> arrayList = new ArrayList<TilePos>();
        arrayList.addAll(this.toBlow);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            TilePos tilePos = (TilePos)arrayList.get(i);
            int n = tilePos.x;
            int n2 = tilePos.y;
            int n3 = tilePos.z;
            int n4 = this.level.getTile(n, n2, n3);
            for (int j = 0; j < 1; ++j) {
                double d = (float)n + this.level.random.nextFloat();
                double d2 = (float)n2 + this.level.random.nextFloat();
                double d3 = (float)n3 + this.level.random.nextFloat();
                double d4 = d - this.x;
                double d5 = d2 - this.y;
                double d6 = d3 - this.z;
                double d7 = Mth.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
                d4 /= d7;
                d5 /= d7;
                d6 /= d7;
                double d8 = 0.5 / (d7 / (double)this.r + 0.1);
                this.level.addParticle("explode", (d + this.x * 1.0) / 2.0, (d2 + this.y * 1.0) / 2.0, (d3 + this.z * 1.0) / 2.0, d4 *= (d8 *= (double)(this.level.random.nextFloat() * this.level.random.nextFloat() + 0.3f)), d5 *= d8, d6 *= d8);
                this.level.addParticle("smoke", d, d2, d3, d4, d5, d6);
            }
            if (n4 <= 0) continue;
            Tile.tiles[n4].spawnResources(this.level, n, n2, n3, this.level.getData(n, n2, n3), 0.3f);
            this.level.setTile(n, n2, n3, 0);
            Tile.tiles[n4].wasExploded(this.level, n, n2, n3);
        }
    }
}

