/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.crafting.Recipy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapelessRecipy
implements Recipy {
    private final ItemInstance result;
    private final List<ItemInstance> ingredients;

    public ShapelessRecipy(ItemInstance itemInstance, List<ItemInstance> list) {
        this.result = itemInstance;
        this.ingredients = list;
    }

    @Override
    public boolean matches(CraftingContainer craftingContainer) {
        ArrayList<ItemInstance> arrayList = new ArrayList<ItemInstance>(this.ingredients);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemInstance itemInstance = craftingContainer.getItem(j, i);
                if (itemInstance == null) continue;
                boolean bl = false;
                for (ItemInstance itemInstance2 : arrayList) {
                    if (itemInstance.id != itemInstance2.id || itemInstance2.getAuxValue() != -1 && itemInstance.getAuxValue() != itemInstance2.getAuxValue()) continue;
                    bl = true;
                    arrayList.remove(itemInstance2);
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return arrayList.isEmpty();
    }

    @Override
    public ItemInstance assemble(CraftingContainer craftingContainer) {
        return this.result.copy();
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }
}

