/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.crafting.Recipy;

public class ShapedRecipy
implements Recipy {
    private int width;
    private int height;
    private ItemInstance[] recipeItems;
    private ItemInstance result;
    public final int resultId;

    public ShapedRecipy(int n, int n2, ItemInstance[] itemInstanceArray, ItemInstance itemInstance) {
        this.resultId = itemInstance.id;
        this.width = n;
        this.height = n2;
        this.recipeItems = itemInstanceArray;
        this.result = itemInstance;
    }

    public boolean matches(CraftingContainer craftingContainer) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matches(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.matches(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer craftingContainer, int n, int n2, boolean bl) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemInstance itemInstance;
                int n3 = i - n;
                int n4 = j - n2;
                ItemInstance itemInstance2 = null;
                if (n3 >= 0 && n4 >= 0 && n3 < this.width && n4 < this.height) {
                    itemInstance2 = bl ? this.recipeItems[this.width - n3 - 1 + n4 * this.width] : this.recipeItems[n3 + n4 * this.width];
                }
                if ((itemInstance = craftingContainer.getItem(i, j)) == null && itemInstance2 == null) continue;
                if (itemInstance == null && itemInstance2 != null || itemInstance != null && itemInstance2 == null) {
                    return false;
                }
                if (itemInstance2.id != itemInstance.id) {
                    return false;
                }
                if (itemInstance2.getAuxValue() == -1 || itemInstance2.getAuxValue() == itemInstance.getAuxValue()) continue;
                return false;
            }
        }
        return true;
    }

    public ItemInstance assemble(CraftingContainer craftingContainer) {
        return new ItemInstance(this.result.id, this.result.count, this.result.getAuxValue());
    }

    public int size() {
        return this.width * this.height;
    }
}

