/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.crafting.ArmorRecipes;
import net.minecraft.world.item.crafting.ClothDyeRecipes;
import net.minecraft.world.item.crafting.FoodRecipies;
import net.minecraft.world.item.crafting.OreRecipies;
import net.minecraft.world.item.crafting.Recipy;
import net.minecraft.world.item.crafting.ShapedRecipy;
import net.minecraft.world.item.crafting.ShapelessRecipy;
import net.minecraft.world.item.crafting.StructureRecipies;
import net.minecraft.world.item.crafting.ToolRecipies;
import net.minecraft.world.item.crafting.WeaponRecipies;
import net.minecraft.world.level.tile.Tile;

public class Recipes {
    public static final int ANY_AUX_VALUE = -1;
    private static final Recipes instance = new Recipes();
    private List<Recipy> recipies = new ArrayList<Recipy>();

    public static final Recipes getInstance() {
        return instance;
    }

    private Recipes() {
        new ToolRecipies().addRecipes(this);
        new WeaponRecipies().addRecipes(this);
        new OreRecipies().addRecipes(this);
        new FoodRecipies().addRecipes(this);
        new StructureRecipies().addRecipes(this);
        new ArmorRecipes().addRecipes(this);
        new ClothDyeRecipes().addRecipes(this);
        this.addShapedRecipy(new ItemInstance(Item.paper, 3), "###", Character.valueOf('#'), Item.reeds);
        this.addShapedRecipy(new ItemInstance(Item.book, 1), "#", "#", "#", Character.valueOf('#'), Item.paper);
        this.addShapedRecipy(new ItemInstance(Tile.fence, 2), "###", "###", Character.valueOf('#'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Tile.recordPlayer, 1), "###", "#X#", "###", Character.valueOf('#'), Tile.wood, Character.valueOf('X'), Item.emerald);
        this.addShapedRecipy(new ItemInstance(Tile.musicBlock, 1), "###", "#X#", "###", Character.valueOf('#'), Tile.wood, Character.valueOf('X'), Item.redStone);
        this.addShapedRecipy(new ItemInstance(Tile.bookshelf, 1), "###", "XXX", "###", Character.valueOf('#'), Tile.wood, Character.valueOf('X'), Item.book);
        this.addShapedRecipy(new ItemInstance(Tile.snow, 1), "##", "##", Character.valueOf('#'), Item.snowBall);
        this.addShapedRecipy(new ItemInstance(Tile.clay, 1), "##", "##", Character.valueOf('#'), Item.clay);
        this.addShapedRecipy(new ItemInstance(Tile.redBrick, 1), "##", "##", Character.valueOf('#'), Item.brick);
        this.addShapedRecipy(new ItemInstance(Tile.lightGem, 1), "###", "###", "###", Character.valueOf('#'), Item.yellowDust);
        this.addShapedRecipy(new ItemInstance(Tile.cloth, 1), "###", "###", "###", Character.valueOf('#'), Item.string);
        this.addShapedRecipy(new ItemInstance(Tile.tnt, 1), "X#X", "#X#", "X#X", Character.valueOf('X'), Item.sulphur, Character.valueOf('#'), Tile.sand);
        this.addShapedRecipy(new ItemInstance(Tile.stoneSlabHalf, 3), "###", Character.valueOf('#'), Tile.stoneBrick);
        this.addShapedRecipy(new ItemInstance(Tile.ladder, 1), "# #", "###", "# #", Character.valueOf('#'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Item.door_wood, 1), "##", "##", "##", Character.valueOf('#'), Tile.wood);
        this.addShapedRecipy(new ItemInstance(Item.door_iron, 1), "##", "##", "##", Character.valueOf('#'), Item.ironIngot);
        this.addShapedRecipy(new ItemInstance(Item.sign, 1), "###", "###", " X ", Character.valueOf('#'), Tile.wood, Character.valueOf('X'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Item.cake, 1), "AAA", "BEB", "CCC", Character.valueOf('A'), Item.milk, Character.valueOf('B'), Item.sugar, Character.valueOf('C'), Item.wheat, Character.valueOf('E'), Item.egg);
        this.addShapedRecipy(new ItemInstance(Item.sugar, 1), "#", Character.valueOf('#'), Item.reeds);
        this.addShapedRecipy(new ItemInstance(Tile.wood, 4), "#", Character.valueOf('#'), Tile.treeTrunk);
        this.addShapedRecipy(new ItemInstance(Item.stick, 4), "#", "#", Character.valueOf('#'), Tile.wood);
        this.addShapedRecipy(new ItemInstance(Tile.torch, 4), "X", "#", Character.valueOf('X'), Item.coal, Character.valueOf('#'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Tile.torch, 4), "X", "#", Character.valueOf('X'), new ItemInstance(Item.coal, 1, 1), Character.valueOf('#'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Item.bowl, 4), "# #", " # ", Character.valueOf('#'), Tile.wood);
        this.addShapedRecipy(new ItemInstance(Tile.rail, 16), "X X", "X#X", "X X", Character.valueOf('X'), Item.ironIngot, Character.valueOf('#'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Item.minecart, 1), "# #", "###", Character.valueOf('#'), Item.ironIngot);
        this.addShapedRecipy(new ItemInstance(Tile.litPumpkin, 1), "A", "B", Character.valueOf('A'), Tile.pumpkin, Character.valueOf('B'), Tile.torch);
        this.addShapedRecipy(new ItemInstance(Item.minecart_chest, 1), "A", "B", Character.valueOf('A'), Tile.chest, Character.valueOf('B'), Item.minecart);
        this.addShapedRecipy(new ItemInstance(Item.minecart_furnace, 1), "A", "B", Character.valueOf('A'), Tile.furnace, Character.valueOf('B'), Item.minecart);
        this.addShapedRecipy(new ItemInstance(Item.boat, 1), "# #", "###", Character.valueOf('#'), Tile.wood);
        this.addShapedRecipy(new ItemInstance(Item.bucket_empty, 1), "# #", " # ", Character.valueOf('#'), Item.ironIngot);
        this.addShapedRecipy(new ItemInstance(Item.flintAndSteel, 1), "A ", " B", Character.valueOf('A'), Item.ironIngot, Character.valueOf('B'), Item.flint);
        this.addShapedRecipy(new ItemInstance(Item.bread, 1), "###", Character.valueOf('#'), Item.wheat);
        this.addShapedRecipy(new ItemInstance(Tile.stairs_wood, 4), "#  ", "## ", "###", Character.valueOf('#'), Tile.wood);
        this.addShapedRecipy(new ItemInstance(Item.fishingRod, 1), "  #", " #X", "# X", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.string);
        this.addShapedRecipy(new ItemInstance(Tile.stairs_stone, 4), "#  ", "## ", "###", Character.valueOf('#'), Tile.stoneBrick);
        this.addShapedRecipy(new ItemInstance(Item.painting, 1), "###", "#X#", "###", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Tile.cloth);
        this.addShapedRecipy(new ItemInstance(Item.apple_gold, 1), "###", "#X#", "###", Character.valueOf('#'), Tile.goldBlock, Character.valueOf('X'), Item.apple);
        this.addShapedRecipy(new ItemInstance(Tile.lever, 1), "X", "#", Character.valueOf('#'), Tile.stoneBrick, Character.valueOf('X'), Item.stick);
        this.addShapedRecipy(new ItemInstance(Tile.notGate_on, 1), "X", "#", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.redStone);
        this.addShapedRecipy(new ItemInstance(Item.clock, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.goldIngot, Character.valueOf('X'), Item.redStone);
        this.addShapedRecipy(new ItemInstance(Item.compass, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.ironIngot, Character.valueOf('X'), Item.redStone);
        this.addShapedRecipy(new ItemInstance(Tile.button, 1), "#", "#", Character.valueOf('#'), Tile.rock);
        this.addShapedRecipy(new ItemInstance(Tile.pressurePlate_stone, 1), "###", Character.valueOf('#'), Tile.rock);
        this.addShapedRecipy(new ItemInstance(Tile.pressurePlate_wood, 1), "###", Character.valueOf('#'), Tile.wood);
        this.addShapedRecipy(new ItemInstance(Tile.dispenser, 1), "###", "#X#", "#R#", Character.valueOf('#'), Tile.stoneBrick, Character.valueOf('X'), Item.bow, Character.valueOf('R'), Item.redStone);
        Collections.sort(this.recipies, new Comparator<Recipy>(){

            @Override
            public int compare(Recipy recipy, Recipy recipy2) {
                if (recipy instanceof ShapelessRecipy && recipy2 instanceof ShapedRecipy) {
                    return 1;
                }
                if (recipy2 instanceof ShapelessRecipy && recipy instanceof ShapedRecipy) {
                    return -1;
                }
                if (recipy2.size() < recipy.size()) {
                    return -1;
                }
                if (recipy2.size() > recipy.size()) {
                    return 1;
                }
                return 0;
            }
        });
        System.out.println(this.recipies.size() + " recipes");
    }

    void addShapedRecipy(ItemInstance itemInstance, Object ... objectArray) {
        Object object;
        Object object2;
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (objectArray[n] instanceof String[]) {
            object2 = (String[])objectArray[n++];
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = object2[i];
                ++n3;
                n2 = ((String)object).length();
                string = string + (String)object;
            }
        } else {
            while (objectArray[n] instanceof String) {
                object2 = (String)objectArray[n++];
                ++n3;
                n2 = ((String)object2).length();
                string = string + (String)object2;
            }
        }
        object2 = new HashMap();
        while (n < objectArray.length) {
            Character c = (Character)objectArray[n];
            object = null;
            if (objectArray[n + 1] instanceof Item) {
                object = new ItemInstance((Item)objectArray[n + 1]);
            } else if (objectArray[n + 1] instanceof Tile) {
                object = new ItemInstance((Tile)objectArray[n + 1], 1, -1);
            } else if (objectArray[n + 1] instanceof ItemInstance) {
                object = (ItemInstance)objectArray[n + 1];
            }
            object2.put(c, object);
            n += 2;
        }
        ItemInstance[] itemInstanceArray = new ItemInstance[n2 * n3];
        for (int i = 0; i < n2 * n3; ++i) {
            char c = string.charAt(i);
            itemInstanceArray[i] = object2.containsKey(Character.valueOf(c)) ? ((ItemInstance)object2.get(Character.valueOf(c))).copy() : null;
        }
        this.recipies.add(new ShapedRecipy(n2, n3, itemInstanceArray, itemInstance));
    }

    void addShapelessRecipy(ItemInstance itemInstance, Object ... objectArray) {
        ArrayList<ItemInstance> arrayList = new ArrayList<ItemInstance>();
        for (Object object : objectArray) {
            if (object instanceof ItemInstance) {
                arrayList.add(((ItemInstance)object).copy());
                continue;
            }
            if (object instanceof Item) {
                arrayList.add(new ItemInstance((Item)object));
                continue;
            }
            if (object instanceof Tile) {
                arrayList.add(new ItemInstance((Tile)object));
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipy!");
        }
        this.recipies.add(new ShapelessRecipy(itemInstance, arrayList));
    }

    public ItemInstance getItemFor(CraftingContainer craftingContainer) {
        for (int i = 0; i < this.recipies.size(); ++i) {
            Recipy recipy = this.recipies.get(i);
            if (!recipy.matches(craftingContainer)) continue;
            return recipy.assemble(craftingContainer);
        }
        return null;
    }
}

