/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.Tile;

public class FurnaceRecipes {
    private static final FurnaceRecipes instance = new FurnaceRecipes();
    private Map<Integer, ItemInstance> recipies = new HashMap<Integer, ItemInstance>();

    public static final FurnaceRecipes getInstance() {
        return instance;
    }

    private FurnaceRecipes() {
        this.addFurnaceRecipy(Tile.ironOre.id, new ItemInstance(Item.ironIngot));
        this.addFurnaceRecipy(Tile.goldOre.id, new ItemInstance(Item.goldIngot));
        this.addFurnaceRecipy(Tile.emeraldOre.id, new ItemInstance(Item.emerald));
        this.addFurnaceRecipy(Tile.sand.id, new ItemInstance(Tile.glass));
        this.addFurnaceRecipy(Item.porkChop_raw.id, new ItemInstance(Item.porkChop_cooked));
        this.addFurnaceRecipy(Item.fish_raw.id, new ItemInstance(Item.fish_cooked));
        this.addFurnaceRecipy(Tile.stoneBrick.id, new ItemInstance(Tile.rock));
        this.addFurnaceRecipy(Item.clay.id, new ItemInstance(Item.brick));
        this.addFurnaceRecipy(Tile.cactus.id, new ItemInstance(Item.dye_powder, 1, 2));
        this.addFurnaceRecipy(Tile.treeTrunk.id, new ItemInstance(Item.coal, 1, 1));
    }

    public void addFurnaceRecipy(int n, ItemInstance itemInstance) {
        this.recipies.put(n, itemInstance);
    }

    public boolean isFurnaceItem(int n) {
        return this.recipies.containsKey(n);
    }

    public ItemInstance getResult(int n) {
        return this.recipies.get(n);
    }
}

