/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.Tile;

public class WeaponItem
extends Item {
    private int damage;

    public WeaponItem(int n, Item.Tier tier) {
        super(n);
        this.maxStackSize = 1;
        this.maxDamage = tier.getUses();
        this.damage = 4 + tier.getAttackDamageBonus() * 2;
    }

    public float getDestroySpeed(ItemInstance itemInstance, Tile tile) {
        return 1.5f;
    }

    public void hurtEnemy(ItemInstance itemInstance, Mob mob) {
        itemInstance.hurt(1);
    }

    public void mineBlock(ItemInstance itemInstance, int n, int n2, int n3, int n4) {
        itemInstance.hurt(2);
    }

    public int getAttackDamage(Entity entity) {
        return this.damage;
    }

    public boolean isHandEquipped() {
        return true;
    }
}

