/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

public class TilePlanterItem
extends Item {
    private int tileId;

    public TilePlanterItem(int n, Tile tile) {
        super(n);
        this.tileId = tile.id;
    }

    public boolean useOn(ItemInstance itemInstance, Player player, Level level, int n, int n2, int n3, int n4) {
        if (level.getTile(n, n2, n3) == Tile.topSnow.id) {
            n4 = 0;
        } else {
            if (n4 == 0) {
                --n2;
            }
            if (n4 == 1) {
                ++n2;
            }
            if (n4 == 2) {
                --n3;
            }
            if (n4 == 3) {
                ++n3;
            }
            if (n4 == 4) {
                --n;
            }
            if (n4 == 5) {
                ++n;
            }
        }
        if (itemInstance.count == 0) {
            return false;
        }
        if (level.mayPlace(this.tileId, n, n2, n3, false)) {
            Tile tile = Tile.tiles[this.tileId];
            if (level.setTile(n, n2, n3, this.tileId)) {
                Tile.tiles[this.tileId].setPlacedOnFace(level, n, n2, n3, n4);
                level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, tile.soundType.getStepSound(), (tile.soundType.getVolume() + 1.0f) / 2.0f, tile.soundType.getPitch() * 0.8f);
                --itemInstance.count;
            }
        }
        return true;
    }
}

