/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

public class TileItem
extends Item {
    private int tileId;

    public TileItem(int n) {
        super(n);
        this.tileId = n + 256;
        this.setIcon(Tile.tiles[n + 256].getTexture(2));
    }

    public int getTileId() {
        return this.tileId;
    }

    public boolean useOn(ItemInstance itemInstance, Player player, Level level, int n, int n2, int n3, int n4) {
        if (level.getTile(n, n2, n3) == Tile.topSnow.id) {
            n4 = 0;
        } else {
            if (n4 == 0) {
                --n2;
            }
            if (n4 == 1) {
                ++n2;
            }
            if (n4 == 2) {
                --n3;
            }
            if (n4 == 3) {
                ++n3;
            }
            if (n4 == 4) {
                --n;
            }
            if (n4 == 5) {
                ++n;
            }
        }
        if (itemInstance.count == 0) {
            return false;
        }
        if (level.mayPlace(this.tileId, n, n2, n3, false)) {
            Tile tile = Tile.tiles[this.tileId];
            if (level.setTileAndData(n, n2, n3, this.tileId, this.getLevelDataForAuxValue(itemInstance.getAuxValue()))) {
                Tile.tiles[this.tileId].setPlacedOnFace(level, n, n2, n3, n4);
                Tile.tiles[this.tileId].setPlacedBy(level, n, n2, n3, player);
                level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, tile.soundType.getStepSound(), (tile.soundType.getVolume() + 1.0f) / 2.0f, tile.soundType.getPitch() * 0.8f);
                --itemInstance.count;
            }
        }
        return true;
    }

    public String getDescriptionId(ItemInstance itemInstance) {
        return Tile.tiles[this.tileId].getDescriptionId();
    }

    public String getDescriptionId() {
        return Tile.tiles[this.tileId].getDescriptionId();
    }
}

