/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.SignTileEntity;
import util.Mth;

public class SignItem
extends Item {
    public SignItem(int n) {
        super(n);
        this.maxDamage = 64;
        this.maxStackSize = 1;
    }

    public boolean useOn(ItemInstance itemInstance, Player player, Level level, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return false;
        }
        if (!level.getMaterial(n, n2, n3).isSolid()) {
            return false;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (!Tile.sign.mayPlace(level, n, n2, n3)) {
            return false;
        }
        if (n4 == 1) {
            level.setTileAndData(n, n2, n3, Tile.sign.id, Mth.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        } else {
            level.setTileAndData(n, n2, n3, Tile.wallSign.id, n4);
        }
        --itemInstance.count;
        SignTileEntity signTileEntity = (SignTileEntity)level.getTileEntity(n, n2, n3);
        if (signTileEntity != null) {
            player.openTextEdit(signTileEntity);
        }
        return true;
    }
}

