/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.nbt.CompoundTag;
import net.minecraft.locale.Descriptive;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ItemInstance
implements Descriptive<ItemInstance> {
    public int count = 0;
    public int popTime;
    public int id;
    private int auxValue;

    public ItemInstance(Tile tile) {
        this(tile, 1);
    }

    public ItemInstance(Tile tile, int n) {
        this(tile.id, n, 0);
    }

    public ItemInstance(Tile tile, int n, int n2) {
        this(tile.id, n, n2);
    }

    public ItemInstance(Item item) {
        this(item.id, 1, 0);
    }

    public ItemInstance(Item item, int n) {
        this(item.id, n, 0);
    }

    public ItemInstance(Item item, int n, int n2) {
        this(item.id, n, n2);
    }

    public ItemInstance(int n, int n2, int n3) {
        this.id = n;
        this.count = n2;
        this.auxValue = n3;
    }

    public ItemInstance(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public ItemInstance remove(int n) {
        this.count -= n;
        return new ItemInstance(this.id, n, this.auxValue);
    }

    public Item getItem() {
        return Item.items[this.id];
    }

    public int getIcon() {
        return this.getItem().getIcon(this);
    }

    public boolean useOn(Player player, Level level, int n, int n2, int n3, int n4) {
        return this.getItem().useOn(this, player, level, n, n2, n3, n4);
    }

    public float getDestroySpeed(Tile tile) {
        return this.getItem().getDestroySpeed(this, tile);
    }

    public ItemInstance use(Level level, Player player) {
        return this.getItem().use(this, level, player);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.putShort("id", (short)this.id);
        compoundTag.putByte("Count", (byte)this.count);
        compoundTag.putShort("Damage", (short)this.auxValue);
        return compoundTag;
    }

    public void load(CompoundTag compoundTag) {
        this.id = compoundTag.getShort("id");
        this.count = compoundTag.getByte("Count");
        this.auxValue = compoundTag.getShort("Damage");
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return Item.items[this.id].getMaxDamage() > 0;
    }

    public boolean isStackedByData() {
        return Item.items[this.id].isStackedByData();
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.auxValue > 0;
    }

    public int getDamageValue() {
        return this.auxValue;
    }

    public int getAuxValue() {
        return this.auxValue;
    }

    public int getMaxDamage() {
        return Item.items[this.id].getMaxDamage();
    }

    public void hurt(int n) {
        if (!this.isDamageableItem()) {
            return;
        }
        this.auxValue += n;
        if (this.auxValue > this.getMaxDamage()) {
            --this.count;
            if (this.count < 0) {
                this.count = 0;
            }
            this.auxValue = 0;
        }
    }

    public void hurtEnemy(Mob mob) {
        Item.items[this.id].hurtEnemy(this, mob);
    }

    public void mineBlock(int n, int n2, int n3, int n4) {
        Item.items[this.id].mineBlock(this, n, n2, n3, n4);
    }

    public int getAttackDamage(Entity entity) {
        return Item.items[this.id].getAttackDamage(entity);
    }

    public boolean canDestroySpecial(Tile tile) {
        return Item.items[this.id].canDestroySpecial(tile);
    }

    public void snap(Player player) {
    }

    public void interactEnemy(Mob mob) {
        Item.items[this.id].interactEnemy(this, mob);
    }

    public ItemInstance copy() {
        return new ItemInstance(this.id, this.count, this.auxValue);
    }

    public static boolean matches(ItemInstance itemInstance, ItemInstance itemInstance2) {
        if (itemInstance == null && itemInstance2 == null) {
            return true;
        }
        if (itemInstance == null || itemInstance2 == null) {
            return false;
        }
        return itemInstance.matches(itemInstance2);
    }

    private boolean matches(ItemInstance itemInstance) {
        if (this.count != itemInstance.count) {
            return false;
        }
        if (this.id != itemInstance.id) {
            return false;
        }
        return this.auxValue == itemInstance.auxValue;
    }

    public boolean sameItem(ItemInstance itemInstance) {
        return this.id == itemInstance.id && this.auxValue == itemInstance.auxValue;
    }

    @Override
    public String getDescriptionId() {
        return Item.items[this.id].getDescriptionId(this);
    }

    @Override
    public ItemInstance setDescriptionId(String string) {
        return this;
    }

    public static ItemInstance clone(ItemInstance itemInstance) {
        return itemInstance == null ? null : itemInstance.copy();
    }

    public String toString() {
        return this.count + "x" + Item.items[this.id].getDescriptionId() + "@" + this.auxValue;
    }
}

