/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Random;
import net.minecraft.locale.Descriptive;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CoalItem;
import net.minecraft.world.item.DoorItem;
import net.minecraft.world.item.DyePowderItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodItem;
import net.minecraft.world.item.HatchetItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PaintingItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.RecordingItem;
import net.minecraft.world.item.RedStoneItem;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.SeedItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.TilePlanterItem;
import net.minecraft.world.item.WeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
implements Descriptive<Item> {
    protected static final int ICON_COLUMNS = 16;
    protected static final String ICON_DESCRIPTION_PREFIX = "item.";
    protected static Random random = new Random();
    private static final int MAX_STACK_SIZE = 64;
    public static Item[] items = new Item[32000];
    public static Item shovel_iron = new ShovelItem(0, Tier.IRON).setIcon(2, 5).setDescriptionId("shovelIron");
    public static Item pickAxe_iron = new PickaxeItem(1, Tier.IRON).setIcon(2, 6).setDescriptionId("pickaxeIron");
    public static Item hatchet_iron = new HatchetItem(2, Tier.IRON).setIcon(2, 7).setDescriptionId("hatchetIron");
    public static Item flintAndSteel = new FlintAndSteelItem(3).setIcon(5, 0).setDescriptionId("flintAndSteel");
    public static Item apple = new FoodItem(4, 4).setIcon(10, 0).setDescriptionId("apple");
    public static Item bow = new BowItem(5).setIcon(5, 1).setDescriptionId("bow");
    public static Item arrow = new Item(6).setIcon(5, 2).setDescriptionId("arrow");
    public static Item coal = new CoalItem(7).setIcon(7, 0).setDescriptionId("coal");
    public static Item emerald = new Item(8).setIcon(7, 3).setDescriptionId("emerald");
    public static Item ironIngot = new Item(9).setIcon(7, 1).setDescriptionId("ingotIron");
    public static Item goldIngot = new Item(10).setIcon(7, 2).setDescriptionId("ingotGold");
    public static Item sword_iron = new WeaponItem(11, Tier.IRON).setIcon(2, 4).setDescriptionId("swordIron");
    public static Item sword_wood = new WeaponItem(12, Tier.WOOD).setIcon(0, 4).setDescriptionId("swordWood");
    public static Item shovel_wood = new ShovelItem(13, Tier.WOOD).setIcon(0, 5).setDescriptionId("shovelWood");
    public static Item pickAxe_wood = new PickaxeItem(14, Tier.WOOD).setIcon(0, 6).setDescriptionId("pickaxeWood");
    public static Item hatchet_wood = new HatchetItem(15, Tier.WOOD).setIcon(0, 7).setDescriptionId("hatchetWood");
    public static Item sword_stone = new WeaponItem(16, Tier.STONE).setIcon(1, 4).setDescriptionId("swordStone");
    public static Item shovel_stone = new ShovelItem(17, Tier.STONE).setIcon(1, 5).setDescriptionId("shovelStone");
    public static Item pickAxe_stone = new PickaxeItem(18, Tier.STONE).setIcon(1, 6).setDescriptionId("pickaxeStone");
    public static Item hatchet_stone = new HatchetItem(19, Tier.STONE).setIcon(1, 7).setDescriptionId("hatchetStone");
    public static Item sword_emerald = new WeaponItem(20, Tier.EMERALD).setIcon(3, 4).setDescriptionId("swordDiamond");
    public static Item shovel_emerald = new ShovelItem(21, Tier.EMERALD).setIcon(3, 5).setDescriptionId("shovelDiamond");
    public static Item pickAxe_emerald = new PickaxeItem(22, Tier.EMERALD).setIcon(3, 6).setDescriptionId("pickaxeDiamond");
    public static Item hatchet_emerald = new HatchetItem(23, Tier.EMERALD).setIcon(3, 7).setDescriptionId("hatchetDiamond");
    public static Item stick = new Item(24).setIcon(5, 3).handEquipped().setDescriptionId("stick");
    public static Item bowl = new Item(25).setIcon(7, 4).setDescriptionId("bowl");
    public static Item mushroomStew = new BowlFoodItem(26, 10).setIcon(8, 4).setDescriptionId("mushroomStew");
    public static Item sword_gold = new WeaponItem(27, Tier.GOLD).setIcon(4, 4).setDescriptionId("swordGold");
    public static Item shovel_gold = new ShovelItem(28, Tier.GOLD).setIcon(4, 5).setDescriptionId("shovelGold");
    public static Item pickAxe_gold = new PickaxeItem(29, Tier.GOLD).setIcon(4, 6).setDescriptionId("pickaxeGold");
    public static Item hatchet_gold = new HatchetItem(30, Tier.GOLD).setIcon(4, 7).setDescriptionId("hatchetGold");
    public static Item string = new Item(31).setIcon(8, 0).setDescriptionId("string");
    public static Item feather = new Item(32).setIcon(8, 1).setDescriptionId("feather");
    public static Item sulphur = new Item(33).setIcon(8, 2).setDescriptionId("sulphur");
    public static Item hoe_wood = new HoeItem(34, Tier.WOOD).setIcon(0, 8).setDescriptionId("hoeWood");
    public static Item hoe_stone = new HoeItem(35, Tier.STONE).setIcon(1, 8).setDescriptionId("hoeStone");
    public static Item hoe_iron = new HoeItem(36, Tier.IRON).setIcon(2, 8).setDescriptionId("hoeIron");
    public static Item hoe_emerald = new HoeItem(37, Tier.EMERALD).setIcon(3, 8).setDescriptionId("hoeDiamond");
    public static Item hoe_gold = new HoeItem(38, Tier.GOLD).setIcon(4, 8).setDescriptionId("hoeGold");
    public static Item seeds = new SeedItem(39, Tile.crops.id).setIcon(9, 0).setDescriptionId("seeds");
    public static Item wheat = new Item(40).setIcon(9, 1).setDescriptionId("wheat");
    public static Item bread = new FoodItem(41, 5).setIcon(9, 2).setDescriptionId("bread");
    public static Item helmet_cloth = new ArmorItem(42, 0, 0, 0).setIcon(0, 0).setDescriptionId("helmetCloth");
    public static Item chestplate_cloth = new ArmorItem(43, 0, 0, 1).setIcon(0, 1).setDescriptionId("chestplateCloth");
    public static Item leggings_cloth = new ArmorItem(44, 0, 0, 2).setIcon(0, 2).setDescriptionId("leggingsCloth");
    public static Item boots_cloth = new ArmorItem(45, 0, 0, 3).setIcon(0, 3).setDescriptionId("bootsCloth");
    public static Item helmet_chain = new ArmorItem(46, 1, 1, 0).setIcon(1, 0).setDescriptionId("helmetChain");
    public static Item chestplate_chain = new ArmorItem(47, 1, 1, 1).setIcon(1, 1).setDescriptionId("chestplateChain");
    public static Item leggings_chain = new ArmorItem(48, 1, 1, 2).setIcon(1, 2).setDescriptionId("leggingsChain");
    public static Item boots_chain = new ArmorItem(49, 1, 1, 3).setIcon(1, 3).setDescriptionId("bootsChain");
    public static Item helmet_iron = new ArmorItem(50, 2, 2, 0).setIcon(2, 0).setDescriptionId("helmetIron");
    public static Item chestplate_iron = new ArmorItem(51, 2, 2, 1).setIcon(2, 1).setDescriptionId("chestplateIron");
    public static Item leggings_iron = new ArmorItem(52, 2, 2, 2).setIcon(2, 2).setDescriptionId("leggingsIron");
    public static Item boots_iron = new ArmorItem(53, 2, 2, 3).setIcon(2, 3).setDescriptionId("bootsIron");
    public static Item helmet_diamond = new ArmorItem(54, 3, 3, 0).setIcon(3, 0).setDescriptionId("helmetDiamond");
    public static Item chestplate_diamond = new ArmorItem(55, 3, 3, 1).setIcon(3, 1).setDescriptionId("chestplateDiamond");
    public static Item leggings_diamond = new ArmorItem(56, 3, 3, 2).setIcon(3, 2).setDescriptionId("leggingsDiamond");
    public static Item boots_diamond = new ArmorItem(57, 3, 3, 3).setIcon(3, 3).setDescriptionId("bootsDiamond");
    public static Item helmet_gold = new ArmorItem(58, 1, 4, 0).setIcon(4, 0).setDescriptionId("helmetGold");
    public static Item chestplate_gold = new ArmorItem(59, 1, 4, 1).setIcon(4, 1).setDescriptionId("chestplateGold");
    public static Item leggings_gold = new ArmorItem(60, 1, 4, 2).setIcon(4, 2).setDescriptionId("leggingsGold");
    public static Item boots_gold = new ArmorItem(61, 1, 4, 3).setIcon(4, 3).setDescriptionId("bootsGold");
    public static Item flint = new Item(62).setIcon(6, 0).setDescriptionId("flint");
    public static Item porkChop_raw = new FoodItem(63, 3).setIcon(7, 5).setDescriptionId("porkchopRaw");
    public static Item porkChop_cooked = new FoodItem(64, 8).setIcon(8, 5).setDescriptionId("porkchopCooked");
    public static Item painting = new PaintingItem(65).setIcon(10, 1).setDescriptionId("painting");
    public static Item apple_gold = new FoodItem(66, 42).setIcon(11, 0).setDescriptionId("appleGold");
    public static Item sign = new SignItem(67).setIcon(10, 2).setDescriptionId("sign");
    public static Item door_wood = new DoorItem(68, Material.wood).setIcon(11, 2).setDescriptionId("doorWood");
    public static Item bucket_empty = new BucketItem(69, 0).setIcon(10, 4).setDescriptionId("bucket");
    public static Item bucket_water = new BucketItem(70, Tile.water.id).setIcon(11, 4).setDescriptionId("bucketWater").setCraftingRemainingItem(bucket_empty);
    public static Item bucket_lava = new BucketItem(71, Tile.lava.id).setIcon(12, 4).setDescriptionId("bucketLava").setCraftingRemainingItem(bucket_empty);
    public static Item minecart = new MinecartItem(72, 0).setIcon(7, 8).setDescriptionId("minecart");
    public static Item saddle = new SaddleItem(73).setIcon(8, 6).setDescriptionId("saddle");
    public static Item door_iron = new DoorItem(74, Material.metal).setIcon(12, 2).setDescriptionId("doorIron");
    public static Item redStone = new RedStoneItem(75).setIcon(8, 3).setDescriptionId("redstone");
    public static Item snowBall = new SnowballItem(76).setIcon(14, 0).setDescriptionId("snowball");
    public static Item boat = new BoatItem(77).setIcon(8, 8).setDescriptionId("boat");
    public static Item leather = new Item(78).setIcon(7, 6).setDescriptionId("leather");
    public static Item milk = new BucketItem(79, -1).setIcon(13, 4).setDescriptionId("milk").setCraftingRemainingItem(bucket_empty);
    public static Item brick = new Item(80).setIcon(6, 1).setDescriptionId("brick");
    public static Item clay = new Item(81).setIcon(9, 3).setDescriptionId("clay");
    public static Item reeds = new TilePlanterItem(82, Tile.reeds).setIcon(11, 1).setDescriptionId("reeds");
    public static Item paper = new Item(83).setIcon(10, 3).setDescriptionId("paper");
    public static Item book = new Item(84).setIcon(11, 3).setDescriptionId("book");
    public static Item slimeBall = new Item(85).setIcon(14, 1).setDescriptionId("slimeball");
    public static Item minecart_chest = new MinecartItem(86, 1).setIcon(7, 9).setDescriptionId("minecartChest");
    public static Item minecart_furnace = new MinecartItem(87, 2).setIcon(7, 10).setDescriptionId("minecartFurnace");
    public static Item egg = new EggItem(88).setIcon(12, 0).setDescriptionId("egg");
    public static Item compass = new Item(89).setIcon(6, 3).setDescriptionId("compass");
    public static Item fishingRod = new FishingRodItem(90).setIcon(5, 4).setDescriptionId("fishingRod");
    public static Item clock = new Item(91).setIcon(6, 4).setDescriptionId("clock");
    public static Item yellowDust = new Item(92).setIcon(9, 4).setDescriptionId("yellowDust");
    public static Item fish_raw = new FoodItem(93, 2).setIcon(9, 5).setDescriptionId("fishRaw");
    public static Item fish_cooked = new FoodItem(94, 5).setIcon(10, 5).setDescriptionId("fishCooked");
    public static Item dye_powder = new DyePowderItem(95).setIcon(14, 4).setDescriptionId("dyePowder");
    public static Item bone = new Item(96).setIcon(12, 1).setDescriptionId("bone").handEquipped();
    public static Item sugar = new Item(97).setIcon(13, 0).setDescriptionId("sugar").handEquipped();
    public static Item cake = new TilePlanterItem(98, Tile.cake).setMaxStackSize(1).setIcon(13, 1).setDescriptionId("cake");
    public static Item record_01 = new RecordingItem(2000, "13").setIcon(0, 15).setDescriptionId("record");
    public static Item record_02 = new RecordingItem(2001, "cat").setIcon(1, 15).setDescriptionId("record");
    public final int id;
    protected int maxStackSize = 64;
    protected int maxDamage = 32;
    protected int icon;
    protected boolean handEquipped = false;
    protected boolean isStackedByData = false;
    private Item craftingRemainingItem = null;
    private String descriptionId;

    protected Item(int n) {
        this.id = 256 + n;
        if (items[256 + n] != null) {
            System.out.println("CONFLICT @ " + n);
        }
        Item.items[256 + n] = this;
    }

    public Item setIcon(int n) {
        this.icon = n;
        return this;
    }

    public Item setMaxStackSize(int n) {
        this.maxStackSize = n;
        return this;
    }

    public Item setIcon(int n, int n2) {
        this.icon = n + n2 * 16;
        return this;
    }

    public int getIcon(ItemInstance itemInstance) {
        return this.icon;
    }

    public final boolean useOn(ItemInstance itemInstance, Level level, int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean useOn(ItemInstance itemInstance, Player player, Level level, int n, int n2, int n3, int n4) {
        return false;
    }

    public float getDestroySpeed(ItemInstance itemInstance, Tile tile) {
        return 1.0f;
    }

    public ItemInstance use(ItemInstance itemInstance, Level level, Player player) {
        return itemInstance;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public int getLevelDataForAuxValue(int n) {
        return 0;
    }

    public boolean isStackedByData() {
        return this.isStackedByData;
    }

    protected Item setStackedByData(boolean bl) {
        this.isStackedByData = bl;
        return this;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    protected Item setMaxDamage(int n) {
        this.maxDamage = n;
        return this;
    }

    public void hurtEnemy(ItemInstance itemInstance, Mob mob) {
    }

    public void mineBlock(ItemInstance itemInstance, int n, int n2, int n3, int n4) {
    }

    public int getAttackDamage(Entity entity) {
        return 1;
    }

    public boolean canDestroySpecial(Tile tile) {
        return false;
    }

    public void interactEnemy(ItemInstance itemInstance, Mob mob) {
    }

    public Item handEquipped() {
        this.handEquipped = true;
        return this;
    }

    public boolean isHandEquipped() {
        return this.handEquipped;
    }

    public boolean isMirroredArt() {
        return false;
    }

    @Override
    public Item setDescriptionId(String string) {
        this.descriptionId = ICON_DESCRIPTION_PREFIX + string;
        return this;
    }

    @Override
    public String getDescriptionId() {
        return this.descriptionId;
    }

    public String getDescriptionId(ItemInstance itemInstance) {
        return this.descriptionId;
    }

    public static void main(String[] stringArray) {
        for (Item item : items) {
            if (item == null) continue;
            System.out.println(item.getDescriptionId() + ".name=");
            System.out.println(item.getDescriptionId() + ".desc=");
        }
        System.out.println(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 31);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        System.out.println(calendar.getTimeInMillis());
        calendar.set(1, 2011);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        System.out.println(calendar.getTimeInMillis());
        calendar.setTimeInMillis(1292798324310L);
        System.out.println(new SimpleDateFormat().format(calendar.getTime()));
    }

    public Item setCraftingRemainingItem(Item item) {
        if (this.maxStackSize > 1) {
            throw new IllegalArgumentException("Max stack size must be 1 for items with crafting results");
        }
        this.craftingRemainingItem = item;
        return this;
    }

    public Item getCraftingRemainingItem() {
        return this.craftingRemainingItem;
    }

    public boolean hasCraftingRemainingItem() {
        return this.craftingRemainingItem != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Tier {
        WOOD(0, 59, 2.0f, 0),
        STONE(1, 131, 4.0f, 1),
        IRON(2, 250, 6.0f, 2),
        EMERALD(3, 1561, 8.0f, 3),
        GOLD(0, 32, 12.0f, 0);

        private final int level;
        private final int uses;
        private final float speed;
        private final int damage;

        private Tier(int n2, int n3, float f, int n4) {
            this.level = n2;
            this.uses = n3;
            this.speed = f;
            this.damage = n4;
        }

        public int getUses() {
            return this.uses;
        }

        public float getSpeed() {
            return this.speed;
        }

        public int getAttackDamageBonus() {
            return this.damage;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

