/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class HoeItem
extends Item {
    public HoeItem(int n, Item.Tier tier) {
        super(n);
        this.maxStackSize = 1;
        this.maxDamage = tier.getUses();
    }

    public boolean useOn(ItemInstance itemInstance, Player player, Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getTile(n, n2, n3);
        Material material = level.getMaterial(n, n2 + 1, n3);
        if (!material.isSolid() && n5 == Tile.grass.id || n5 == Tile.dirt.id) {
            Tile tile = Tile.farmland;
            level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, tile.soundType.getStepSound(), (tile.soundType.getVolume() + 1.0f) / 2.0f, tile.soundType.getPitch() * 0.8f);
            if (level.isOnline) {
                return true;
            }
            level.setTile(n, n2, n3, tile.id);
            itemInstance.hurt(1);
            if (level.random.nextInt(8) == 0 && n5 == Tile.grass.id) {
                int n6 = 1;
                for (int i = 0; i < n6; ++i) {
                    float f = 0.7f;
                    float f2 = level.random.nextFloat() * f + (1.0f - f) * 0.5f;
                    float f3 = 1.2f;
                    float f4 = level.random.nextFloat() * f + (1.0f - f) * 0.5f;
                    ItemEntity itemEntity = new ItemEntity(level, (float)n + f2, (float)n2 + f3, (float)n3 + f4, new ItemInstance(Item.seeds));
                    itemEntity.throwTime = 10;
                    level.addEntity(itemEntity);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isHandEquipped() {
        return true;
    }
}

