/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;

public class FishingRodItem
extends Item {
    public FishingRodItem(int n) {
        super(n);
        this.maxDamage = 64;
    }

    public boolean isHandEquipped() {
        return true;
    }

    public boolean isMirroredArt() {
        return true;
    }

    public ItemInstance use(ItemInstance itemInstance, Level level, Player player) {
        if (player.fishing != null) {
            int n = player.fishing.retrieve();
            itemInstance.hurt(n);
            player.swing();
        } else {
            level.playSound(player, "random.bow", 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            if (!level.isOnline) {
                level.addEntity(new FishingHook(level, player));
            }
            player.swing();
        }
        return itemInstance;
    }
}

