/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.ClothTile;
import net.minecraft.world.level.tile.CropTile;
import net.minecraft.world.level.tile.Sapling;
import net.minecraft.world.level.tile.Tile;

public class DyePowderItem
extends Item {
    public static final String[] COLOR_DESCS = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightBlue", "magenta", "orange", "white"};
    public static final int BLACK = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BROWN = 3;
    public static final int BLUE = 4;
    public static final int PURPLE = 5;
    public static final int CYAN = 6;
    public static final int SILVER = 7;
    public static final int GRAY = 8;
    public static final int PINK = 9;
    public static final int LIME = 10;
    public static final int YELLOW = 11;
    public static final int LIGHT_BLUE = 12;
    public static final int MAGENTA = 13;
    public static final int ORANGE = 14;
    public static final int WHITE = 15;

    public DyePowderItem(int n) {
        super(n);
        this.setStackedByData(true);
        this.setMaxDamage(0);
    }

    public int getIcon(ItemInstance itemInstance) {
        int n = itemInstance.getAuxValue();
        return this.icon + n % 8 * 16 + n / 8;
    }

    public String getDescriptionId(ItemInstance itemInstance) {
        return super.getDescriptionId() + "." + COLOR_DESCS[itemInstance.getAuxValue()];
    }

    public boolean useOn(ItemInstance itemInstance, Player player, Level level, int n, int n2, int n3, int n4) {
        if (itemInstance.getAuxValue() == 15) {
            int n5 = level.getTile(n, n2, n3);
            if (n5 == Tile.sapling.id) {
                ((Sapling)Tile.sapling).growTree(level, n, n2, n3, level.random);
                --itemInstance.count;
                return true;
            }
            if (n5 == Tile.crops.id) {
                ((CropTile)Tile.crops).growCropsToMax(level, n, n2, n3);
                --itemInstance.count;
                return true;
            }
        }
        return false;
    }

    public void interactEnemy(ItemInstance itemInstance, Mob mob) {
        if (mob instanceof Sheep) {
            Sheep sheep = (Sheep)mob;
            int n = ClothTile.getTileDataForItemAuxValue(itemInstance.getAuxValue());
            if (!sheep.isSheared() && sheep.getColor() != n) {
                sheep.setColor(n);
                --itemInstance.count;
            }
        }
    }
}

