/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.Tile;

public class DiggerItem
extends Item {
    private Tile[] tiles;
    private float speed = 4.0f;
    private int attackDamage;
    protected Item.Tier tier;

    protected DiggerItem(int n, int n2, Item.Tier tier, Tile[] tileArray) {
        super(n);
        this.tier = tier;
        this.tiles = tileArray;
        this.maxStackSize = 1;
        this.maxDamage = tier.getUses();
        this.speed = tier.getSpeed();
        this.attackDamage = n2 + tier.getAttackDamageBonus();
    }

    public float getDestroySpeed(ItemInstance itemInstance, Tile tile) {
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i] != tile) continue;
            return this.speed;
        }
        return 1.0f;
    }

    public void hurtEnemy(ItemInstance itemInstance, Mob mob) {
        itemInstance.hurt(2);
    }

    public void mineBlock(ItemInstance itemInstance, int n, int n2, int n3, int n4) {
        itemInstance.hurt(1);
    }

    public int getAttackDamage(Entity entity) {
        return this.attackDamage;
    }

    public boolean isHandEquipped() {
        return true;
    }
}

