/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class BucketItem
extends Item {
    private int content;

    public BucketItem(int n, int n2) {
        super(n);
        this.maxStackSize = 1;
        this.maxDamage = 64;
        this.content = n2;
    }

    public ItemInstance use(ItemInstance itemInstance, Level level, Player player) {
        float f;
        float f2;
        float f3;
        double d;
        float f4;
        float f5 = 1.0f;
        float f6 = player.xRotO + (player.xRot - player.xRotO) * f5;
        float f7 = player.yRotO + (player.yRot - player.yRotO) * f5;
        double d2 = player.xo + (player.x - player.xo) * (double)f5;
        double d3 = player.yo + (player.y - player.yo) * (double)f5 + 1.62 - (double)player.heightOffset;
        double d4 = player.zo + (player.z - player.zo) * (double)f5;
        Vec3 vec3 = Vec3.newTemp(d2, d3, d4);
        float f8 = Mth.cos(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f9 = Mth.sin(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f10 = f9 * (f4 = -Mth.cos(-f6 * ((float)Math.PI / 180)));
        Vec3 vec32 = vec3.add((double)f10 * (d = 5.0), (double)(f3 = (f2 = Mth.sin(-f6 * ((float)Math.PI / 180)))) * d, (double)(f = f8 * f4) * d);
        HitResult hitResult = level.clip(vec3, vec32, this.content == 0);
        if (hitResult == null) {
            return itemInstance;
        }
        if (hitResult.type == HitResult.Type.TILE) {
            int n = hitResult.x;
            int n2 = hitResult.y;
            int n3 = hitResult.z;
            if (!level.mayInteract(player, n, n2, n3)) {
                return itemInstance;
            }
            if (this.content == 0) {
                if (level.getMaterial(n, n2, n3) == Material.water && level.getData(n, n2, n3) == 0) {
                    level.setTile(n, n2, n3, 0);
                    return new ItemInstance(Item.bucket_water);
                }
                if (level.getMaterial(n, n2, n3) == Material.lava && level.getData(n, n2, n3) == 0) {
                    level.setTile(n, n2, n3, 0);
                    return new ItemInstance(Item.bucket_lava);
                }
            } else {
                if (this.content < 0) {
                    return new ItemInstance(Item.bucket_empty);
                }
                if (hitResult.f == 0) {
                    --n2;
                }
                if (hitResult.f == 1) {
                    ++n2;
                }
                if (hitResult.f == 2) {
                    --n3;
                }
                if (hitResult.f == 3) {
                    ++n3;
                }
                if (hitResult.f == 4) {
                    --n;
                }
                if (hitResult.f == 5) {
                    ++n;
                }
                if (level.isEmptyTile(n, n2, n3) || !level.getMaterial(n, n2, n3).isSolid()) {
                    if (level.dimension.ultraWarm && this.content == Tile.water.id) {
                        level.playSound(d2 + 0.5, d3 + 0.5, d4 + 0.5, "random.fizz", 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
                        for (int i = 0; i < 8; ++i) {
                            level.addParticle("largesmoke", (double)n + Math.random(), (double)n2 + Math.random(), (double)n3 + Math.random(), 0.0, 0.0, 0.0);
                        }
                    } else {
                        level.setTileAndData(n, n2, n3, this.content, 0);
                    }
                    return new ItemInstance(Item.bucket_empty);
                }
            }
        } else if (this.content == 0 && hitResult.entity instanceof Cow) {
            return new ItemInstance(Item.milk);
        }
        return itemInstance;
    }
}

