/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemInstance;

public class Slot {
    private final int slot;
    private final Container container;
    public int index;
    public int x;
    public int y;

    public Slot(Container container, int n, int n2, int n3) {
        this.container = container;
        this.slot = n;
        this.x = n2;
        this.y = n3;
    }

    public void swap(Slot slot) {
        ItemInstance itemInstance = this.container.getItem(this.slot);
        ItemInstance itemInstance2 = slot.container.getItem(slot.slot);
        if (itemInstance != null && itemInstance.count > slot.getMaxStackSize()) {
            if (itemInstance2 != null) {
                return;
            }
            itemInstance2 = itemInstance.remove(itemInstance.count - slot.getMaxStackSize());
        }
        if (itemInstance2 != null && itemInstance2.count > this.getMaxStackSize()) {
            if (itemInstance != null) {
                return;
            }
            itemInstance = itemInstance2.remove(itemInstance2.count - this.getMaxStackSize());
        }
        slot.container.setItem(slot.slot, itemInstance);
        this.container.setItem(this.slot, itemInstance2);
        this.setChanged();
    }

    public void onTake() {
        this.setChanged();
    }

    public boolean mayPlace(ItemInstance itemInstance) {
        return true;
    }

    public ItemInstance getItem() {
        return this.container.getItem(this.slot);
    }

    public boolean hasItem() {
        return this.getItem() != null;
    }

    public void set(ItemInstance itemInstance) {
        this.container.setItem(this.slot, itemInstance);
        this.setChanged();
    }

    public void setChanged() {
        this.container.setChanged();
    }

    public int getMaxStackSize() {
        return this.container.getMaxStackSize();
    }

    public int getNoItemIcon() {
        return -1;
    }

    public ItemInstance remove(int n) {
        return this.container.removeItem(this.slot, n);
    }

    public boolean isAt(Container container, int n) {
        return container == this.container && n == this.slot;
    }
}

