/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemInstance;

public class MenuBackup {
    private Map<Short, ItemInstance[]> backups = new HashMap<Short, ItemInstance[]>();
    private Inventory inventory;
    private AbstractContainerMenu menu;

    public MenuBackup(Inventory inventory, AbstractContainerMenu abstractContainerMenu) {
        this.inventory = inventory;
        this.menu = abstractContainerMenu;
    }

    public void save(short s) {
        ItemInstance[] itemInstanceArray = new ItemInstance[this.menu.slots.size() + 1];
        itemInstanceArray[0] = ItemInstance.clone(this.inventory.getCarried());
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            itemInstanceArray[i + 1] = ItemInstance.clone(this.menu.slots.get(i).getItem());
        }
        this.backups.put(s, itemInstanceArray);
    }

    public void delete(short s) {
        this.backups.remove(s);
    }

    public void rollback(short s) {
        ItemInstance[] itemInstanceArray = this.backups.get(s);
        this.backups.clear();
        this.inventory.setCarried(itemInstanceArray[0]);
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            this.menu.slots.get(i).set(itemInstanceArray[i + 1]);
        }
    }
}

