/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.tile.Tile;

public class InventoryMenu
extends AbstractContainerMenu {
    public CraftingContainer craftSlots = new CraftingContainer(this, 2, 2);
    public Container resultSlots = new ResultContainer();
    public boolean active = false;

    public InventoryMenu(Inventory inventory) {
        this(inventory, true);
    }

    public InventoryMenu(Inventory inventory, boolean bl) {
        int n;
        int n2;
        this.active = bl;
        this.addSlot(new ResultSlot(this.craftSlots, this.resultSlots, 0, 144, 36));
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.addSlot(new Slot(this.craftSlots, n + n2 * 2, 88 + n * 18, 26 + n2 * 18));
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            n = n2;
            this.addSlot(new Slot(inventory, inventory.getContainerSize() - 1 - n2, 8, 8 + n2 * 18){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemInstance itemInstance) {
                    if (itemInstance.getItem() instanceof ArmorItem) {
                        return ((ArmorItem)itemInstance.getItem()).slot == n;
                    }
                    if (itemInstance.getItem().id == Tile.pumpkin.id) {
                        return n == 0;
                    }
                    return false;
                }
            });
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 9; ++n) {
                this.addSlot(new Slot(inventory, n + (n2 + 1) * 9, 8 + n * 18, 84 + n2 * 18));
            }
        }
        for (n2 = 0; n2 < 9; ++n2) {
            this.addSlot(new Slot(inventory, n2, 8 + n2 * 18, 142));
        }
        this.slotsChanged(this.craftSlots);
    }

    public void slotsChanged(Container container) {
        this.resultSlots.setItem(0, Recipes.getInstance().getItemFor(this.craftSlots));
    }

    public void removed(Player player) {
        super.removed(player);
        for (int i = 0; i < 4; ++i) {
            ItemInstance itemInstance = this.craftSlots.getItem(i);
            if (itemInstance == null) continue;
            player.drop(itemInstance);
            this.craftSlots.setItem(i, null);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

