/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.tile.entity.FurnaceTileEntity;

public class FurnaceMenu
extends AbstractContainerMenu {
    private FurnaceTileEntity furnace;
    private int tc = 0;
    private int lt = 0;
    private int ld = 0;

    public FurnaceMenu(Container container, FurnaceTileEntity furnaceTileEntity) {
        int n;
        this.furnace = furnaceTileEntity;
        this.addSlot(new Slot(furnaceTileEntity, 0, 56, 17));
        this.addSlot(new Slot(furnaceTileEntity, 1, 56, 53));
        this.addSlot(new Slot(furnaceTileEntity, 2, 116, 35));
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 9; ++i) {
                this.addSlot(new Slot(container, i + n * 9 + 9, 8 + i * 18, 84 + n * 18));
            }
        }
        for (n = 0; n < 9; ++n) {
            this.addSlot(new Slot(container, n, 8 + n * 18, 142));
        }
    }

    public void addSlotListener(ContainerListener containerListener) {
        super.addSlotListener(containerListener);
        containerListener.setContainerData(this, 0, this.furnace.tickCount);
        containerListener.setContainerData(this, 1, this.furnace.litTime);
        containerListener.setContainerData(this, 2, this.furnace.litDuration);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            ContainerListener containerListener = (ContainerListener)this.containerListeners.get(i);
            if (this.tc != this.furnace.tickCount) {
                containerListener.setContainerData(this, 0, this.furnace.tickCount);
            }
            if (this.lt != this.furnace.litTime) {
                containerListener.setContainerData(this, 1, this.furnace.litTime);
            }
            if (this.ld == this.furnace.litDuration) continue;
            containerListener.setContainerData(this, 2, this.furnace.litDuration);
        }
        this.tc = this.furnace.tickCount;
        this.lt = this.furnace.litTime;
        this.ld = this.furnace.litDuration;
    }

    public void setData(int n, int n2) {
        if (n == 0) {
            this.furnace.tickCount = n2;
        }
        if (n == 1) {
            this.furnace.litTime = n2;
        }
        if (n == 2) {
            this.furnace.litDuration = n2;
        }
    }

    public boolean stillValid(Player player) {
        return this.furnace.stillValid(player);
    }
}

