/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

public class CraftingMenu
extends AbstractContainerMenu {
    public CraftingContainer craftSlots = new CraftingContainer(this, 3, 3);
    public Container resultSlots = new ResultContainer();
    private Level level;
    private int x;
    private int y;
    private int z;

    public CraftingMenu(Inventory inventory, Level level, int n, int n2, int n3) {
        int n4;
        int n5;
        this.level = level;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.addSlot(new ResultSlot(this.craftSlots, this.resultSlots, 0, 124, 35));
        for (n5 = 0; n5 < 3; ++n5) {
            for (n4 = 0; n4 < 3; ++n4) {
                this.addSlot(new Slot(this.craftSlots, n4 + n5 * 3, 30 + n4 * 18, 17 + n5 * 18));
            }
        }
        for (n5 = 0; n5 < 3; ++n5) {
            for (n4 = 0; n4 < 9; ++n4) {
                this.addSlot(new Slot(inventory, n4 + n5 * 9 + 9, 8 + n4 * 18, 84 + n5 * 18));
            }
        }
        for (n5 = 0; n5 < 9; ++n5) {
            this.addSlot(new Slot(inventory, n5, 8 + n5 * 18, 142));
        }
        this.slotsChanged(this.craftSlots);
    }

    public void slotsChanged(Container container) {
        this.resultSlots.setItem(0, Recipes.getInstance().getItemFor(this.craftSlots));
    }

    public void removed(Player player) {
        super.removed(player);
        for (int i = 0; i < 9; ++i) {
            ItemInstance itemInstance = this.craftSlots.getItem(i);
            if (itemInstance == null) continue;
            player.drop(itemInstance);
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getTile(this.x, this.y, this.z) != Tile.workBench.id) {
            return false;
        }
        return !(player.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > 64.0);
    }
}

